/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.enlinkd.generator.topology;

import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.opennms.enlinkd.generator.topology.PairGenerator;

public class UndirectedPairGenerator<E>
implements PairGenerator<E> {
    private final List<E> elements;
    private final int lastIndexInList;
    private int indexLeft = 0;
    private int indexRight = 0;

    @Override
    public Pair<E, E> next() {
        this.computeIndexForUnique();
        return Pair.of(this.elements.get(this.indexLeft), this.elements.get(this.indexRight));
    }

    public UndirectedPairGenerator(List<E> elements) {
        if (elements == null || elements.size() < 2) {
            throw new IllegalArgumentException("Need at least 2 elements in list to make a pair");
        }
        this.elements = elements;
        this.lastIndexInList = elements.size() - 1;
    }

    private void computeIndexForUnique() {
        this.computeIndex();
        while (this.indexLeft >= this.indexRight) {
            this.computeIndex();
        }
    }

    private void computeIndex() {
        if (this.indexLeft == this.lastIndexInList && this.indexRight == this.lastIndexInList - 1) {
            this.indexLeft = 0;
            this.indexRight = 0;
        } else if (this.indexRight == this.lastIndexInList) {
            this.indexLeft = this.next(this.indexLeft);
        }
        this.indexRight = this.nextButNotSame(this.indexRight, this.indexLeft);
    }

    private int nextButNotSame(int current, int notSame) {
        int value = this.next(current);
        if (value == notSame) {
            value = this.next(value);
        }
        return value;
    }

    private int next(int i) {
        if (i == this.lastIndexInList) {
            return 0;
        }
        return ++i;
    }
}

