/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.asset;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.graphdrawing.graphml.GraphmlType;
import org.opennms.features.graphml.model.GraphML;
import org.opennms.features.graphml.model.GraphMLWriter;
import org.opennms.features.graphml.service.GraphmlRepository;
import org.opennms.features.topology.plugins.topo.asset.AssetGraphDefinitionRepository;
import org.opennms.features.topology.plugins.topo.asset.AssetGraphDefinitionRepositoryImpl;
import org.opennms.features.topology.plugins.topo.asset.AssetGraphGenerator;
import org.opennms.features.topology.plugins.topo.asset.GeneratorConfig;
import org.opennms.features.topology.plugins.topo.asset.GeneratorConfigBuilder;
import org.opennms.features.topology.plugins.topo.asset.GeneratorConfigList;
import org.opennms.features.topology.plugins.topo.asset.NodeProvider;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.model.events.EventUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionOperations;

public class AssetGraphMLProvider
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(AssetGraphMLProvider.class);
    public static final String CREATE_ASSET_TOPOLOGY = "uei.opennms.plugins/assettopology/create";
    public static final String REMOVE_ASSET_TOPOLOGY = "uei.opennms.plugins/assettopology/remove";
    public static final String REGENERATE_ASSET_TOPOLOGY = "uei.opennms.plugins/assettopology/regenerate";
    public static final String REGENERATE_ALL_ASSET_TOPOLOGIES = "uei.opennms.plugins/assettopology/regenerateall";
    private static final List<String> ueiList = Lists.newArrayList((Object[])new String[]{"uei.opennms.plugins/assettopology/create", "uei.opennms.plugins/assettopology/remove", "uei.opennms.plugins/assettopology/regenerate", "uei.opennms.plugins/assettopology/regenerateall"});
    private final EventIpcManager eventIpcManager;
    private final GraphmlRepository graphmlRepository;
    private final TransactionOperations transactionOperations;
    private final NodeProvider nodeProvider;
    private final AssetGraphDefinitionRepository assetGraphDefinitionRepository;

    public AssetGraphMLProvider(GraphmlRepository repository, EventIpcManager eventIpcManager, NodeProvider nodeProvider, TransactionOperations transactionOperations, AssetGraphDefinitionRepositoryImpl assetGraphDefinitionRepository) {
        this.graphmlRepository = Objects.requireNonNull(repository);
        this.eventIpcManager = Objects.requireNonNull(eventIpcManager);
        this.nodeProvider = Objects.requireNonNull(nodeProvider);
        this.transactionOperations = transactionOperations;
        this.assetGraphDefinitionRepository = Objects.requireNonNull(assetGraphDefinitionRepository);
    }

    public synchronized void createAssetTopology(GeneratorConfig config) {
        Objects.requireNonNull(config);
        try {
            LOG.debug("Creating Asset Topology providerId: {}, label: {}, config: {}", new Object[]{config.getProviderId(), config.getLabel(), config});
            if (this.graphmlRepository.exists(config.getProviderId())) {
                throw new IllegalStateException(String.format("GraphML Provider with id '%s' (label: %s) already exists", config.getProviderId(), config.getLabel()));
            }
            if (this.assetGraphDefinitionRepository.exists(config.getProviderId())) {
                throw new IllegalStateException(String.format("Asset Graph Definition with id '%s' (label: %s) already exists", config.getProviderId(), config.getLabel()));
            }
            GraphML graphML = (GraphML)this.transactionOperations.execute(status -> new AssetGraphGenerator(this.nodeProvider).generateGraphs(config));
            GraphmlType graphmlType = GraphMLWriter.convert((GraphML)graphML);
            this.assetGraphDefinitionRepository.addConfigDefinition(config);
            this.graphmlRepository.save(config.getProviderId(), config.getLabel(), graphmlType);
        }
        catch (Exception ex) {
            LOG.error("Could not create Asset Topology", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public synchronized void removeAssetTopology(String providerId) {
        Objects.requireNonNull(providerId);
        try {
            LOG.debug("Removing Asset Topology providerId: {}", (Object)providerId);
            if (!this.assetGraphDefinitionRepository.exists(providerId)) {
                throw new IllegalStateException(String.format("Asset Graph Definition with id '%s' cannot be removed, because it does not exist", providerId));
            }
            this.assetGraphDefinitionRepository.removeConfigDefinition(providerId);
            if (this.graphmlRepository.exists(providerId)) {
                this.graphmlRepository.delete(providerId);
            }
        }
        catch (Exception ex) {
            LOG.error("problem removing asset topology ", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public synchronized void regenerateAssetTopology(String providerId) {
        Objects.requireNonNull(providerId);
        try {
            LOG.debug("Regenerating Asset Topology providerId: {}", (Object)providerId);
            if (!this.assetGraphDefinitionRepository.exists(providerId)) {
                throw new IllegalStateException(String.format("Asset Graph Definition with id '%s' cannot be regenerated, because it does not exist", providerId));
            }
            GeneratorConfig config = this.assetGraphDefinitionRepository.getConfigDefinition(providerId);
            GraphML graphML = (GraphML)this.transactionOperations.execute(status -> new AssetGraphGenerator(this.nodeProvider).generateGraphs(config));
            GraphmlType graphmlType = GraphMLWriter.convert((GraphML)graphML);
            if (this.graphmlRepository.exists(providerId)) {
                this.graphmlRepository.delete(providerId);
            }
            this.graphmlRepository.save(config.getProviderId(), config.getLabel(), graphmlType);
        }
        catch (Exception ex) {
            LOG.error("problem regenerating asset topology ", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public synchronized void regenerateAllAssetTopologies() {
        GeneratorConfigList configList = this.assetGraphDefinitionRepository.getAllConfigDefinitions();
        StringBuilder logmsg = new StringBuilder("Regenerating All Asset Topologies succeeded for providerIds: ");
        StringBuilder errmsg = new StringBuilder("Regenerate All Asset Topologies failed for providerIds: ");
        boolean failed = false;
        for (GeneratorConfig config : configList.getConfigs()) {
            String providerId = config.getProviderId();
            try {
                this.regenerateAssetTopology(providerId);
                logmsg.append("[" + providerId + "]");
            }
            catch (Exception ex) {
                errmsg.append("[" + providerId + "]");
                failed = true;
            }
        }
        LOG.debug(logmsg.toString());
        if (failed) {
            LOG.error(errmsg.toString());
            throw new RuntimeException(errmsg.toString());
        }
    }

    public void init() {
        this.eventIpcManager.addEventListener((EventListener)this, ueiList);
        LOG.info("asset topology provider started");
    }

    public void destroy() {
        this.eventIpcManager.removeEventListener((EventListener)this, ueiList);
        LOG.info("asset topology provider stopped");
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void onEvent(IEvent e) {
        try {
            if (CREATE_ASSET_TOPOLOGY.equals(e.getUei())) {
                GeneratorConfig config = GeneratorConfigBuilder.buildFrom(e);
                this.createAssetTopology(config);
            } else if (REMOVE_ASSET_TOPOLOGY.equals(e.getUei())) {
                String providerId = EventUtils.getParm((IEvent)e, (String)"providerId");
                this.removeAssetTopology(providerId);
            } else if (REGENERATE_ASSET_TOPOLOGY.equals(e.getUei())) {
                String providerId = EventUtils.getParm((IEvent)e, (String)"providerId");
                this.regenerateAssetTopology(providerId);
            } else if (REGENERATE_ALL_ASSET_TOPOLOGIES.equals(e.getUei())) {
                this.regenerateAllAssetTopologies();
            }
        }
        catch (Exception ex) {
            LOG.error("asset topology provider problem processing event " + e.getUei(), (Throwable)ex);
        }
    }
}

