/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.datachoices.internal.usagestatistics;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.sql.DataSource;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.karaf.features.Dependency;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.opennms.core.db.DataSourceFactoryBean;
import org.opennms.core.ipc.sink.common.SinkStrategy;
import org.opennms.core.rpc.common.RpcStrategy;
import org.opennms.core.utils.SystemInfoUtils;
import org.opennms.core.utils.TimeSeries;
import org.opennms.core.web.HttpClientWrapper;
import org.opennms.features.datachoices.internal.StateManager;
import org.opennms.features.datachoices.internal.usagestatistics.UsageStatisticsReportDTO;
import org.opennms.features.deviceconfig.persistence.api.DeviceConfigDao;
import org.opennms.features.usageanalytics.api.UsageAnalyticDao;
import org.opennms.features.usageanalytics.api.UsageAnalyticMetricName;
import org.opennms.netmgt.bsm.persistence.api.BusinessServiceEdgeDao;
import org.opennms.netmgt.config.DestinationPathFactory;
import org.opennms.netmgt.config.GroupFactory;
import org.opennms.netmgt.config.GroupManager;
import org.opennms.netmgt.config.NotifdConfigFactory;
import org.opennms.netmgt.config.ServiceConfigFactory;
import org.opennms.netmgt.config.UserFactory;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.ApplicationDao;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.opennms.netmgt.dao.api.MonitoringSystemDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.NotificationDao;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.dao.api.ProvisiondConfigurationDao;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsageStatisticsReporter
implements StateManager.StateChangeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(UsageStatisticsReporter.class);
    public static final String USAGE_REPORT = "usage-report";
    private static final String JMX_OBJ_OS = "java.lang:type=OperatingSystem";
    private static final String JMX_OBJ_OPENNMS_POLLERD = "OpenNMS:Name=Pollerd";
    private static final String JMX_OBJ_OPENNMS_EVENTLOGS_PROCESS = "org.opennms.netmgt.eventd:name=eventlogs.process,type=timers";
    private static final String JMX_OBJ_OPENNMS_FLOWS_PERSISTED = "org.opennms.netmgt.flows:name=flowsPersisted,type=meters";
    private static final String JMX_OBJ_OPENNMS_REPO_SAMPLE_INSERTED = "org.opennms.newts:name=repository.samples-inserted,type=meters";
    private static final String JMX_OBJ_OPENNMS_QUEUED = "OpenNMS:Name=Queued";
    private static final String JMX_ATTR_FREE_PHYSICAL_MEMORY_SIZE = "FreePhysicalMemorySize";
    private static final String JMX_ATTR_TOTAL_PHYSICAL_MEMORY_SIZE = "TotalPhysicalMemorySize";
    private static final String JMX_ATTR_AVAILABLE_PROCESSORS = "AvailableProcessors";
    private static final String JMX_ATTR_TASKS_COMPLETED = "TasksCompleted";
    private static final String JMX_ATTR_COUNT = "Count";
    private static final String JMX_ATTR_UPDATES_COMPLETED = "UpdatesCompleted";
    private static final MBeanServer M_BEAN_SERVER = ManagementFactory.getPlatformMBeanServer();
    private static final int MAX_DEP_RECURSION_DEPTH = 2;
    private static final String OIA_FEATURE_NAME = "opennms-integration-api";
    private static final String API_LAYER_FEATURE_NAME = "opennms-api-layer";
    public static final String APPLIANCE_VIRTUAL_OID = ".1.3.6.1.4.1.5813.42.5.1";
    public static final String APPLIANCE_MINI_OID = ".1.3.6.1.4.1.5813.42.5.2";
    public static final String APPLIANCE_1U_OID = ".1.3.6.1.4.1.5813.42.5.3";
    private String m_url;
    private long m_interval;
    private Timer m_timer;
    private StateManager m_stateManager;
    private NodeDao m_nodeDao;
    private IpInterfaceDao m_ipInterfaceDao;
    private SnmpInterfaceDao m_snmpInterfaceDao;
    private MonitoredServiceDao m_monitoredServiceDao;
    private EventDao m_eventDao;
    private AlarmDao m_alarmDao;
    private MonitoringLocationDao m_monitoringLocationDao;
    private MonitoringSystemDao m_monitoringSystemDao;
    private BusinessServiceEdgeDao m_businessServiceEdgeDao;
    private DeviceConfigDao m_deviceConfigDao;
    private FeaturesService m_featuresService;
    private ProvisiondConfigurationDao m_provisiondConfigurationDao;
    private ServiceConfigFactory m_serviceConfigurationFactory;
    private DestinationPathFactory m_destinationPathFactory;
    private NotifdConfigFactory m_notifdConfigFactory;
    private UsageAnalyticDao m_usageAnalyticDao;
    private GroupFactory m_groupFactory;
    private ForeignSourceRepository m_deployedForeignSourceRepository;
    private DataSourceFactoryBean m_dataSourceFactoryBean;
    private ApplicationDao m_applicationDao;
    private boolean m_useSystemProxy = true;
    private OutageDao m_outageDao;
    private NotificationDao m_notificationDao;

    public synchronized void init() {
        if (this.m_timer != null) {
            LOG.warn("Usage statistic reporter was already initialized.");
        }
        try {
            if (Boolean.FALSE.equals(this.m_stateManager.isEnabled())) {
                LOG.info("Usage statistic reporting is disabled.");
                return;
            }
            if (Boolean.TRUE.equals(this.m_stateManager.isEnabled())) {
                this.sendAndSchedule();
            }
            LOG.info("Waiting for user confirmation.");
            this.m_stateManager.onIsEnabledChanged(this);
        }
        catch (IOException e) {
            LOG.warn("Failed check opt-in status. Assuming user opted out.", (Throwable)e);
        }
    }

    public synchronized void sendAndSchedule() {
        LOG.info("Scheduling usage statistics report every {} ms", (Object)this.m_interval);
        this.m_timer = new Timer();
        this.m_timer.schedule((TimerTask)new Task(), 0L, this.m_interval);
        this.sendAsync();
    }

    @Override
    public synchronized void onIsEnabledChanged(boolean isEnabled) {
        if (isEnabled && this.m_timer == null) {
            this.sendAndSchedule();
        } else if (!isEnabled && this.m_timer != null) {
            this.destroy();
        }
    }

    public synchronized void destroy() {
        if (this.m_timer != null) {
            LOG.info("Disabling scheduled report.");
            this.m_timer.cancel();
            this.m_timer = null;
        }
    }

    public void sendSync() {
        new Task().run();
    }

    public void sendAsync() {
        Thread thread = new Thread(new Task());
        thread.start();
    }

    public UsageStatisticsReportDTO generateReport() {
        SystemInfoUtils sysInfoUtils = new SystemInfoUtils();
        UsageStatisticsReportDTO usageStatisticsReport = new UsageStatisticsReportDTO();
        try {
            usageStatisticsReport.setSystemId(this.m_stateManager.getOrGenerateSystemId());
        }
        catch (IOException e) {
            LOG.warn("An error occurred while retrieving the system id. The usage report will be submitted with a null system id.", (Throwable)e);
        }
        usageStatisticsReport.setOsName(System.getProperty("os.name"));
        usageStatisticsReport.setOsArch(System.getProperty("os.arch"));
        usageStatisticsReport.setOsVersion(System.getProperty("os.version"));
        usageStatisticsReport.setVersion(sysInfoUtils.getVersion());
        usageStatisticsReport.setPackageName(sysInfoUtils.getPackageName());
        usageStatisticsReport.setNodes(this.m_nodeDao.countAll());
        usageStatisticsReport.setIpInterfaces(this.m_ipInterfaceDao.countAll());
        usageStatisticsReport.setSnmpInterfaces(this.m_snmpInterfaceDao.countAll());
        usageStatisticsReport.setSnmpInterfacesWithFlows(this.m_snmpInterfaceDao.getNumInterfacesWithFlows());
        usageStatisticsReport.setMonitoredServices(this.m_monitoredServiceDao.countAll());
        usageStatisticsReport.setEvents(this.m_eventDao.countAll());
        usageStatisticsReport.setAlarms(this.m_alarmDao.countAll());
        usageStatisticsReport.setSituations(this.m_alarmDao.getNumSituations());
        usageStatisticsReport.setMonitoringLocations(this.m_monitoringLocationDao.countAll());
        usageStatisticsReport.setMinions(this.m_monitoringSystemDao.getNumMonitoringSystems("Minion"));
        usageStatisticsReport.setApplications(this.m_applicationDao.countAll());
        usageStatisticsReport.setOutages(this.m_outageDao.currentOutageCount());
        usageStatisticsReport.setNotifications(this.m_notificationDao.countAll());
        usageStatisticsReport.setNodesBySysOid(this.m_nodeDao.getNumberOfNodesBySysOid());
        usageStatisticsReport.setInstalledFeatures(this.getInstalledFeatures());
        usageStatisticsReport.setInstalledOIAPlugins(this.getInstalledOIAPluginsByDependencyTree());
        this.setJmxAttributes(usageStatisticsReport);
        this.gatherProvisiondData(usageStatisticsReport);
        usageStatisticsReport.setServices(this.m_serviceConfigurationFactory.getServiceNameMap());
        usageStatisticsReport.setGroups(this.getGroupCount());
        usageStatisticsReport.setUsers(this.getUserCount());
        usageStatisticsReport.setDestinationPathCount(this.getDestinationPathCount());
        usageStatisticsReport.setNotificationEnablementStatus(this.getNotificationEnablementStatus());
        usageStatisticsReport.setOnCallRoleCount(this.m_groupFactory.getRoles().size());
        usageStatisticsReport.setRequisitionCount(this.getDeployedRequisitionCount());
        usageStatisticsReport.setRequisitionWithChangedFSCount(this.getDeployedRequisitionWithModifiedFSCount());
        usageStatisticsReport.setBusinessEdgeCount(this.m_businessServiceEdgeDao.countAll());
        usageStatisticsReport.setSinkStrategy(SinkStrategy.getSinkStrategy().getName());
        usageStatisticsReport.setRpcStrategy(RpcStrategy.getRpcStrategy().getName());
        usageStatisticsReport.setTssStrategies(TimeSeries.getTimeseriesStrategy().getName());
        usageStatisticsReport.setDcbSucceed(this.m_usageAnalyticDao.getValueByMetricName(UsageAnalyticMetricName.DCB_SUCCEED.toString()));
        usageStatisticsReport.setDcbFailed(this.m_usageAnalyticDao.getValueByMetricName(UsageAnalyticMetricName.DCB_FAILED.toString()));
        usageStatisticsReport.setDcbWebUiEntries(this.m_usageAnalyticDao.getValueByMetricName(UsageAnalyticMetricName.DCB_WEBUI_ENTRY.toString()));
        usageStatisticsReport.setNodesWithDeviceConfigBySysOid(this.m_deviceConfigDao.getNumberOfNodesWithDeviceConfigBySysOid());
        usageStatisticsReport.setApplianceCounts(this.getApplianceCountByModel());
        usageStatisticsReport.setInContainer(this.isContainerized());
        this.setDatasourceInfo(usageStatisticsReport);
        return usageStatisticsReport;
    }

    private boolean isContainerized() {
        boolean inPodman = new File("/run/.containerenv").exists();
        boolean inDocker = new File("/.dockerenv").exists();
        boolean containerRunning = "container".equals(System.getenv("OPENNMS_EXECUTION_ENVIRONMENT"));
        return inPodman || inDocker || containerRunning;
    }

    private void setJmxAttributes(UsageStatisticsReportDTO usageStatisticsReport) {
        this.setSystemJmxAttributes(usageStatisticsReport);
        this.setOpenNmsJmxAttributes(usageStatisticsReport);
    }

    private void setSystemJmxAttributes(UsageStatisticsReportDTO usageStatisticsReport) {
        Object availableProcessorsObj;
        Object totalPhysicalMemSizeObj;
        Object freePhysicalMemSizeObj = this.getJmxAttribute(JMX_OBJ_OS, JMX_ATTR_FREE_PHYSICAL_MEMORY_SIZE);
        if (freePhysicalMemSizeObj != null) {
            usageStatisticsReport.setFreePhysicalMemorySize((long)((Long)freePhysicalMemSizeObj));
        }
        if ((totalPhysicalMemSizeObj = this.getJmxAttribute(JMX_OBJ_OS, JMX_ATTR_TOTAL_PHYSICAL_MEMORY_SIZE)) != null) {
            usageStatisticsReport.setTotalPhysicalMemorySize((Long)totalPhysicalMemSizeObj);
        }
        if ((availableProcessorsObj = this.getJmxAttribute(JMX_OBJ_OS, JMX_ATTR_AVAILABLE_PROCESSORS)) != null) {
            usageStatisticsReport.setAvailableProcessors((int)((Integer)availableProcessorsObj));
        }
    }

    private void setOpenNmsJmxAttributes(UsageStatisticsReportDTO usageStatisticsReport) {
        Object coreQueuedUpdatesCompletedObj;
        Object coreNewtsSamplesInsertedObj;
        Object coreFlowsPersistedObj;
        Object eventLogsProcessedObj;
        Object pollerTasksCompletedObj = this.getJmxAttribute(JMX_OBJ_OPENNMS_POLLERD, JMX_ATTR_TASKS_COMPLETED);
        if (pollerTasksCompletedObj != null) {
            usageStatisticsReport.setPollsCompleted((Long)pollerTasksCompletedObj);
        }
        if ((eventLogsProcessedObj = this.getJmxAttribute(JMX_OBJ_OPENNMS_EVENTLOGS_PROCESS, JMX_ATTR_COUNT)) != null) {
            usageStatisticsReport.setEventLogsProcessed((Long)eventLogsProcessedObj);
        }
        if ((coreFlowsPersistedObj = this.getJmxAttribute(JMX_OBJ_OPENNMS_FLOWS_PERSISTED, JMX_ATTR_COUNT)) != null) {
            usageStatisticsReport.setCoreFlowsPersisted((Long)coreFlowsPersistedObj);
        }
        if ((coreNewtsSamplesInsertedObj = this.getJmxAttribute(JMX_OBJ_OPENNMS_REPO_SAMPLE_INSERTED, JMX_ATTR_COUNT)) != null) {
            usageStatisticsReport.setCoreNewtsSamplesInserted((Long)coreNewtsSamplesInsertedObj);
        }
        if ((coreQueuedUpdatesCompletedObj = this.getJmxAttribute(JMX_OBJ_OPENNMS_QUEUED, JMX_ATTR_UPDATES_COMPLETED)) != null) {
            usageStatisticsReport.setCoreQueuedUpdatesCompleted((Long)coreQueuedUpdatesCompletedObj);
        }
    }

    private Object getJmxAttribute(String objectName, String attributeName) {
        ObjectName objNameActual;
        try {
            objNameActual = new ObjectName(objectName);
        }
        catch (MalformedObjectNameException e) {
            LOG.warn("Failed to query from object name " + objectName, (Throwable)e);
            return null;
        }
        try {
            return M_BEAN_SERVER.getAttribute(objNameActual, attributeName);
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException e) {
            LOG.warn("Failed to query from attribute name " + attributeName + " on object " + objectName, (Throwable)e);
            return null;
        }
    }

    private long getDeployedRequisitionCount() {
        return this.m_deployedForeignSourceRepository.getRequisitions().size();
    }

    private long getDeployedRequisitionWithModifiedFSCount() {
        ForeignSource defaultFS = this.m_deployedForeignSourceRepository.getDefaultForeignSource();
        return this.m_deployedForeignSourceRepository.getRequisitions().stream().filter(req -> !req.getForeignSource().equals(defaultFS.getName())).count();
    }

    void setDatasourceInfo(UsageStatisticsReportDTO usageStatisticsReport) {
        try {
            DataSource datasource = this.m_dataSourceFactoryBean.getObject();
            try (Connection connection = datasource.getConnection();){
                DatabaseMetaData metaData = connection.getMetaData();
                usageStatisticsReport.setDatabaseProductName(metaData.getDatabaseProductName());
                usageStatisticsReport.setDatabaseProductVersion(metaData.getDatabaseProductVersion());
            }
        }
        catch (Exception e) {
            LOG.error("Error retrieving datasource information", (Throwable)e);
        }
    }

    private int getUserCount() {
        try {
            UserFactory.init();
            UserManager userFactory = UserFactory.getInstance();
            return userFactory.getUsers().size();
        }
        catch (Exception e) {
            return 0;
        }
    }

    private int getGroupCount() {
        try {
            GroupFactory.init();
            GroupManager groupFactory = GroupFactory.getInstance();
            return groupFactory.getGroups().size();
        }
        catch (Exception e) {
            return 0;
        }
    }

    private String getInstalledFeatures() {
        Object installedFeatures;
        try {
            installedFeatures = Arrays.stream(this.m_featuresService.listInstalledFeatures()).map(f -> f.getName() + "/" + f.getVersion()).sorted().collect(Collectors.joining(","));
        }
        catch (Exception e) {
            installedFeatures = "ERROR: Failed to enumerate the installed features: " + e.getMessage();
        }
        return installedFeatures;
    }

    private String getInstalledOIAPluginsByDependencyTree() {
        List<Feature> featuresDependentOnOIA = new ArrayList<Feature>();
        ArrayList<String> featuresToIgnore = new ArrayList<String>();
        featuresToIgnore.add(API_LAYER_FEATURE_NAME);
        try {
            for (Feature feature : this.m_featuresService.listInstalledFeatures()) {
                featuresDependentOnOIA = this.recurse(feature, featuresDependentOnOIA, featuresToIgnore, 0);
            }
        }
        catch (Exception e) {
            return "ERROR: Failed to enumerate the installed features: " + e.getMessage();
        }
        return featuresDependentOnOIA.stream().map(f -> f.getName() + "/" + f.getVersion()).sorted().collect(Collectors.joining(","));
    }

    private List<Feature> recurse(Feature feature, List<Feature> oiaDependentFeatures, List<String> featuresToIgnore, int depth) {
        if (featuresToIgnore.contains(feature.getName())) {
            return oiaDependentFeatures;
        }
        if (oiaDependentFeatures.contains(feature)) {
            return oiaDependentFeatures;
        }
        for (Dependency dep : feature.getDependencies()) {
            if (!dep.getName().equals(OIA_FEATURE_NAME)) continue;
            oiaDependentFeatures.add(feature);
            return oiaDependentFeatures;
        }
        if (depth >= 2) {
            return oiaDependentFeatures;
        }
        for (Dependency dep : feature.getDependencies()) {
            if (!oiaDependentFeatures.stream().map(d -> d.getName()).anyMatch(str -> str.equals(dep.getName()))) continue;
            oiaDependentFeatures.add(feature);
            return oiaDependentFeatures;
        }
        featuresToIgnore.add(feature.getName());
        for (Dependency dep : feature.getDependencies()) {
            try {
                Feature depFeature;
                int numDependencies = oiaDependentFeatures.size();
                if (numDependencies >= (oiaDependentFeatures = this.recurse(depFeature = this.m_featuresService.getFeature(dep.getName()), oiaDependentFeatures, featuresToIgnore, depth++)).size()) continue;
                oiaDependentFeatures.add(feature);
                return oiaDependentFeatures;
            }
            catch (Exception exception) {
            }
        }
        return oiaDependentFeatures;
    }

    private Map<String, Long> getApplianceCountByModel() {
        HashMap<String, Long> appliances = new HashMap<String, Long>();
        Map oidMap = this.m_nodeDao.getNumberOfNodesBySysOid();
        appliances.put("virtualAppliance", oidMap.containsKey(APPLIANCE_VIRTUAL_OID) ? (Long)oidMap.get(APPLIANCE_VIRTUAL_OID) : 0L);
        appliances.put("applianceMini", oidMap.containsKey(APPLIANCE_MINI_OID) ? (Long)oidMap.get(APPLIANCE_MINI_OID) : 0L);
        appliances.put("appliance1U", oidMap.containsKey(APPLIANCE_1U_OID) ? (Long)oidMap.get(APPLIANCE_1U_OID) : 0L);
        return appliances;
    }

    public void setUrl(String url) {
        this.m_url = url;
    }

    public void setInterval(long interval) {
        this.m_interval = interval;
    }

    public void setStateManager(StateManager stateManager) {
        this.m_stateManager = stateManager;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }

    public void setSnmpInterfaceDao(SnmpInterfaceDao snmpInterfaceDao) {
        this.m_snmpInterfaceDao = snmpInterfaceDao;
    }

    public void setMonitoredServiceDao(MonitoredServiceDao monitoredServiceDao) {
        this.m_monitoredServiceDao = monitoredServiceDao;
    }

    public void setEventDao(EventDao eventDao) {
        this.m_eventDao = eventDao;
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    public void setMonitoringLocationDao(MonitoringLocationDao monitoringLocationDao) {
        this.m_monitoringLocationDao = monitoringLocationDao;
    }

    public void setMonitoringSystemDao(MonitoringSystemDao monitoringSystemDao) {
        this.m_monitoringSystemDao = monitoringSystemDao;
    }

    public void setBusinessServiceEdgeDao(BusinessServiceEdgeDao businessServiceDao) {
        this.m_businessServiceEdgeDao = businessServiceDao;
    }

    public void setOutageDao(OutageDao outageDao) {
        this.m_outageDao = outageDao;
    }

    public void setNotificationDao(NotificationDao notificationDao) {
        this.m_notificationDao = notificationDao;
    }

    public void setFeaturesService(FeaturesService featuresService) {
        this.m_featuresService = featuresService;
    }

    public void setApplicationDao(ApplicationDao applicationDao) {
        this.m_applicationDao = applicationDao;
    }

    public void setUseSystemProxy(boolean useSystemProxy) {
        this.m_useSystemProxy = useSystemProxy;
    }

    public ProvisiondConfigurationDao getProvisiondConfigurationDao() {
        return this.m_provisiondConfigurationDao;
    }

    public void setProvisiondConfigurationDao(ProvisiondConfigurationDao provisiondConfigurationDao) {
        this.m_provisiondConfigurationDao = provisiondConfigurationDao;
    }

    public void setDataSourceFactoryBean(DataSourceFactoryBean dataSourceFactoryBean) {
        this.m_dataSourceFactoryBean = dataSourceFactoryBean;
    }

    public void setUsageAnalyticDao(UsageAnalyticDao usageAnalyticDao) {
        this.m_usageAnalyticDao = usageAnalyticDao;
    }

    private void gatherProvisiondData(UsageStatisticsReportDTO usageStatisticsReport) {
        try {
            usageStatisticsReport.setProvisiondImportThreadPoolSize(this.m_provisiondConfigurationDao.getImportThreads().intValue());
            usageStatisticsReport.setProvisiondRescanThreadPoolSize(this.m_provisiondConfigurationDao.getRescanThreads().intValue());
            usageStatisticsReport.setProvisiondScanThreadPoolSize(this.m_provisiondConfigurationDao.getScanThreads().intValue());
            usageStatisticsReport.setProvisiondWriteThreadPoolSize(this.m_provisiondConfigurationDao.getWriteThreads().intValue());
            usageStatisticsReport.setProvisiondRequisitionSchemeCount(this.m_provisiondConfigurationDao.getRequisitionSchemeCount());
        }
        catch (IOException e) {
            LOG.error("Error retrieving provisiond configuration", (Throwable)e);
        }
    }

    public ServiceConfigFactory getServiceConfigurationFactory() {
        return this.m_serviceConfigurationFactory;
    }

    public void setServiceConfigurationFactory(ServiceConfigFactory serviceConfigurationFactory) {
        this.m_serviceConfigurationFactory = serviceConfigurationFactory;
    }

    public void setDestinationPathFactory(DestinationPathFactory destinationPathFactory) {
        this.m_destinationPathFactory = destinationPathFactory;
    }

    public void setNotifdConfigFactory(NotifdConfigFactory notifdConfigFactory) {
        this.m_notifdConfigFactory = notifdConfigFactory;
    }

    public void setGroupFactory(GroupFactory groupFactory) {
        this.m_groupFactory = groupFactory;
    }

    public void setDeployedForeignSourceRepository(ForeignSourceRepository fsRepo) {
        this.m_deployedForeignSourceRepository = fsRepo;
    }

    public ForeignSourceRepository getDeployedForeignSourceRepository() {
        return this.m_deployedForeignSourceRepository;
    }

    public void setDeviceConfigDao(DeviceConfigDao deviceConfigDao) {
        this.m_deviceConfigDao = deviceConfigDao;
    }

    private int getDestinationPathCount() {
        try {
            return this.m_destinationPathFactory.getPaths().size();
        }
        catch (IOException e) {
            return -1;
        }
    }

    private Boolean getNotificationEnablementStatus() {
        try {
            String bool;
            switch (bool = this.m_notifdConfigFactory.getNotificationStatus()) {
                case "on": {
                    return true;
                }
                case "off": {
                    return false;
                }
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private class Task
    extends TimerTask {
        private Task() {
        }

        @Override
        public void run() {
            UsageStatisticsReportDTO usageStatsReport = UsageStatisticsReporter.this.generateReport();
            String usageStatsReportJson = usageStatsReport.toJson();
            HttpClientWrapper clientWrapper = HttpClientWrapper.create().setConnectionTimeout(Integer.valueOf(30000)).setSocketTimeout(Integer.valueOf(30000));
            if (UsageStatisticsReporter.this.m_useSystemProxy) {
                clientWrapper.useSystemProxySettings();
            }
            try (CloseableHttpClient client = clientWrapper.getClient();){
                HttpPost httpRequest = new HttpPost(UsageStatisticsReporter.this.m_url + UsageStatisticsReporter.USAGE_REPORT);
                httpRequest.setEntity((HttpEntity)new StringEntity(usageStatsReportJson, ContentType.create((String)"application/json", (Charset)StandardCharsets.UTF_8)));
                LOG.info("Sending usage statistics report to {}: {}", (Object)httpRequest.getURI(), (Object)usageStatsReportJson);
                client.execute((HttpUriRequest)httpRequest);
                LOG.info("Succesfully sent usage statistics report.");
            }
            catch (IOException e) {
                LOG.info("The usage statistics report was not succesfully delivered: {}", (Object)e.getMessage());
            }
        }
    }
}

