/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.sysprops;

import java.math.BigDecimal;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemProperties {
    private static final Logger LOG = LoggerFactory.getLogger(SystemProperties.class);

    public static BigDecimal getBigDecimal(String propertyName) {
        return SystemProperties.getBigDecimal(propertyName, null);
    }

    public static BigDecimal getBigDecimal(String propertyName, BigDecimal defaultValue) {
        Function<String, BigDecimal> resolver = propertyValue -> new BigDecimal((String)propertyValue);
        return SystemProperties.getProperty(propertyName, defaultValue, resolver);
    }

    public static Long getLong(String propertyName) {
        return SystemProperties.getLong(propertyName, null);
    }

    public static Long getLong(String propertyName, int defaultValue) {
        Long result = SystemProperties.getLong(propertyName, null);
        return result == null ? Long.valueOf(defaultValue) : result;
    }

    public static Long getLong(String propertyName, Long defaultValue) {
        Function<String, Long> resolver = propertyValue -> Long.parseLong(propertyValue);
        return SystemProperties.getProperty(propertyName, defaultValue, resolver);
    }

    public static Integer getInteger(String propertyName) {
        return SystemProperties.getInteger(propertyName, null);
    }

    public static Integer getInteger(String propertyName, int defaultValue) {
        Integer result = SystemProperties.getInteger(propertyName, null);
        return result == null ? Integer.valueOf(defaultValue) : result;
    }

    public static Integer getInteger(String propertyName, Integer defaultValue) {
        Function<String, Integer> resolver = propertyValue -> Integer.parseInt(propertyValue);
        return SystemProperties.getProperty(propertyName, defaultValue, resolver);
    }

    private static <T> T getProperty(String propertyName, T defaultValue, Function<String, T> transformer) {
        String valueAsString = System.getProperty(propertyName);
        if (valueAsString == null) {
            return defaultValue;
        }
        try {
            return transformer.apply(valueAsString);
        }
        catch (NumberFormatException e) {
            String message = String.format("cannot parse system property: %s with value=%s, using default=%s instead.", propertyName, valueAsString, defaultValue);
            LOG.warn(message, e);
            return defaultValue;
        }
    }

    public static Boolean getBooleanWithDefaultAsTrue(String name) {
        boolean defaultValue = true;
        try {
            String singleTopic = System.getProperty(name);
            if (singleTopic != null) {
                defaultValue = !singleTopic.equalsIgnoreCase("false");
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return defaultValue;
    }
}

