/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal.decision;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opennms.netmgt.flows.classification.ClassificationRequest;
import org.opennms.netmgt.flows.classification.FilterService;
import org.opennms.netmgt.flows.classification.internal.decision.Bounds;
import org.opennms.netmgt.flows.classification.internal.decision.Classifier;
import org.opennms.netmgt.flows.classification.internal.decision.PreprocessedRule;
import org.opennms.netmgt.flows.classification.internal.decision.Threshold;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Tree {
    private static Logger LOG = LoggerFactory.getLogger(Tree.class);
    public static final Tree EMPTY = Leaf.EMPTY;
    public final Info info;

    public static Tree of(List<PreprocessedRule> rules, FilterService filterService) throws InterruptedException {
        return Tree.of(rules, Bounds.ANY, 0, filterService);
    }

    private static Tree of(List<PreprocessedRule> rules, Bounds bounds, int depth, FilterService filterService) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        int ruleSetSize = rules.size();
        if (ruleSetSize <= 1) {
            LOG.trace("Leaf - depth: " + depth + "; rules: " + ruleSetSize);
            return Tree.leaf(rules, filterService, bounds);
        }
        Map.Entry entry = ((Stream)Tree.thresholds(rules).distinct().parallel()).filter(t -> t.canRestrict(bounds)).map(t -> Map.entry(t, t.match(rules, bounds))).filter(e -> Tree.maximumSize(e) < ruleSetSize).min(Comparator.comparingLong(Tree.equallyPartitionedCriteria(ruleSetSize))).orElse(null);
        if (entry != null) {
            LOG.trace("Node - depth: " + depth + "; rules: " + ruleSetSize + "; threshold: " + entry.getKey() + "; maximum child size: " + Tree.maximumSize(entry) + "; lt: " + ((Threshold.Matches)entry.getValue()).lt.size() + "; eq: " + ((Threshold.Matches)entry.getValue()).eq.size() + "; gt: " + ((Threshold.Matches)entry.getValue()).gt.size() + "; na: " + ((Threshold.Matches)entry.getValue()).na.size());
            Tree lt = Tree.of(((Threshold.Matches)entry.getValue()).lt, ((Threshold)entry.getKey()).lt(bounds), depth + 1, filterService);
            Tree eq = Tree.of(((Threshold.Matches)entry.getValue()).eq, ((Threshold)entry.getKey()).eq(bounds), depth + 1, filterService);
            Tree gt = Tree.of(((Threshold.Matches)entry.getValue()).gt, ((Threshold)entry.getKey()).gt(bounds), depth + 1, filterService);
            Tree na = Tree.of(((Threshold.Matches)entry.getValue()).na, bounds, depth + 1, filterService);
            return Tree.node((Threshold)entry.getKey(), lt, eq, gt, na);
        }
        LOG.trace("Leaf - depth: " + depth + "; rules: " + ruleSetSize);
        return Tree.leaf(rules, filterService, bounds);
    }

    private static ToLongFunction<Map.Entry<Threshold, Threshold.Matches>> equallyPartitionedCriteria(int ruleSetSize) {
        long mean = (long)ruleSetSize / 4L;
        ToLongFunction<Integer> f = i -> ((long)i.intValue() - mean) * ((long)i.intValue() - mean);
        return entry -> {
            Threshold.Matches m = (Threshold.Matches)entry.getValue();
            return f.applyAsLong(m.lt.size()) + f.applyAsLong(m.eq.size()) + f.applyAsLong(m.gt.size()) + f.applyAsLong(m.na.size());
        };
    }

    private static int maximumSize(Map.Entry<Threshold, Threshold.Matches> entry) {
        Threshold.Matches m = entry.getValue();
        return Math.max(Math.max(Math.max(m.lt.size(), m.eq.size()), m.gt.size()), m.na.size());
    }

    private static Stream<Threshold> thresholds(Collection<PreprocessedRule> ruleSet) {
        return ruleSet.stream().flatMap(rule -> rule.thresholds.stream());
    }

    private static Tree node(Threshold threshold, Tree lt, Tree eq, Tree gt, Tree na) {
        if (na.isEmpty()) {
            int leaves = lt.info.leaves + eq.info.leaves + gt.info.leaves;
            int sumComp = leaves + lt.info.sumComp + eq.info.sumComp + gt.info.sumComp;
            Info info = new Info(1 + Math.min(Math.min(lt.info.minDepth, eq.info.minDepth), gt.info.minDepth), 1 + Math.max(Math.max(lt.info.maxDepth, eq.info.maxDepth), gt.info.maxDepth), leaves + lt.info.sumDepth + eq.info.sumDepth + gt.info.sumDepth, Math.min(Math.min(lt.info.minLeafSize, eq.info.minLeafSize), gt.info.minLeafSize), Math.max(Math.max(lt.info.maxLeafSize, eq.info.maxLeafSize), gt.info.maxLeafSize), lt.info.sumLeafSize + eq.info.sumLeafSize + gt.info.sumLeafSize, 1 + lt.info.nodes + eq.info.nodes + gt.info.nodes, leaves, lt.info.choices + eq.info.choices + gt.info.choices, 1 + Math.min(Math.min(lt.info.minComp, eq.info.minComp), gt.info.minComp), 1 + Math.max(Math.max(lt.info.maxComp, eq.info.maxComp), gt.info.maxComp), sumComp);
            return new Node.WithoutChoice(info, threshold, lt, eq, gt);
        }
        int nonNaLeaves = lt.info.leaves + eq.info.leaves + gt.info.leaves;
        int leaves = nonNaLeaves + na.info.leaves;
        double naBoost = 1.0 + (double)nonNaLeaves / (double)leaves;
        int sumComp = leaves + lt.info.sumComp + eq.info.sumComp + gt.info.sumComp + (int)(naBoost * (double)na.info.sumComp);
        Info info = new Info(1 + Math.min(Math.min(Math.min(lt.info.minDepth, eq.info.minDepth), gt.info.minDepth), na.info.minDepth), 1 + Math.max(Math.max(Math.max(lt.info.maxDepth, eq.info.maxDepth), gt.info.maxDepth), na.info.maxDepth), leaves + lt.info.sumDepth + eq.info.sumDepth + gt.info.sumDepth + na.info.sumDepth, Math.min(Math.min(Math.min(lt.info.minLeafSize, eq.info.minLeafSize), gt.info.minLeafSize), na.info.minLeafSize), Math.max(Math.max(Math.max(lt.info.maxLeafSize, eq.info.maxLeafSize), gt.info.maxLeafSize), na.info.maxLeafSize), lt.info.sumLeafSize + eq.info.sumLeafSize + gt.info.sumLeafSize + na.info.sumLeafSize, 1 + lt.info.nodes + eq.info.nodes + gt.info.nodes + na.info.nodes, leaves, 1 + lt.info.choices + eq.info.choices + gt.info.choices + na.info.choices, 1 + Math.min(Math.min(lt.info.minComp, eq.info.minComp), gt.info.minComp) + na.info.minComp, 1 + Math.max(Math.max(lt.info.maxComp, eq.info.maxComp), gt.info.maxComp) + na.info.maxComp, sumComp);
        return new Node.WithChoice(info, threshold, lt, eq, gt, na);
    }

    protected Tree(Info info) {
        this.info = info;
    }

    public final String classify(ClassificationRequest request) {
        Classifier c;
        Classifiers classifiers = this.classifiers(request);
        if (classifiers == null) {
            return null;
        }
        Classifier firstInSplit = null;
        Classifier.Result result = null;
        while ((c = classifiers.next()) != null) {
            Classifier.Result r;
            if (firstInSplit == null) {
                firstInSplit = c;
            } else if (c.compareTo(firstInSplit) != 0) {
                if (result != null) {
                    return result.name;
                }
                firstInSplit = c;
            }
            if ((r = c.classify(request)) == null || result != null && r.matchedAspects <= result.matchedAspects) continue;
            result = r;
        }
        return result != null ? result.name : null;
    }

    public abstract <T> T accept(Visitor<T> var1);

    protected abstract boolean isEmpty();

    protected abstract Classifiers classifiers(ClassificationRequest var1);

    private static Leaf leaf(List<PreprocessedRule> ruleSet, FilterService filterService, Bounds bounds) {
        if (ruleSet.isEmpty()) {
            return Leaf.EMPTY;
        }
        if (ruleSet.size() == 1) {
            return new Leaf.WithClassifiers(ruleSet.get(0).createClassifier(filterService, bounds));
        }
        List<Classifier> sorted = ruleSet.stream().map(r -> r.createClassifier(filterService, bounds)).sorted().collect(Collectors.toList());
        return new Leaf.WithClassifiers(sorted);
    }

    public static Classifiers merge(Classifiers i1, Classifiers i2) {
        if (i1 != null && i2 != null) {
            return new MergeSortedClassifiers(i1, i2);
        }
        if (i1 != null) {
            return i1;
        }
        return i2;
    }

    public static interface Visitor<T> {
        public T visit(Node.WithChoice var1);

        public T visit(Node.WithoutChoice var1);

        public T visit(Leaf.Empty var1);

        public T visit(Leaf.WithClassifiers var1);
    }

    private static class MergeSortedClassifiers
    implements Classifiers {
        private Classifiers i1;
        private Classifiers i2;
        private Classifier n1;
        private Classifier n2;

        public MergeSortedClassifiers(Classifiers i1, Classifiers i2) {
            this.i1 = i1;
            this.i2 = i2;
        }

        @Override
        public Classifier next() {
            Classifier res;
            if (this.n1 == null && this.i1 != null) {
                this.n1 = this.i1.next();
                if (this.n1 == null) {
                    this.i1 = null;
                }
            }
            if (this.n2 == null && this.i2 != null) {
                this.n2 = this.i2.next();
                if (this.n2 == null) {
                    this.i2 = null;
                }
            }
            if (this.n1 != null && this.n2 != null) {
                if (this.n1.compareTo(this.n2) <= 0) {
                    res = this.n1;
                    this.n1 = null;
                } else {
                    res = this.n2;
                    this.n2 = null;
                }
            } else if (this.n1 != null) {
                res = this.n1;
                this.n1 = null;
            } else if (this.n2 != null) {
                res = this.n2;
                this.n2 = null;
            } else {
                res = null;
            }
            return res;
        }
    }

    private static class ListClassifiers
    implements Classifiers {
        private final List<Classifier> list;
        private int pos = 0;

        public ListClassifiers(List<Classifier> list) {
            this.list = list;
        }

        @Override
        public Classifier next() {
            return this.pos < this.list.size() ? this.list.get(this.pos++) : null;
        }
    }

    private static interface Classifiers {
        public Classifier next();
    }

    public static abstract class Leaf
    extends Tree {
        public static final Leaf EMPTY = new Empty();

        public Leaf(Info info) {
            super(info);
        }

        public static final class WithClassifiers
        extends Leaf {
            public final List<Classifier> classifiers;

            public WithClassifiers(List<Classifier> classifiers) {
                super(Info.forLeaf(classifiers.size()));
                this.classifiers = classifiers;
            }

            public WithClassifiers(Classifier classifier) {
                this(Collections.singletonList(classifier));
            }

            @Override
            public Classifiers classifiers(ClassificationRequest request) {
                return new ListClassifiers(this.classifiers);
            }

            @VisibleForTesting
            public Collection<Classifier> classifiers() {
                return this.classifiers;
            }

            @Override
            protected boolean isEmpty() {
                return false;
            }

            @Override
            public <T> T accept(Visitor<T> visitor) {
                return visitor.visit(this);
            }

            public String toString() {
                return "WithClassifiers{classifiers=" + this.classifiers + "}";
            }
        }

        public static final class Empty
        extends Leaf {
            public Empty() {
                super(Info.forLeaf(0));
            }

            @Override
            public Classifiers classifiers(ClassificationRequest request) {
                return null;
            }

            @Override
            protected boolean isEmpty() {
                return true;
            }

            @Override
            public <T> T accept(Visitor<T> visitor) {
                return visitor.visit(this);
            }

            public String toString() {
                return "Empty{}";
            }
        }
    }

    public static abstract class Node
    extends Tree {
        public final Threshold threshold;

        public Node(Info info, Threshold threshold) {
            super(info);
            this.threshold = threshold;
        }

        @Override
        protected boolean isEmpty() {
            return false;
        }

        public static final class WithChoice
        extends Node {
            public final Tree lt;
            public final Tree eq;
            public final Tree gt;
            public final Tree na;

            public WithChoice(Info info, Threshold threshold, Tree lt, Tree eq, Tree gt, Tree na) {
                super(info, threshold);
                this.lt = lt;
                this.eq = eq;
                this.gt = gt;
                this.na = na;
            }

            @Override
            public Classifiers classifiers(ClassificationRequest request) {
                switch (this.threshold.compare(request)) {
                    case LT: {
                        return WithChoice.merge(this.lt.classifiers(request), this.na.classifiers(request));
                    }
                    case EQ: {
                        return WithChoice.merge(this.eq.classifiers(request), this.na.classifiers(request));
                    }
                    case GT: {
                        return WithChoice.merge(this.gt.classifiers(request), this.na.classifiers(request));
                    }
                    case NA: {
                        return this.na.classifiers(request);
                    }
                }
                return null;
            }

            @Override
            public <T> T accept(Visitor<T> visitor) {
                return visitor.visit(this);
            }

            public String toString() {
                return "WithChoice{threshold=" + this.threshold + ", info=" + this.info + "}";
            }
        }

        public static final class WithoutChoice
        extends Node {
            public final Tree lt;
            public final Tree eq;
            public final Tree gt;

            public WithoutChoice(Info info, Threshold threshold, Tree lt, Tree eq, Tree gt) {
                super(info, threshold);
                this.lt = lt;
                this.eq = eq;
                this.gt = gt;
            }

            @Override
            public Classifiers classifiers(ClassificationRequest request) {
                switch (this.threshold.compare(request)) {
                    case LT: {
                        return this.lt.classifiers(request);
                    }
                    case EQ: {
                        return this.eq.classifiers(request);
                    }
                    case GT: {
                        return this.gt.classifiers(request);
                    }
                }
                return null;
            }

            @Override
            public <T> T accept(Visitor<T> visitor) {
                return visitor.visit(this);
            }

            public String toString() {
                return "WithoutChoice{threshold=" + this.threshold + ", info=" + this.info + "}";
            }
        }
    }

    public static class Info {
        public static Info FOR_LEAVE_WITH_0_RULES = new Info(0L);
        public static Info FOR_LEAVE_WITH_1_RULE = new Info(1L);
        public static Info FOR_LEAVE_WITH_2_RULES = new Info(2L);
        public static Info FOR_LEAVE_WITH_3_RULES = new Info(3L);
        public final int minDepth;
        public final int maxDepth;
        public final int sumDepth;
        public final long minLeafSize;
        public final long maxLeafSize;
        public final long sumLeafSize;
        public final int nodes;
        public final int leaves;
        public final int choices;
        public final int minComp;
        public final int maxComp;
        public final int sumComp;

        public static Info forLeaf(int ruleSetSize) {
            switch (ruleSetSize) {
                case 0: {
                    return FOR_LEAVE_WITH_0_RULES;
                }
                case 1: {
                    return FOR_LEAVE_WITH_1_RULE;
                }
                case 2: {
                    return FOR_LEAVE_WITH_2_RULES;
                }
                case 3: {
                    return FOR_LEAVE_WITH_3_RULES;
                }
            }
            return new Info(ruleSetSize);
        }

        public Info(int minDepth, int maxDepth, int sumDepth, long minLeafSize, long maxLeafSize, long sumLeafSize, int nodes, int leaves, int choices, int minComp, int maxComp, int sumComp) {
            this.minDepth = minDepth;
            this.maxDepth = maxDepth;
            this.sumDepth = sumDepth;
            this.minLeafSize = minLeafSize;
            this.maxLeafSize = maxLeafSize;
            this.sumLeafSize = sumLeafSize;
            this.nodes = nodes;
            this.leaves = leaves;
            this.choices = choices;
            this.minComp = minComp;
            this.maxComp = maxComp;
            this.sumComp = sumComp;
        }

        public Info(long leafSize) {
            this(0, 0, 0, leafSize, leafSize, leafSize, 0, 1, 0, 0, 0, 0);
        }

        public String toString() {
            return "Info{depth(min/max/avg)=" + this.minDepth + "/" + this.maxDepth + "/" + String.format("%.2f", (double)this.sumDepth / (double)this.leaves) + ", comp(min/max/avg)=" + this.minComp + "/" + this.maxComp + "/" + String.format("%.2f", (double)this.sumComp / (double)this.leaves) + ", ruleSetSize(min/max/avg)=" + this.minLeafSize + "/" + this.maxLeafSize + "/" + String.format("%.2f", (double)this.sumLeafSize / (double)this.leaves) + ", nodes=" + this.nodes + ", leaves=" + this.leaves + ", choices=" + this.choices + "}";
        }
    }
}

