/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal.decision;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.opennms.core.network.IPPortRange;
import org.opennms.netmgt.flows.classification.ClassificationRequest;
import org.opennms.netmgt.flows.classification.IpAddr;
import org.opennms.netmgt.flows.classification.internal.decision.Bound;
import org.opennms.netmgt.flows.classification.internal.decision.Bounds;
import org.opennms.netmgt.flows.classification.internal.decision.PreprocessedRule;
import org.opennms.netmgt.flows.classification.internal.value.IpRange;
import org.opennms.netmgt.flows.classification.internal.value.IpValue;
import org.opennms.netmgt.flows.classification.internal.value.PortValue;

public abstract class Threshold<T extends Comparable<T>> {
    protected final Function<Bounds, Bound<T>> getBound;
    private final BiFunction<Bounds, Bound<T>, Bounds> setBound;

    public Threshold(Function<Bounds, Bound<T>> getBound, BiFunction<Bounds, Bound<T>, Bounds> setBound) {
        this.getBound = getBound;
        this.setBound = setBound;
    }

    public abstract T getThreshold();

    public Matches match(Collection<PreprocessedRule> ruleSet, Bounds bounds) {
        ArrayList<PreprocessedRule> lt = new ArrayList<PreprocessedRule>();
        ArrayList<PreprocessedRule> eq = new ArrayList<PreprocessedRule>();
        ArrayList<PreprocessedRule> gt = new ArrayList<PreprocessedRule>();
        ArrayList<PreprocessedRule> na = new ArrayList<PreprocessedRule>();
        for (PreprocessedRule rule : ruleSet) {
            Match cr = this.match(rule, bounds);
            if (cr.lt) {
                lt.add(rule);
            }
            if (cr.eq) {
                eq.add(rule);
            }
            if (cr.gt) {
                gt.add(rule);
            }
            if (!cr.na) continue;
            na.add(rule);
        }
        return new Matches(Threshold.optimize(lt), Threshold.optimize(eq), Threshold.optimize(gt), Threshold.optimize(na));
    }

    private static <T> List<T> optimize(List<T> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return Collections.singletonList(list.get(0));
        }
        return list;
    }

    public abstract Order compare(ClassificationRequest var1);

    public final boolean canRestrict(Bounds bounds) {
        return this.getBound.apply(bounds).canBeRestrictedBy(this.getThreshold());
    }

    public final Bounds lt(Bounds bounds) {
        return this.setBound.apply(bounds, this.getBound.apply(bounds).lt(this.getThreshold()));
    }

    public final Bounds eq(Bounds bounds) {
        return this.setBound.apply(bounds, this.getBound.apply(bounds).eq(this.getThreshold()));
    }

    public final Bounds gt(Bounds bounds) {
        return this.setBound.apply(bounds, this.getBound.apply(bounds).gt(this.getThreshold()));
    }

    protected abstract Match match(PreprocessedRule var1, Bounds var2);

    public static final class DstAddress
    extends Address {
        public DstAddress(IpAddr address) {
            super(bs -> bs.dstAddr, (bs, b) -> new Bounds(bs.protocol, bs.srcPort, bs.dstPort, bs.srcAddr, (Bound<IpAddr>)b), address, pr -> pr.dstAddr, ClassificationRequest::getDstAddress);
        }

        public String toString() {
            return "DstAddress{address=" + this.address + "}";
        }
    }

    public static final class SrcAddress
    extends Address {
        public SrcAddress(IpAddr address) {
            super(bs -> bs.srcAddr, (bs, b) -> new Bounds(bs.protocol, bs.srcPort, bs.dstPort, (Bound<IpAddr>)b, bs.dstAddr), address, pr -> pr.srcAddr, ClassificationRequest::getSrcAddress);
        }

        public String toString() {
            return "SrcAddress{address=" + this.address + "}";
        }
    }

    public static abstract class Address
    extends Threshold<IpAddr> {
        protected final IpAddr address;
        private final Function<PreprocessedRule, IpValue> getRuleAddress;
        private final Function<ClassificationRequest, IpAddr> getRequestAddress;

        public Address(Function<Bounds, Bound<IpAddr>> getBound, BiFunction<Bounds, Bound<IpAddr>, Bounds> setBound, IpAddr address, Function<PreprocessedRule, IpValue> getRuleAddress, Function<ClassificationRequest, IpAddr> getRequestAddress) {
            super(getBound, setBound);
            this.address = address;
            this.getRuleAddress = getRuleAddress;
            this.getRequestAddress = getRequestAddress;
        }

        @Override
        public final IpAddr getThreshold() {
            return this.address;
        }

        @Override
        protected final Match match(PreprocessedRule rule, Bounds bounds) {
            IpValue ipValue = this.getRuleAddress.apply(rule);
            if (ipValue == null) {
                return Match.NA;
            }
            boolean lt = false;
            boolean eq = false;
            boolean gt = false;
            Bound bound = (Bound)this.getBound.apply(bounds);
            for (IpRange range : ipValue.getIpAddressRanges()) {
                if (!bound.overlaps(range.begin, range.end) || !(lt |= range.begin.compareTo((Object)this.address) < 0) || !(eq |= range.contains(this.address)) || !(gt |= range.end.compareTo((Object)this.address) > 0)) continue;
                break;
            }
            return new Match(lt, eq, gt, false);
        }

        @Override
        public final Order compare(ClassificationRequest request) {
            IpAddr s = this.getRequestAddress.apply(request);
            if (s != null) {
                int c = s.compareTo((Object)this.address);
                return c < 0 ? Order.LT : (c == 0 ? Order.EQ : Order.GT);
            }
            return Order.NA;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Address address1 = (Address)o;
            return this.address.equals(address1.address);
        }

        public final int hashCode() {
            return Objects.hash(this.address);
        }
    }

    public static final class DstPort
    extends Port {
        public DstPort(int port) {
            super(bs -> bs.dstPort, (bs, b) -> new Bounds(bs.protocol, bs.srcPort, (Bound<Integer>)b, bs.srcAddr, bs.dstAddr), port, pr -> pr.dstPort, ClassificationRequest::getDstPort);
        }

        public String toString() {
            return "DstPort{port=" + this.port + "}";
        }
    }

    public static final class SrcPort
    extends Port {
        public SrcPort(int port) {
            super(bs -> bs.srcPort, (bs, b) -> new Bounds(bs.protocol, (Bound<Integer>)b, bs.dstPort, bs.srcAddr, bs.dstAddr), port, pr -> pr.srcPort, ClassificationRequest::getSrcPort);
        }

        public String toString() {
            return "SrcPort{port=" + this.port + "}";
        }
    }

    public static abstract class Port
    extends Threshold<Integer> {
        protected final int port;
        private final Function<PreprocessedRule, PortValue> getRulePort;
        private final Function<ClassificationRequest, Integer> getRequestPort;

        public Port(Function<Bounds, Bound<Integer>> getBound, BiFunction<Bounds, Bound<Integer>, Bounds> setBound, int port, Function<PreprocessedRule, PortValue> getRulePort, Function<ClassificationRequest, Integer> getRequestPort) {
            super(getBound, setBound);
            this.port = port;
            this.getRulePort = getRulePort;
            this.getRequestPort = getRequestPort;
        }

        @Override
        public final Integer getThreshold() {
            return this.port;
        }

        @Override
        protected final Match match(PreprocessedRule rule, Bounds bounds) {
            IPPortRange range;
            PortValue portValue = this.getRulePort.apply(rule);
            if (portValue == null) {
                return Match.NA;
            }
            Bound bound = (Bound)this.getBound.apply(bounds);
            boolean lt = false;
            boolean eq = false;
            boolean gt = false;
            Iterator<IPPortRange> iterator = portValue.getPortRanges().iterator();
            while (!(!iterator.hasNext() || bound.overlaps((range = iterator.next()).getBegin(), range.getEnd()) && (lt |= range.getBegin() < this.port) && (eq |= range.contains(this.port)) && (gt |= range.getEnd() > this.port))) {
            }
            return new Match(lt, eq, gt, false);
        }

        @Override
        public final Order compare(ClassificationRequest request) {
            Integer p = this.getRequestPort.apply(request);
            if (p != null) {
                return p < this.port ? Order.LT : (p == this.port ? Order.EQ : Order.GT);
            }
            return Order.NA;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Port port1 = (Port)o;
            return this.port == port1.port;
        }

        public final int hashCode() {
            return Objects.hash(this.port);
        }
    }

    public static final class Protocol
    extends Threshold<Integer> {
        private final int protocol;

        public Protocol(int protocol) {
            super(bs -> bs.protocol, (bs, b) -> new Bounds((Bound<Integer>)b, bs.srcPort, bs.dstPort, bs.srcAddr, bs.dstAddr));
            this.protocol = protocol;
        }

        @Override
        public final Integer getThreshold() {
            return this.protocol;
        }

        @Override
        protected final Match match(PreprocessedRule rule, Bounds bounds) {
            int p;
            if (rule.protocol == null) {
                return Match.NA;
            }
            boolean lt = false;
            boolean eq = false;
            boolean gt = false;
            Iterator<Integer> iterator = rule.protocol.getProtocols().iterator();
            while (!(!iterator.hasNext() || bounds.protocol.includes(p = iterator.next().intValue()) && (lt |= p < this.protocol) && (eq |= p == this.protocol) && (gt |= p > this.protocol))) {
            }
            return new Match(lt, eq, gt, false);
        }

        @Override
        public final Order compare(ClassificationRequest request) {
            if (request.getProtocol() != null) {
                int p = request.getProtocol().getDecimal();
                return p < this.protocol ? Order.LT : (p == this.protocol ? Order.EQ : Order.GT);
            }
            return Order.NA;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Protocol protocol1 = (Protocol)o;
            return this.protocol == protocol1.protocol;
        }

        public final int hashCode() {
            return Objects.hash(this.protocol);
        }

        public String toString() {
            return "Protocol{protocol=" + this.protocol + "}";
        }
    }

    private static class Match {
        final boolean lt;
        final boolean eq;
        final boolean gt;
        final boolean na;
        static Match NA = new Match(false, false, false, true);

        Match(boolean lt, boolean eq, boolean gt, boolean na) {
            this.lt = lt;
            this.eq = eq;
            this.gt = gt;
            this.na = na;
        }
    }

    public static enum Order {
        LT,
        EQ,
        GT,
        NA;

    }

    public static class Matches {
        public final List<PreprocessedRule> lt;
        public final List<PreprocessedRule> eq;
        public final List<PreprocessedRule> gt;
        public final List<PreprocessedRule> na;

        public Matches(List<PreprocessedRule> lt, List<PreprocessedRule> eq, List<PreprocessedRule> gt, List<PreprocessedRule> na) {
            this.lt = lt;
            this.eq = eq;
            this.gt = gt;
            this.na = na;
        }
    }
}

