/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal.decision;

public abstract class Bound<T extends Comparable<T>> {
    public static Any ANY = new Any();

    public abstract Bound<T> lt(T var1);

    public abstract Bound<T> eq(T var1);

    public abstract Bound<T> gt(T var1);

    public abstract boolean includes(T var1);

    public abstract boolean canBeRestrictedBy(T var1);

    public abstract boolean overlaps(T var1, T var2);

    public static class In<T extends Comparable<T>>
    extends Bound<T> {
        private final T lt;
        private final T gt;

        public In(T lt, T gt) {
            this.lt = lt;
            this.gt = gt;
        }

        @Override
        public Bound<T> lt(T value) {
            if (this.lt.compareTo(value) <= 0) {
                throw new IllegalArgumentException("restriction must be smaller than current value - current: " + this.lt + "; restriction: " + value);
            }
            return new In<T>(value, this.gt);
        }

        @Override
        public Bound<T> eq(T value) {
            if (this.lt.compareTo(value) < 0 || this.gt.compareTo(value) > 0) {
                throw new IllegalArgumentException("illegal equality restriction - current: (" + this.lt + "," + this.gt + "); restriction: " + value);
            }
            return new Eq<T>(value);
        }

        @Override
        public Bound<T> gt(T value) {
            if (this.gt.compareTo(value) >= 0) {
                throw new IllegalArgumentException("restriction must be greater than current value - current: " + this.gt + "; restriction: " + value);
            }
            return new In<T>(this.lt, value);
        }

        @Override
        public boolean includes(T value) {
            return value.compareTo(this.lt) < 0 && value.compareTo(this.gt) > 0;
        }

        @Override
        public boolean canBeRestrictedBy(T value) {
            return value.compareTo(this.lt) < 0 && value.compareTo(this.gt) > 0;
        }

        @Override
        public boolean overlaps(T begin, T end) {
            return end.compareTo(this.gt) > 0 && begin.compareTo(this.lt) < 0;
        }
    }

    public static class Gt<T extends Comparable<T>>
    extends Bound<T> {
        private final T gt;

        public Gt(T gt) {
            this.gt = gt;
        }

        @Override
        public Bound<T> lt(T value) {
            return new In<T>(value, this.gt);
        }

        @Override
        public Bound<T> eq(T value) {
            if (this.gt.compareTo(value) > 0) {
                throw new IllegalArgumentException("illegal equality restriction - current: " + this.gt + "; restriction: " + value);
            }
            return new Eq<T>(value);
        }

        @Override
        public Bound<T> gt(T value) {
            if (this.gt.compareTo(value) >= 0) {
                throw new IllegalArgumentException("restriction must be greater than current value - current: " + this.gt + "; restriction: " + value);
            }
            return new Gt<T>(value);
        }

        @Override
        public boolean includes(T value) {
            return value.compareTo(this.gt) > 0;
        }

        @Override
        public boolean canBeRestrictedBy(T value) {
            return value.compareTo(this.gt) > 0;
        }

        @Override
        public boolean overlaps(T begin, T end) {
            return end.compareTo(this.gt) > 0;
        }
    }

    public static class Eq<T extends Comparable<T>>
    extends Bound<T> {
        private final T value;

        public Eq(T value) {
            this.value = value;
        }

        @Override
        public Bound<T> lt(T value) {
            throw new IllegalStateException("threshold is already restricted to value: " + this.value);
        }

        @Override
        public Bound<T> eq(T value) {
            throw new IllegalStateException("threshold is already restricted to value: " + this.value);
        }

        @Override
        public Bound<T> gt(T value) {
            throw new IllegalStateException("threshold is already restricted to value: " + this.value);
        }

        @Override
        public boolean includes(T value) {
            return value.compareTo(value) == 0;
        }

        @Override
        public boolean canBeRestrictedBy(T value) {
            return false;
        }

        @Override
        public boolean overlaps(T begin, T end) {
            return begin.compareTo(this.value) <= 0 && end.compareTo(this.value) >= 0;
        }
    }

    public static class Lt<T extends Comparable<T>>
    extends Bound<T> {
        private final T lt;

        public Lt(T lt) {
            this.lt = lt;
        }

        @Override
        public Bound<T> lt(T value) {
            if (this.lt.compareTo(value) <= 0) {
                throw new IllegalArgumentException("restriction must be smaller than current value - current: " + this.lt + "; restriction: " + value);
            }
            return new Lt<T>(value);
        }

        @Override
        public Bound<T> eq(T value) {
            if (this.lt.compareTo(value) < 0) {
                throw new IllegalArgumentException("illegal equality restriction - current: " + this.lt + "; restriction: " + value);
            }
            return new Eq<T>(value);
        }

        @Override
        public Bound<T> gt(T value) {
            return new In<T>(this.lt, value);
        }

        @Override
        public boolean includes(T value) {
            return value.compareTo(this.lt) < 0;
        }

        @Override
        public boolean canBeRestrictedBy(T value) {
            return value.compareTo(this.lt) < 0;
        }

        @Override
        public boolean overlaps(T begin, T end) {
            return begin.compareTo(this.lt) < 0;
        }
    }

    public static class Any<T extends Comparable<T>>
    extends Bound<T> {
        @Override
        public Bound<T> lt(T value) {
            return new Lt<T>(value);
        }

        @Override
        public Bound<T> eq(T value) {
            return new Eq<T>(value);
        }

        @Override
        public Bound<T> gt(T value) {
            return new Gt<T>(value);
        }

        @Override
        public boolean includes(T value) {
            return true;
        }

        @Override
        public boolean canBeRestrictedBy(T value) {
            return true;
        }

        @Override
        public boolean overlaps(T begin, T end) {
            return true;
        }
    }
}

