/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.schema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.AbstractSyntaxChecker;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.keyword.digest.AbstractDigester;
import com.github.fge.jsonschema.keyword.digest.Digester;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.library.Keyword;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.util.Collection;
import java.util.Iterator;

public class Nullable {
    public static final String KEYWORD = "nullable";
    private static final String TYPE_KEY = "type";
    private static final String ENUM_KEY = "enum";
    private static final String NULLABLE_KEY = "nullable";
    private static final Keyword INSTANCE = Keyword.newBuilder((String)"nullable").withSyntaxChecker((SyntaxChecker)NullableSyntaxChecker.getInstance()).withDigester((Digester)NullableDigester.getInstance()).withValidatorClass(NullableKeywordValidator.class).freeze();

    public static Keyword getInstance() {
        return INSTANCE;
    }

    private Nullable() {
    }

    public static class NullableSyntaxChecker
    extends AbstractSyntaxChecker {
        private static final NullableSyntaxChecker INSTANCE = new NullableSyntaxChecker();

        static NullableSyntaxChecker getInstance() {
            return INSTANCE;
        }

        NullableSyntaxChecker() {
            super("nullable", NodeType.BOOLEAN, new NodeType[0]);
        }

        protected void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle, ProcessingReport report, SchemaTree tree) {
        }
    }

    public static class NullableDigester
    extends AbstractDigester {
        private static final NullableDigester INSTANCE = new NullableDigester();

        public static NullableDigester getInstance() {
            return INSTANCE;
        }

        private NullableDigester() {
            super("nullable", NodeType.OBJECT, NodeType.values());
        }

        public JsonNode digest(JsonNode schema) {
            NullableDigester.setupNullableTypes(schema);
            NullableDigester.setupNullableEnums(schema);
            return schema;
        }

        private static void setupNullableTypes(JsonNode schemaObject) {
            String nullType = NodeType.NULL.toString();
            schemaObject.findParents(Nullable.TYPE_KEY).stream().filter(jsonNode -> jsonNode.path("nullable").asBoolean(false)).filter(jsonNode -> !NullableDigester.alreadySupportsNullType(jsonNode)).forEach(jsonNode -> {
                JsonNode type = jsonNode.get(Nullable.TYPE_KEY);
                if (type.isTextual()) {
                    ((ObjectNode)jsonNode).putArray(Nullable.TYPE_KEY).add(nullType).add(type);
                } else if (type.isArray()) {
                    ((ArrayNode)type).add(nullType);
                }
            });
        }

        private static void setupNullableEnums(JsonNode schemaObject) {
            schemaObject.findParents(Nullable.ENUM_KEY).stream().filter(jsonNode -> jsonNode.path("nullable").asBoolean(false)).filter(jsonNode -> !NullableDigester.alreadySupportsNullEnum(jsonNode)).forEach(jsonNode -> ((ArrayNode)jsonNode.get(Nullable.ENUM_KEY)).addNull());
        }

        private static boolean alreadySupportsNullType(JsonNode schemaObject) {
            String nullType = NodeType.NULL.toString();
            JsonNode typeNode = schemaObject.get(Nullable.TYPE_KEY);
            if (typeNode.isTextual()) {
                return nullType.equals(typeNode.asText());
            }
            if (typeNode.isArray()) {
                ArrayNode typeNodeArr = (ArrayNode)typeNode;
                for (JsonNode typeElem : typeNodeArr) {
                    if (!nullType.equals(typeElem.asText())) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean alreadySupportsNullEnum(JsonNode schemaObject) {
            Iterator iter = schemaObject.get(Nullable.ENUM_KEY).elements();
            while (iter.hasNext()) {
                if (!((JsonNode)iter.next()).isNull()) continue;
                return true;
            }
            return false;
        }
    }

    public static class NullableKeywordValidator
    extends AbstractKeywordValidator {
        public NullableKeywordValidator(JsonNode digest) {
            super("nullable");
        }

        public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) {
        }

        public String toString() {
            return this.keyword;
        }
    }
}

