/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.events;

import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.AbstractEntityVisitor;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateEventVisitor
extends AbstractEntityVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateEventVisitor.class);
    private static final String m_eventSource = "Provisiond";
    private EventForwarder m_eventForwarder;
    private String m_rescanExisting;
    private String monitorKey;

    public UpdateEventVisitor(EventForwarder eventForwarder, String rescanExisting, String monitorKey) {
        this.m_eventForwarder = eventForwarder;
        this.m_rescanExisting = rescanExisting;
        this.monitorKey = monitorKey;
    }

    @Override
    public void visitNode(OnmsNode node) {
        LOG.info("Sending nodeUpdated Event for {}\n", (Object)node);
        this.m_eventForwarder.sendNow(this.createNodeUpdatedEvent(node));
    }

    @Override
    public void visitIpInterface(OnmsIpInterface iface) {
    }

    @Override
    public void visitMonitoredService(OnmsMonitoredService monSvc) {
    }

    @Override
    public void visitSnmpInterface(OnmsEntity snmpIface) {
    }

    private Event createNodeUpdatedEvent(OnmsNode node) {
        return EventUtils.createNodeUpdatedEvent(m_eventSource, node.getId(), node.getLabel(), node.getLabelSource(), this.m_rescanExisting, this.monitorKey);
    }
}

