/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.opennms.netmgt.collectd.MibPropertyAttributeType;
import org.opennms.netmgt.collectd.SnmpAttribute;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.collectd.SnmpPropertyExtender;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.config.datacollection.MibObjProperty;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterfaceSnmpPropertyExtender
implements SnmpPropertyExtender {
    private static final Logger LOG = LoggerFactory.getLogger(InterfaceSnmpPropertyExtender.class);
    private static final String SOURCE_ATTRIBUTE = "source-attribute";
    private static final String SOURCE_IFINDEX_ATTRIBUTE = "source-ifindex-attribute";
    private static final String IFINDEX_POINTER_COLUMN = "target-ifindex-pointer-column";

    @Override
    public SnmpAttribute getTargetAttribute(List<CollectionAttribute> sourceAttributes, SnmpCollectionResource targetResource, MibObjProperty property) {
        AttributeGroupType groupType;
        String sourceAttribute;
        if (!StringUtils.isBlank((String)property.getParameterValue("source-type"))) {
            LOG.warn("Hint: The interfaceSnmp property extender does not take a source-type parameter. Ignoring the one provided.");
        }
        if (StringUtils.isBlank((String)(sourceAttribute = property.getParameterValue(SOURCE_ATTRIBUTE)))) {
            LOG.warn("Cannot execute the interfaceSnmp property extender because: missing parameter {}", (Object)SOURCE_ATTRIBUTE);
            return null;
        }
        String ifIndexPointerColumn = property.getParameterValue(IFINDEX_POINTER_COLUMN);
        if (StringUtils.isBlank((String)ifIndexPointerColumn)) {
            LOG.warn("Cannot execute the interfaceSnmp property extender because: missing parameter {}", (Object)IFINDEX_POINTER_COLUMN);
            return null;
        }
        String ifIndexSourceColumn = property.getParameterValue(SOURCE_IFINDEX_ATTRIBUTE, "ifIndex");
        String targetIfIndex = null;
        Optional<CollectionAttribute> target = null;
        for (AttributeGroup group : targetResource.getGroups()) {
            for (CollectionAttribute attribute : group.getAttributes()) {
                try {
                    if (!ifIndexPointerColumn.equals(attribute.getName())) continue;
                    targetIfIndex = attribute.getStringValue();
                }
                catch (Exception e) {
                    LOG.error("Error: " + e, (Throwable)e);
                }
            }
        }
        if (targetIfIndex == null) {
            LOG.warn("Could not identify ifIndex-equivalent pointer column {} on target resource {}", (Object)ifIndexPointerColumn, (Object)targetResource);
            return null;
        }
        CollectionResource sourceResource = null;
        String targetIfIndexStr = targetIfIndex;
        for (CollectionAttribute srcAttr : sourceAttributes) {
            try {
                if (!ifIndexSourceColumn.equals(srcAttr.getName()) || !targetIfIndexStr.equals(srcAttr.getStringValue())) continue;
                sourceResource = srcAttr.getResource();
            }
            catch (Exception e) {
                LOG.error("Error: " + e, (Throwable)e);
            }
        }
        if (sourceResource != null) {
            CollectionResource srcRsrc = sourceResource;
            target = sourceAttributes.stream().filter(a -> this.matches(sourceAttribute, srcRsrc, (CollectionAttribute)a)).findFirst();
        }
        if (target != null && target.isPresent() && (groupType = targetResource.getGroupType(property.getGroupName())) != null) {
            MibPropertyAttributeType type = new MibPropertyAttributeType(targetResource.getResourceType(), property, groupType);
            SnmpValue value = SnmpUtils.getValueFactory().getOctetString(target.get().getStringValue().getBytes());
            return new SnmpAttribute(targetResource, type, value);
        }
        return null;
    }

    private boolean matches(String sourceAttribute, CollectionResource sourceResource, CollectionAttribute a) {
        CollectionResource r = a.getResource();
        return a.getName().equals(sourceAttribute) && "if".equals(r.getResourceTypeName()) && r.equals(sourceResource);
    }
}

