/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.datablock;

import java.util.Date;

public class Outage {
    private static final String LOG4J_CATEGORY = "reports";
    private long m_svcLostTime;
    private long m_svcRegainedTime;

    public Outage() {
        this.m_svcLostTime = -1L;
        this.m_svcRegainedTime = -1L;
    }

    public Outage(long svcLost) {
        this.m_svcLostTime = svcLost;
        this.m_svcRegainedTime = -1L;
    }

    public Outage(long svcLost, long svcRegained) {
        this.m_svcLostTime = svcLost;
        this.m_svcRegainedTime = svcRegained;
    }

    public void setLostTime(long losttime) {
        this.m_svcLostTime = losttime;
    }

    public void setRegainedTime(long regainedtime) {
        this.m_svcRegainedTime = regainedtime;
    }

    public long getLostTime() {
        return this.m_svcLostTime;
    }

    public long getRegainedTime() {
        return this.m_svcRegainedTime;
    }

    public long getDownTime(long curTime, long rollingWindow) {
        long downTime = 0L;
        if (curTime < this.m_svcLostTime) {
            return downTime;
        }
        long startTime = curTime - rollingWindow;
        if (this.m_svcRegainedTime == -1L) {
            downTime = this.m_svcLostTime < startTime ? rollingWindow : curTime - this.m_svcLostTime;
        } else if (this.m_svcLostTime >= startTime) {
            downTime = this.m_svcRegainedTime < curTime ? this.m_svcRegainedTime - this.m_svcLostTime : curTime - this.m_svcLostTime;
        } else {
            if (this.m_svcRegainedTime < startTime) {
                return 0L;
            }
            downTime = this.m_svcRegainedTime > curTime ? rollingWindow : this.m_svcRegainedTime - startTime;
        }
        return downTime;
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder();
        retVal.append(" Lost service ").append(new Date(this.m_svcLostTime));
        retVal.append(" Regained service ").append(new Date(this.m_svcRegainedTime) + "\n");
        return retVal.toString();
    }
}

