/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.availability.svclayer;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Callable;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.CategoryFactory;
import org.opennms.netmgt.config.api.CatFactory;
import org.opennms.netmgt.config.categories.Category;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.reporting.availability.svclayer.AvailabilityDataService;
import org.opennms.reporting.availability.svclayer.AvailabilityDataServiceException;
import org.opennms.reporting.datablock.Node;
import org.opennms.reporting.datablock.Outage;
import org.opennms.reporting.datablock.OutageSvcTimesList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyAvailabilityDataService
implements AvailabilityDataService {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyAvailabilityDataService.class);
    CatFactory m_catFactory;
    private Connection m_availConn;
    private List<Node> m_nodes;
    private static final String LOG4J_CATEGORY = "reports";

    @Override
    public List<Node> getNodes(final Category category, final long startTime, final long endTime) throws AvailabilityDataServiceException {
        try {
            return (List)Logging.withPrefix((String)LOG4J_CATEGORY, (Callable)new Callable<List<Node>>(){

                @Override
                public List<Node> call() throws Exception {
                    DBUtils db = new DBUtils();
                    LegacyAvailabilityDataService.this.m_nodes = new ArrayList<Node>();
                    PreparedStatement ipInfoGetStmt = null;
                    PreparedStatement servicesGetStmt = null;
                    PreparedStatement outagesGetStmt = null;
                    String categoryName = category.getLabel();
                    try {
                        CategoryFactory.init();
                        LegacyAvailabilityDataService.this.m_catFactory = CategoryFactory.getInstance();
                    }
                    catch (Exception e) {
                        LOG.error("Failed to initialize CategoryFactory", (Throwable)e);
                        throw new AvailabilityDataServiceException("failed to init catFactory");
                    }
                    LegacyAvailabilityDataService.this.m_catFactory.getReadLock().lock();
                    try {
                        String commonRule = LegacyAvailabilityDataService.this.m_catFactory.getEffectiveRule(categoryName);
                        FilterDaoFactory.getInstance().flushActiveIpAddressListCache();
                        List nodeIPs = FilterDaoFactory.getInstance().getActiveIPAddressList(commonRule);
                        LOG.debug("Number of IPs satisfying rule: {}", (Object)nodeIPs.size());
                        ArrayList monitoredServices = new ArrayList(category.getServices());
                        LOG.debug("categories in monitoredServices = {}", monitoredServices);
                        LegacyAvailabilityDataService.this.initialiseConnection();
                        db.watch((Object)LegacyAvailabilityDataService.this.m_availConn);
                        ipInfoGetStmt = LegacyAvailabilityDataService.this.m_availConn.prepareStatement("SELECT node.nodeid, node.nodelabel FROM node, ipInterface WHERE ipInterface.ipaddr = ? AND ipInterface.nodeid = node.nodeid AND node.nodeType = 'A' AND ipinterface.ismanaged = 'M'");
                        db.watch((Object)ipInfoGetStmt);
                        servicesGetStmt = LegacyAvailabilityDataService.this.m_availConn.prepareStatement("SELECT ifServices.serviceid, service.servicename FROM ifServices, ipInterface, node, service WHERE ifServices.ipInterfaceId = ipInterface.id AND ipInterface.nodeId = node.nodeId AND ipInterface.ipaddr = ? AND ipinterface.isManaged ='M' AND ifServices.serviceid = service.serviceid AND ifservices.status = 'A' AND node.nodeid = ? AND node.nodetype = 'A'");
                        db.watch((Object)servicesGetStmt);
                        outagesGetStmt = LegacyAvailabilityDataService.this.m_availConn.prepareStatement("SELECT ifLostService, ifRegainedService FROM outages, ifServices, ipInterface, node WHERE outages.perspective IS NULL AND outages.ifServiceId = ifServices.id AND ifServices.ipInterfaceId = ipInterface.id AND ipInterface.nodeId = node.nodeId AND node.nodeid = ? AND ipInterface.ipaddr = ? AND ifServices.serviceid = ?");
                        db.watch((Object)outagesGetStmt);
                        Iterator ipIter = nodeIPs.iterator();
                        String ip = null;
                        ResultSet ipRS = null;
                        ipInfoGetStmt = LegacyAvailabilityDataService.this.m_availConn.prepareStatement("SELECT node.nodeid, node.nodelabel FROM node, ipInterface WHERE ipInterface.ipaddr = ? AND ipInterface.nodeid = node.nodeid AND node.nodeType = 'A' AND ipinterface.ismanaged = 'M'");
                        db.watch((Object)ipInfoGetStmt);
                        while (ipIter.hasNext()) {
                            ip = InetAddressUtils.str((InetAddress)((InetAddress)ipIter.next()));
                            LOG.debug("executing {} for {}", (Object)ip, (Object)"SELECT node.nodeid, node.nodelabel FROM node, ipInterface WHERE ipInterface.ipaddr = ? AND ipInterface.nodeid = node.nodeid AND node.nodeType = 'A' AND ipinterface.ismanaged = 'M'");
                            ipInfoGetStmt.setString(1, ip);
                            ipRS = ipInfoGetStmt.executeQuery();
                            db.watch((Object)ipRS);
                            while (ipRS.next()) {
                                int nodeid = ipRS.getInt(1);
                                String nodeName = ipRS.getString(2);
                                ResultSet svcRS = null;
                                servicesGetStmt.setString(1, ip);
                                servicesGetStmt.setLong(2, nodeid);
                                svcRS = servicesGetStmt.executeQuery();
                                db.watch((Object)svcRS);
                                while (svcRS.next()) {
                                    int svcid = svcRS.getInt(1);
                                    String svcname = svcRS.getString(2);
                                    if (!monitoredServices.isEmpty() && !monitoredServices.contains(svcname)) continue;
                                    OutageSvcTimesList outageSvcTimesList = new OutageSvcTimesList();
                                    LegacyAvailabilityDataService.this.getOutagesNodeIpSvc(nodeid, nodeName, ip, svcid, svcname, outageSvcTimesList, outagesGetStmt, startTime, endTime);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        LOG.debug("Failed to get nodes for category {}", (Object)category, (Object)e);
                        throw new AvailabilityDataServiceException("Failed to get nodes for category " + category, e);
                    }
                    finally {
                        db.cleanUp();
                        LegacyAvailabilityDataService.this.m_availConn = null;
                        LegacyAvailabilityDataService.this.m_catFactory.getReadLock().unlock();
                    }
                    return LegacyAvailabilityDataService.this.m_nodes;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof AvailabilityDataServiceException) {
                throw (AvailabilityDataServiceException)e;
            }
            throw new AvailabilityDataServiceException(e);
        }
    }

    private void getOutagesNodeIpSvc(int nodeid, String nodeName, String ipaddr, int serviceid, String serviceName, OutageSvcTimesList outageSvcTimesList, PreparedStatement outagesGetStmt, long startTime, long endTime) throws SQLException {
        try {
            outagesGetStmt.setInt(1, nodeid);
            outagesGetStmt.setString(2, ipaddr);
            outagesGetStmt.setInt(3, serviceid);
            ResultSet rs = outagesGetStmt.executeQuery();
            if (this.m_nodes != null && this.m_nodes.size() > 0) {
                ListIterator<Node> lstIter = this.m_nodes.listIterator();
                boolean foundFlag = false;
                Node oldNode = null;
                while (lstIter.hasNext()) {
                    oldNode = lstIter.next();
                    if (oldNode == null || oldNode.getNodeID() != nodeid) continue;
                    foundFlag = true;
                    break;
                }
                if (!foundFlag) {
                    Node newNode = new Node(nodeName, nodeid);
                    newNode.addInterface(ipaddr, serviceName);
                    this.m_nodes.add(newNode);
                } else {
                    oldNode.addInterface(ipaddr, serviceName);
                }
            } else {
                Node newNode = new Node(nodeName, nodeid);
                newNode.addInterface(ipaddr, serviceName);
                if (this.m_nodes == null) {
                    LOG.debug("NODES IS NULL");
                }
                this.m_nodes.add(newNode);
            }
            while (rs.next()) {
                Timestamp lost = rs.getTimestamp(1);
                Timestamp regained = rs.getTimestamp(2);
                long losttime = lost.getTime();
                long regainedtime = 0L;
                if (regained != null) {
                    regainedtime = regained.getTime();
                }
                if (regainedtime > 0L ? regainedtime <= startTime || losttime >= endTime : losttime >= endTime) continue;
                Outage outage = new Outage(losttime, regainedtime);
                outageSvcTimesList.add(outage);
                this.addNode(nodeName, nodeid, ipaddr, serviceName, losttime, regainedtime);
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            LOG.error("SQL Error occured while getting the outages ", (Throwable)e);
            throw e;
        }
    }

    public void addNode(String nodeName, int nodeid, String ipaddr, String serviceid, long losttime, long regainedtime) {
        if (this.m_nodes != null) {
            if (this.m_nodes.size() <= 0) {
                Node newNode = new Node(nodeName, nodeid);
                if (losttime > 0L) {
                    if (regainedtime > 0L) {
                        newNode.addInterface(ipaddr, serviceid, losttime, regainedtime);
                    } else {
                        newNode.addInterface(ipaddr, serviceid, losttime);
                    }
                } else {
                    newNode.addInterface(ipaddr, serviceid);
                }
                this.m_nodes.add(newNode);
                return;
            }
            Node newNode = null;
            boolean foundFlag = false;
            ListIterator<Node> lstIter = this.m_nodes.listIterator();
            while (lstIter.hasNext()) {
                newNode = lstIter.next();
                if (newNode.getNodeID() != nodeid) continue;
                foundFlag = true;
                break;
            }
            if (!foundFlag) {
                newNode = new Node(nodeName, nodeid);
                if (losttime > 0L) {
                    if (regainedtime > 0L) {
                        newNode.addInterface(ipaddr, serviceid, losttime, regainedtime);
                    } else {
                        newNode.addInterface(ipaddr, serviceid, losttime);
                    }
                } else {
                    newNode.addInterface(ipaddr, serviceid);
                }
                this.m_nodes.add(newNode);
                return;
            }
            if (losttime > 0L) {
                if (regainedtime > 0L) {
                    newNode.addInterface(ipaddr, serviceid, losttime, regainedtime);
                } else {
                    newNode.addInterface(ipaddr, serviceid, losttime);
                }
            } else {
                newNode.addInterface(ipaddr, serviceid);
            }
            return;
        }
        this.m_nodes = new ArrayList<Node>();
    }

    private void initialiseConnection() throws AvailabilityDataServiceException {
        try {
            this.m_availConn = DataSourceFactory.getInstance().getConnection();
        }
        catch (SQLException e) {
            LOG.error("initialize: Failed getting connection to the database.", (Throwable)e);
            throw new AvailabilityDataServiceException("failed to load data collection configuration");
        }
    }
}

