/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.availability.render;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.opennms.core.logging.Logging;
import org.opennms.reporting.availability.render.ReportRenderException;
import org.opennms.reporting.availability.render.ReportRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class PDFReportRenderer
implements ReportRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(PDFReportRenderer.class);
    private static final String LOG4J_CATEGORY = "reports";
    private String m_outputFileName;
    private String m_inputFileName;
    private Resource m_xsltResource;
    private String m_baseDir;

    @Override
    public void render() throws ReportRenderException {
        this.render(this.m_inputFileName, this.m_outputFileName, this.m_xsltResource);
    }

    @Override
    public byte[] render(final String inputFileName, final Resource xsltResource) throws ReportRenderException {
        try {
            return (byte[])Logging.withPrefix((String)LOG4J_CATEGORY, (Callable)new Callable<byte[]>(){

                @Override
                public byte[] call() throws Exception {
                    LOG.debug("Rendering {} with XSL File {} to byte array", (Object)inputFileName, (Object)xsltResource.getDescription());
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    PDFReportRenderer.this.render(inputFileName, (OutputStream)outputStream, xsltResource);
                    return outputStream.toByteArray();
                }
            });
        }
        catch (Exception e) {
            if (e instanceof ReportRenderException) {
                throw (ReportRenderException)e;
            }
            throw new ReportRenderException(e);
        }
    }

    @Override
    public void render(final String inputFileName, final OutputStream outputStream, final Resource xsltResource) throws ReportRenderException {
        try {
            Logging.withPrefix((String)LOG4J_CATEGORY, (Callable)new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    Void void_;
                    FileInputStream in = null;
                    FileInputStream xslt = null;
                    InputStreamReader xsl = null;
                    InputStreamReader xml = null;
                    try {
                        LOG.debug("Rendering {} with XSL File {} to OutputStream", (Object)inputFileName, (Object)xsltResource.getDescription());
                        in = new FileInputStream(xsltResource.getFile());
                        xsl = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);
                        xslt = new FileInputStream(inputFileName);
                        xml = new InputStreamReader((InputStream)xslt, StandardCharsets.UTF_8);
                        PDFReportRenderer.this.render(xml, outputStream, xsl);
                        void_ = null;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(xml);
                        IOUtils.closeQuietly(xslt);
                        IOUtils.closeQuietly(xsl);
                        IOUtils.closeQuietly(in);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Reader)xml);
                    IOUtils.closeQuietly((InputStream)xslt);
                    IOUtils.closeQuietly((Reader)xsl);
                    IOUtils.closeQuietly((InputStream)in);
                    return void_;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof ReportRenderException) {
                throw (ReportRenderException)e;
            }
            throw new ReportRenderException(e);
        }
    }

    @Override
    public void render(final InputStream inputStream, final OutputStream outputStream, final Resource xsltResource) throws ReportRenderException {
        try {
            Logging.withPrefix((String)LOG4J_CATEGORY, (Callable)new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    Void void_;
                    LOG.debug("Rendering InputStream with XSL File {} to OutputStream", (Object)xsltResource.getDescription());
                    FileInputStream xslt = null;
                    InputStreamReader xsl = null;
                    InputStreamReader xml = null;
                    try {
                        xslt = new FileInputStream(xsltResource.getFile());
                        xsl = new InputStreamReader((InputStream)xslt, StandardCharsets.UTF_8);
                        xml = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                        PDFReportRenderer.this.render(xml, outputStream, xsl);
                        void_ = null;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(xml);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Reader)xml);
                    return void_;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof ReportRenderException) {
                throw (ReportRenderException)e;
            }
            throw new ReportRenderException(e);
        }
    }

    @Override
    public void render(final String inputFileName, final String outputFileName, final Resource xsltResource) throws ReportRenderException {
        try {
            Logging.withPrefix((String)LOG4J_CATEGORY, (Callable)new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    Void void_;
                    LOG.debug("Rendering {} with XSL File {} to {} with base directory of {}", new Object[]{PDFReportRenderer.this.m_baseDir, inputFileName, xsltResource.getDescription(), outputFileName});
                    FileInputStream in = null;
                    FileInputStream xslt = null;
                    FileOutputStream out = null;
                    InputStreamReader xsl = null;
                    InputStreamReader xml = null;
                    try {
                        xslt = new FileInputStream(xsltResource.getFile());
                        xsl = new InputStreamReader((InputStream)xslt, StandardCharsets.UTF_8);
                        in = new FileInputStream(PDFReportRenderer.this.m_baseDir + "/" + inputFileName);
                        xml = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);
                        out = new FileOutputStream(new File(PDFReportRenderer.this.m_baseDir + "/" + outputFileName));
                        PDFReportRenderer.this.render(xml, (OutputStream)out, xsl);
                        void_ = null;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(out);
                        IOUtils.closeQuietly(xml);
                        IOUtils.closeQuietly(in);
                        IOUtils.closeQuietly(xsl);
                        IOUtils.closeQuietly((InputStream)xslt);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)out);
                    IOUtils.closeQuietly((Reader)xml);
                    IOUtils.closeQuietly((InputStream)in);
                    IOUtils.closeQuietly((Reader)xsl);
                    IOUtils.closeQuietly((InputStream)xslt);
                    return void_;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof ReportRenderException) {
                throw (ReportRenderException)e;
            }
            throw new ReportRenderException(e);
        }
    }

    public void render(Reader in, OutputStream out, Reader xslt) throws ReportRenderException {
        try {
            FopFactory fopFactory = new FopFactoryBuilder(new ClassPathResource("/fop.xconf").getURI()).build();
            Fop fop = fopFactory.newFop("application/pdf", out);
            TransformerFactory tfact = TransformerFactory.newInstance();
            Transformer transformer = tfact.newTransformer(new StreamSource(xslt));
            transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
            StreamSource streamSource = new StreamSource(in);
            transformer.transform(streamSource, new SAXResult(fop.getDefaultHandler()));
        }
        catch (Exception e) {
            throw new ReportRenderException(e);
        }
    }

    @Override
    public void setXsltResource(Resource xsltResource) {
        this.m_xsltResource = xsltResource;
    }

    @Override
    public void setOutputFileName(String outputFileName) {
        this.m_outputFileName = outputFileName;
    }

    @Override
    public String getOutputFileName() {
        return this.m_outputFileName;
    }

    @Override
    public void setInputFileName(String inputFileName) {
        this.m_inputFileName = inputFileName;
    }

    @Override
    public void setBaseDir(String baseDir) {
        this.m_baseDir = baseDir;
    }

    @Override
    public String getBaseDir() {
        return this.m_baseDir;
    }
}

