/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jest.client.index;

import com.google.common.base.Strings;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.TimeZone;
import org.opennms.features.jest.client.template.IndexSettings;

public enum IndexStrategy {
    YEARLY("yyyy"),
    MONTHLY("yyyy-MM"),
    DAILY("yyyy-MM-dd"),
    HOURLY("yyyy-MM-dd-HH");

    private final DateTimeFormatter dateFormat;
    private final String pattern;

    private IndexStrategy(String pattern) {
        this.pattern = pattern;
        ZoneId UTC = TimeZone.getTimeZone("UTC").toZoneId();
        this.dateFormat = DateTimeFormatter.ofPattern(pattern).withZone(UTC);
    }

    public String getIndex(IndexSettings indexSettings, String indexName, TemporalAccessor temporal) {
        StringBuilder sb = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)indexSettings.getIndexPrefix())) {
            sb.append(indexSettings.getIndexPrefix());
        }
        sb.append(indexName);
        sb.append("-");
        sb.append(this.dateFormat.format(temporal));
        return sb.toString();
    }

    public String getPattern() {
        return this.pattern;
    }
}

