/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.vmware.vim25.HostRuntimeInfo;
import com.vmware.vim25.HostSystemPowerState;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualMachineRuntimeInfo;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.VirtualMachine;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.AbstractVmwareMonitor;
import org.opennms.protocols.vmware.VmwareViJavaAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmwareMonitor
extends AbstractVmwareMonitor {
    private static final Set<String> VALID_VSPHERE_ALARM_STATES = Sets.newHashSet((Object[])new String[]{"red", "yellow", "green", "gray"});
    private final Logger logger = LoggerFactory.getLogger(VmwareMonitor.class);
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        boolean ignoreStandBy = VmwareMonitor.getKeyedBoolean(parameters, (String)"ignoreStandBy", (Boolean)false);
        List<String> severitiesToReport = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)VmwareMonitor.getKeyedString(parameters, (String)"reportAlarms", (String)"")).stream().filter(e -> VALID_VSPHERE_ALARM_STATES.contains(e)).collect(Collectors.toList());
        String vmwareManagementServer = VmwareMonitor.getKeyedString(parameters, (String)"managementServer", null);
        String vmwareManagedEntityType = VmwareMonitor.getKeyedString(parameters, (String)"managedEntityType", null);
        String vmwareManagedObjectId = VmwareMonitor.getKeyedString(parameters, (String)"managedObjectId", null);
        String vmwareMangementServerUsername = VmwareMonitor.getKeyedString(parameters, (String)"managementServerUsername", null);
        String vmwareMangementServerPassword = VmwareMonitor.getKeyedString(parameters, (String)"managementServerPassword", null);
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        PollStatus serviceStatus = PollStatus.unknown();
        tracker.reset();
        while (tracker.shouldRetry()) {
            if (serviceStatus.isAvailable()) return serviceStatus;
            try (VmwareViJavaAccess vmwareViJavaAccess = new VmwareViJavaAccess(vmwareManagementServer, vmwareMangementServerUsername, vmwareMangementServerPassword);){
                Map<String, Long> alarmCountMap;
                HostSystemPowerState hostSystemPowerState;
                HostRuntimeInfo hostRuntimeInfo;
                vmwareViJavaAccess.connect(tracker.getConnectionTimeout());
                String powerState = "unknown";
                if ("HostSystem".equals(vmwareManagedEntityType)) {
                    HostSystem hostSystem = vmwareViJavaAccess.getHostSystemByManagedObjectId(vmwareManagedObjectId);
                    if (hostSystem == null) {
                        PollStatus pollStatus = PollStatus.unknown((String)"hostSystem=null");
                        return pollStatus;
                    }
                    hostRuntimeInfo = hostSystem.getRuntime();
                    if (hostRuntimeInfo == null) {
                        PollStatus pollStatus = PollStatus.unknown((String)"hostRuntimeInfo=null");
                        return pollStatus;
                    }
                    hostSystemPowerState = hostRuntimeInfo.getPowerState();
                    if (hostSystemPowerState == null) {
                        PollStatus pollStatus = PollStatus.unknown((String)"hostSystemPowerState=null");
                        return pollStatus;
                    }
                    powerState = hostSystemPowerState.toString();
                    alarmCountMap = this.getUnacknowledgedAlarmCountForEntity((ManagedEntity)hostSystem, severitiesToReport);
                } else {
                    if (!"VirtualMachine".equals(vmwareManagedEntityType)) {
                        this.logger.warn("Error getting '{}' for '{}'", (Object)vmwareManagedEntityType, (Object)vmwareManagedObjectId);
                        PollStatus virtualMachine = serviceStatus;
                        return virtualMachine;
                    }
                    VirtualMachine virtualMachine = vmwareViJavaAccess.getVirtualMachineByManagedObjectId(vmwareManagedObjectId);
                    if (virtualMachine == null) {
                        hostRuntimeInfo = PollStatus.unknown((String)"virtualMachine=null");
                        return hostRuntimeInfo;
                    }
                    VirtualMachineRuntimeInfo virtualMachineRuntimeInfo = virtualMachine.getRuntime();
                    if (virtualMachineRuntimeInfo == null) {
                        hostSystemPowerState = PollStatus.unknown((String)"virtualMachineRuntimeInfo=null");
                        return hostSystemPowerState;
                    }
                    VirtualMachinePowerState virtualMachinePowerState = virtualMachineRuntimeInfo.getPowerState();
                    if (virtualMachinePowerState == null) {
                        PollStatus pollStatus = PollStatus.unknown((String)"virtualMachinePowerState=null");
                        return pollStatus;
                    }
                    powerState = virtualMachinePowerState.toString();
                    alarmCountMap = this.getUnacknowledgedAlarmCountForEntity((ManagedEntity)virtualMachine, severitiesToReport);
                }
                boolean anyUnacknowledgedAlarms = severitiesToReport.size() > 0 && alarmCountMap != null && alarmCountMap.size() > 0;
                String alarmCountString = this.getMessageForAlarmCountMap(alarmCountMap);
                serviceStatus = "poweredOn".equals(powerState) ? (anyUnacknowledgedAlarms ? PollStatus.unavailable((String)alarmCountString) : PollStatus.available()) : (ignoreStandBy && "standBy".equals(powerState) ? (anyUnacknowledgedAlarms ? PollStatus.unavailable((String)alarmCountString) : PollStatus.available()) : PollStatus.unavailable((String)("The system's state is '" + powerState + "'" + (String)(anyUnacknowledgedAlarms ? ", " + alarmCountString : ""))));
            }
            catch (MalformedURLException | RemoteException e2) {
                this.logger.warn("Error connecting VMware management server '{}': '{}' exception: {} cause: '{}'", new Object[]{vmwareManagementServer, e2.getMessage(), e2.getClass().getName(), e2.getCause()});
                return PollStatus.unavailable((String)("Error connecting VMware management server '" + vmwareManagementServer + "'"));
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }

    private Map<String, Long> getUnacknowledgedAlarmCountForEntity(ManagedEntity managedEntity, List<String> severitiesToReport) {
        return Arrays.stream(managedEntity.getDeclaredAlarmState()).filter(s -> s.acknowledged == false && severitiesToReport.contains(s.overallStatus.name())).collect(Collectors.groupingBy(s -> s.overallStatus.name(), Collectors.counting()));
    }

    private String getMessageForAlarmCountMap(Map<String, Long> alarmCountMap) {
        if (alarmCountMap == null || alarmCountMap.isEmpty()) {
            return "Alarms: no alarms found";
        }
        StringBuilder alarmCountString = new StringBuilder();
        for (String alarmSeverity : VALID_VSPHERE_ALARM_STATES) {
            if (!alarmCountMap.containsKey(alarmSeverity)) continue;
            alarmCountString.append(alarmCountString.length() > 0 ? ", " : "").append(alarmCountMap.get(alarmSeverity)).append(" ").append(alarmSeverity);
        }
        return "Alarms: " + alarmCountString;
    }
}

