/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.searchbox.action.BulkableAction;
import io.searchbox.core.Bulk;
import io.searchbox.core.BulkResult;
import io.searchbox.core.DocumentResult;
import io.searchbox.core.Index;
import java.io.IOException;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.xml.bind.DatatypeConverter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opennms.features.jest.client.ConnectionPoolShutdownException;
import org.opennms.features.jest.client.JestClientWithCircuitBreaker;
import org.opennms.features.jest.client.bulk.BulkException;
import org.opennms.features.jest.client.bulk.BulkRequest;
import org.opennms.features.jest.client.bulk.BulkWrapper;
import org.opennms.features.jest.client.index.IndexStrategy;
import org.opennms.features.jest.client.template.IndexSettings;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.xml.event.AlarmData;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.plugins.elasticsearch.rest.ExceptionUtils;
import org.opennms.plugins.elasticsearch.rest.NodeCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventToIndex
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(EventToIndex.class);
    private static final String INDEX_NAME = "opennms-events-raw";
    private static final String NODE_LABEL_PARAM = "nodelabel";
    private static final int DEFAULT_NUMBER_OF_THREADS = Runtime.getRuntime().availableProcessors() * 2;
    private boolean logEventDescription = false;
    private boolean logAllEvents = false;
    private boolean groupOidParameters = false;
    private NodeCache nodeCache = null;
    private final JestClientWithCircuitBreaker jestClient;
    private final int bulkRetryCount;
    private int threads = DEFAULT_NUMBER_OF_THREADS;
    private IndexStrategy indexStrategy = IndexStrategy.MONTHLY;
    private IndexSettings indexSettings = new IndexSettings();
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(this.threads, this.threads, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(true), new ThreadFactoryBuilder().setNameFormat(EventToIndex.class.getSimpleName() + "-Thread-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());

    public EventToIndex(JestClientWithCircuitBreaker jestClient, int bulkRetryCount) {
        this.jestClient = Objects.requireNonNull(jestClient);
        this.bulkRetryCount = bulkRetryCount;
    }

    public void setIndexStrategy(IndexStrategy indexStrategy) {
        this.indexStrategy = indexStrategy;
    }

    public boolean isLogEventDescription() {
        return this.logEventDescription;
    }

    public void setLogEventDescription(boolean logEventDescription) {
        this.logEventDescription = logEventDescription;
    }

    public void setLogAllEvents(boolean logAllEvents) {
        this.logAllEvents = logAllEvents;
    }

    public void setThreads(int threads) {
        if (threads > 0) {
            this.threads = threads;
            this.executor.setCorePoolSize(threads);
            this.executor.setMaximumPoolSize(threads);
        } else {
            this.setThreads(DEFAULT_NUMBER_OF_THREADS);
        }
    }

    public void setNodeCache(NodeCache cache) {
        this.nodeCache = cache;
    }

    public void setGroupOidParameters(boolean groupOidParameters) {
        this.groupOidParameters = groupOidParameters;
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }

    public void forwardEvents(List<Event> events) {
        ((CompletableFuture)CompletableFuture.completedFuture(events).thenAcceptAsync(this::sendEvents, (Executor)this.executor)).exceptionally(e -> {
            LOG.error("Unexpected exception during task completion: " + e.getMessage(), e);
            if (e.getCause() instanceof ConnectionPoolShutdownException) {
                ExceptionUtils.handle(this.getClass(), (ConnectionPoolShutdownException)e.getCause(), events);
            }
            return null;
        });
    }

    private void sendEvents(List<Event> allEvents) {
        BulkRequest request = new BulkRequest(this.jestClient, allEvents, events -> new BulkWrapper(new Bulk.Builder().addAction(this.convertEventsToEsActions((List<Event>)events))), this.bulkRetryCount);
        try {
            request.execute();
        }
        catch (BulkException ex) {
            BulkResult result = ex.getBulkResult().getRawResult();
            LOG.error("Bulk API action failed. Error response was: {}", (Object)result.getErrorMessage(), (Object)ex);
            if (LOG.isDebugEnabled() && result != null) {
                for (BulkResult.BulkResultItem item : result.getItems()) {
                    if (item.status >= 200 && item.status < 300) {
                        EventToIndex.logEsDebug(item.operation, item.index, item.type, "none", item.status, item.error);
                        continue;
                    }
                    EventToIndex.logEsError(item.operation, item.index, item.type, "none", item.status, item.error);
                }
            }
        }
        catch (IOException ex) {
            LOG.error("Bulk API action failed. An exception occurred: {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    private List<BulkableAction<DocumentResult>> convertEventsToEsActions(List<Event> events) {
        ArrayList<BulkableAction<DocumentResult>> retval = new ArrayList<BulkableAction<DocumentResult>>();
        for (Event event : events) {
            this.refreshCacheIfNecessary(event);
            if (this.logAllEvents || event.getDbid() != null && event.getDbid() != 0) {
                Index eventIndex = this.createEventIndexFromEvent(event);
                retval.add((BulkableAction<DocumentResult>)eventIndex);
                continue;
            }
            LOG.debug("Not Sending Event to ES. Event is not persisted to database, or logAllEvents is false. Event: {}", (Object)event);
        }
        return retval;
    }

    private Index createEventIndexFromEvent(Event event) {
        AlarmData alarmData;
        JSONObject body = new JSONObject();
        Integer id = event.getDbid();
        body.put((Object)"id", (Object)Integer.toString(id));
        body.put((Object)"eventuei", (Object)event.getUei());
        Calendar cal = Calendar.getInstance();
        if (event.getTime() == null) {
            LOG.debug("using local time because no event creation time for event.getTime: {}", (Object)event);
            cal.setTime(new Date());
        } else {
            cal.setTime(event.getTime());
        }
        body.put((Object)"@timestamp", (Object)DatatypeConverter.printDateTime((Calendar)cal));
        body.put((Object)"dow", (Object)Integer.toString(cal.get(7)));
        body.put((Object)"hour", (Object)Integer.toString(cal.get(11)));
        body.put((Object)"dom", (Object)Integer.toString(cal.get(5)));
        body.put((Object)"eventsource", (Object)event.getSource());
        body.put((Object)"ipaddr", event.getInterfaceAddress() != null ? event.getInterfaceAddress().toString() : null);
        body.put((Object)"servicename", (Object)event.getService());
        body.put((Object)"eventseverity_text", (Object)event.getSeverity());
        body.put((Object)"eventseverity", (Object)Integer.toString(OnmsSeverity.get((String)event.getSeverity()).getId()));
        if (this.isLogEventDescription()) {
            body.put((Object)"eventdescr", (Object)event.getDescr());
        }
        body.put((Object)"host", (Object)event.getHost());
        if (event.getCreationTime() != null) {
            cal.setTime(event.getCreationTime());
            body.put((Object)"eventcreationtime", (Object)DatatypeConverter.printDateTime((Calendar)cal));
        }
        if ((alarmData = event.getAlarmData()) != null) {
            body.put((Object)"alarmreductionkey", (Object)alarmData.getReductionKey());
            body.put((Object)"alarmclearkey", (Object)alarmData.getClearKey());
            body.put((Object)"alarmtype", (Object)alarmData.getAlarmType());
        }
        this.handleParameters(event, body);
        body.put((Object)"interface", (Object)event.getInterface());
        body.put((Object)"logmsg", event.getLogmsg() != null ? event.getLogmsg().getContent() : null);
        body.put((Object)"logmsgdest", event.getLogmsg() != null ? event.getLogmsg().getDest() : null);
        if (event.getNodeid() != null) {
            body.put((Object)"nodeid", (Object)Long.toString(event.getNodeid()));
            if (body.containsKey((Object)"p_nodelabel")) {
                body.put((Object)NODE_LABEL_PARAM, body.get((Object)"p_nodelabel"));
            } else if (this.nodeCache != null) {
                Map<String, String> nodedetails = this.nodeCache.getEntry(event.getNodeid());
                Iterator<String> iterator = nodedetails.keySet().iterator();
                while (iterator.hasNext()) {
                    String key;
                    String keyStr = key = iterator.next();
                    String value = nodedetails.get(key);
                    body.put((Object)keyStr, (Object)value);
                }
            }
        }
        String completeIndexName = this.indexStrategy.getIndex(this.indexSettings, INDEX_NAME, (TemporalAccessor)cal.toInstant());
        if (LOG.isDebugEnabled()) {
            String str = "populateEventIndexBodyFromEvent - index:/" + completeIndexName + "/" + id + "\n   body: \n" + body.toJSONString();
            LOG.debug(str);
        }
        Index.Builder builder = (Index.Builder)new Index.Builder((Object)body).index(completeIndexName);
        if (id != null && id > 0) {
            builder = (Index.Builder)builder.id(Integer.toString(id));
        }
        Index index = builder.build();
        return index;
    }

    void handleParameters(Event event, JSONObject body) {
        if (this.groupOidParameters) {
            List oidParameters = event.getParmCollection().stream().filter(p -> EventToIndex.isOID(p.getParmName())).collect(Collectors.toList());
            ArrayList<Parm> normalParameters = new ArrayList<Parm>(event.getParmCollection());
            normalParameters.removeAll(oidParameters);
            this.handleParameters(event, normalParameters, body);
            if (!oidParameters.isEmpty()) {
                JSONArray jsonArray = new JSONArray();
                for (Parm eachOid : oidParameters) {
                    JSONObject eachOidObject = new JSONObject();
                    eachOidObject.put((Object)"oid", (Object)eachOid.getParmName());
                    eachOidObject.put((Object)"value", (Object)eachOid.getValue().getContent());
                    jsonArray.add((Object)eachOidObject);
                }
                body.put((Object)"p_oids", (Object)jsonArray);
            }
        } else {
            this.handleParameters(event, event.getParmCollection(), body);
        }
    }

    void handleParameters(Event event, List<Parm> parameters, JSONObject body) {
        JSONParser jsonParser = new JSONParser();
        for (Parm parm : parameters) {
            String parmName = "p_" + parm.getParmName().replaceAll("\\.", "_");
            if ("json".equalsIgnoreCase(parm.getValue().getType())) {
                try {
                    JSONObject tmpJson = (JSONObject)jsonParser.parse(parm.getValue().getContent());
                    body.put((Object)parmName, (Object)tmpJson);
                }
                catch (ParseException ex) {
                    LOG.error("Cannot parse parameter content '{}' of parameter '{}' from eventid {} to json: {}", new Object[]{parm.getValue().getContent(), parm.getParmName(), event.getDbid(), ex.getMessage(), ex});
                    body.put((Object)parmName, (Object)parm.getValue().getContent());
                }
                continue;
            }
            body.put((Object)parmName, (Object)parm.getValue().getContent());
        }
    }

    private void refreshCacheIfNecessary(Event event) {
        String uei = event.getUei();
        if (uei != null && uei.startsWith("uei.opennms.org/nodes/") && (uei.endsWith("Added") || uei.endsWith("Deleted") || uei.endsWith("Updated") || uei.endsWith("Changed"))) {
            this.nodeCache.refreshEntry(event.getNodeid());
        }
    }

    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public void setIndexSettings(IndexSettings indexSettings) {
        this.indexSettings = Objects.requireNonNull(indexSettings);
    }

    private static final void logEsError(String operation, String index, String type, String result, int responseCode, String errorMessage) {
        LOG.error("Error while performing {} on Elasticsearch index: {}, type: {}\n   received result: {}\n   response code: {}\n   error message: {}", new Object[]{operation, index, type, result, responseCode, errorMessage});
    }

    private static final void logEsDebug(String operation, String index, String type, String result, int responseCode, String errorMessage) {
        LOG.debug("Performed {} on Elasticsearch index: {}, type: {}\n   received result: {}\n   response code: {}\n   error message: {}", new Object[]{operation, index, type, result, responseCode, errorMessage});
    }

    protected static boolean isOID(String input) {
        return input.matches("^(\\.[0-9]+)+$");
    }
}

