/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.outage;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.model.outage.OutageSummary;
import org.opennms.web.filter.Filter;
import org.opennms.web.outage.Outage;
import org.opennms.web.outage.OutageType;
import org.opennms.web.outage.SortStyle;
import org.opennms.web.outage.WebOutageRepository;
import org.opennms.web.outage.filter.OutageCriteria;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class DaoWebOutageRepository
implements WebOutageRepository,
InitializingBean {
    @Autowired
    private OutageDao m_outageDao;
    @Autowired
    private NodeDao m_nodeDao;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    private OnmsCriteria getOnmsCriteria(OutageCriteria outageCriteria) {
        final OnmsCriteria criteria = new OnmsCriteria(OnmsOutage.class);
        criteria.createAlias("serviceLostEvent.distPoller", "distPoller");
        criteria.createAlias("monitoredService", "monitoredService");
        criteria.createAlias("monitoredService.ipInterface", "ipInterface");
        criteria.createAlias("monitoredService.ipInterface.node", "node");
        criteria.createAlias("monitoredService.serviceType", "serviceType");
        outageCriteria.visit(new OutageCriteria.OutageCriteriaVisitor<RuntimeException>(){

            @Override
            public void visitOutageType(OutageType ackType) throws RuntimeException {
                if (ackType == OutageType.CURRENT) {
                    criteria.add(Restrictions.isNull((String)"ifRegainedService"));
                } else if (ackType == OutageType.RESOLVED) {
                    criteria.add(Restrictions.isNotNull((String)"ifRegainedService"));
                }
            }

            @Override
            public void visitFilter(Filter filter) throws RuntimeException {
                criteria.add(filter.getCriterion());
            }

            @Override
            public void visitGroupBy() throws RuntimeException {
            }

            @Override
            public void visitLimit(int limit, int offset) throws RuntimeException {
                criteria.setMaxResults(Integer.valueOf(limit));
                criteria.setFirstResult(Integer.valueOf(offset));
            }

            @Override
            public void visitSortStyle(SortStyle sortStyle) throws RuntimeException {
                switch (sortStyle) {
                    case FOREIGNSOURCE: {
                        criteria.addOrder(Order.desc((String)"node.foreignSource"));
                        break;
                    }
                    case NODE: {
                        criteria.addOrder(Order.desc((String)"node.label"));
                        break;
                    }
                    case INTERFACE: {
                        criteria.addOrder(Order.desc((String)"ipInterface.ipAddress"));
                        break;
                    }
                    case SERVICE: {
                        criteria.addOrder(Order.desc((String)"serviceType.name"));
                        break;
                    }
                    case IFLOSTSERVICE: {
                        criteria.addOrder(Order.desc((String)"ifLostService"));
                        break;
                    }
                    case IFREGAINEDSERVICE: {
                        criteria.addOrder(Order.desc((String)"ifRegainedService"));
                        break;
                    }
                    case ID: {
                        criteria.addOrder(Order.desc((String)"id"));
                        break;
                    }
                    case LOCATION: {
                        criteria.addOrder(Order.desc((String)"node.location"));
                        break;
                    }
                    case PERSPECTIVE: {
                        criteria.addOrder(Order.desc((String)"perspective"));
                        break;
                    }
                    case REVERSE_FOREIGNSOURCE: {
                        criteria.addOrder(Order.asc((String)"node.foreignSource"));
                        break;
                    }
                    case REVERSE_NODE: {
                        criteria.addOrder(Order.asc((String)"node.label"));
                        break;
                    }
                    case REVERSE_INTERFACE: {
                        criteria.addOrder(Order.asc((String)"ipInterface.ipAddress"));
                        break;
                    }
                    case REVERSE_SERVICE: {
                        criteria.addOrder(Order.asc((String)"serviceType.name"));
                        break;
                    }
                    case REVERSE_IFLOSTSERVICE: {
                        criteria.addOrder(Order.asc((String)"ifLostService"));
                        break;
                    }
                    case REVERSE_IFREGAINEDSERVICE: {
                        criteria.addOrder(Order.asc((String)"ifRegainedService"));
                        break;
                    }
                    case REVERSE_ID: {
                        criteria.addOrder(Order.asc((String)"id"));
                        break;
                    }
                    case REVERSE_LOCATION: {
                        criteria.addOrder(Order.asc((String)"node.location"));
                        break;
                    }
                    case REVERSE_PERSPECTIVE: {
                        criteria.addOrder(Order.asc((String)"perspective"));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown SortStyle: " + sortStyle);
                    }
                }
            }
        });
        return criteria;
    }

    private Outage mapOnmsOutageToOutage(OnmsOutage onmsOutage) {
        if (onmsOutage != null) {
            Outage outage = new Outage();
            String outageAddress = InetAddressUtils.str((InetAddress)onmsOutage.getIpAddress());
            outage.outageId = onmsOutage.getId();
            outage.ipAddress = outageAddress;
            outage.hostname = outageAddress;
            outage.lostServiceTime = onmsOutage.getIfLostService();
            outage.regainedServiceTime = onmsOutage.getIfRegainedService();
            outage.serviceId = onmsOutage.getServiceId();
            outage.serviceName = onmsOutage.getMonitoredService() != null ? onmsOutage.getMonitoredService().getServiceName() : "";
            outage.suppressedBy = onmsOutage.getSuppressedBy();
            outage.suppressTime = onmsOutage.getSuppressTime();
            outage.perspectiveLocation = Optional.ofNullable(onmsOutage.getPerspective()).map(OnmsMonitoringLocation::getLocationName).orElse(null);
            outage.nodeId = onmsOutage.getNodeId();
            outage.location = "";
            OnmsNode node = onmsOutage.getNode();
            if (node != null) {
                outage.nodeLabel = node.getLabel();
                if (node.getLocation() != null) {
                    outage.location = node.getLocation().getLocationName();
                }
            }
            OnmsEvent event = onmsOutage.getServiceLostEvent();
            outage.lostServiceEventId = 0;
            outage.regainedServiceEventId = 0;
            if (event != null) {
                outage.lostServiceEventId = onmsOutage.getServiceLostEvent().getId();
                if (event.getDistPoller() != null) {
                    outage.eventLocation = event.getDistPoller().getLocation();
                }
            }
            if (onmsOutage.getServiceRegainedEvent() != null) {
                outage.regainedServiceEventId = onmsOutage.getServiceRegainedEvent().getId();
            }
            return outage;
        }
        return null;
    }

    private OutageSummary mapOnmsOutageToOutageSummary(OnmsOutage onmsOutage) {
        return new OutageSummary(onmsOutage.getNodeId().intValue(), onmsOutage.getMonitoredService().getIpInterface().getNode().getLabel(), onmsOutage.getIfLostService(), onmsOutage.getIfRegainedService(), new Date());
    }

    @Override
    @Transactional
    public int countMatchingOutageSummaries(OutageCriteria criteria) {
        return this.getMatchingOutageSummaries(criteria).length;
    }

    @Override
    @Transactional
    public int countMatchingOutages(OutageCriteria criteria) {
        return this.m_outageDao.countMatching(this.getOnmsCriteria(criteria));
    }

    @Override
    @Transactional
    public OutageSummary[] getMatchingOutageSummaries(OutageCriteria criteria) {
        List onmsOutages = this.m_outageDao.findMatching(this.getOnmsCriteria(criteria));
        return this.getOutageSummary(onmsOutages).toArray(new OutageSummary[0]);
    }

    private List<OutageSummary> getOutageSummary(List<OnmsOutage> onmsOutages) {
        ArrayList<OutageSummary> outages = new ArrayList<OutageSummary>();
        if (onmsOutages.size() > 0) {
            for (OnmsOutage outage : onmsOutages) {
                if (outage.getIfRegainedService() != null) continue;
                outages.add(this.mapOnmsOutageToOutageSummary(outage));
            }
            return this.elimenateDuplicates(outages);
        }
        return outages;
    }

    private List<OutageSummary> elimenateDuplicates(List<OutageSummary> outagesSummaries) {
        HashMap<Integer, OutageSummary> uniqueSummaries = new HashMap<Integer, OutageSummary>();
        for (OutageSummary outageSum : outagesSummaries) {
            if (uniqueSummaries.containsKey(outageSum.getNodeId())) continue;
            uniqueSummaries.put(outageSum.getNodeId(), outageSum);
        }
        ArrayList<OutageSummary> uniqueList = new ArrayList<OutageSummary>(uniqueSummaries.values());
        Collections.sort(uniqueList);
        return uniqueList;
    }

    @Override
    @Transactional
    public Outage[] getMatchingOutages(OutageCriteria criteria) {
        ArrayList<Outage> outages = new ArrayList<Outage>();
        List onmsOutages = this.m_outageDao.findMatching(this.getOnmsCriteria(criteria));
        for (OnmsOutage outage : onmsOutages) {
            outages.add(this.mapOnmsOutageToOutage(outage));
        }
        return outages.toArray(new Outage[0]);
    }

    @Override
    @Transactional
    public Outage getOutage(int OutageId) {
        return this.mapOnmsOutageToOutage((OnmsOutage)this.m_outageDao.get((Serializable)Integer.valueOf(OutageId)));
    }

    @Override
    @Transactional
    public int countCurrentOutages() {
        return this.m_outageDao.countOutagesByNode();
    }

    @Override
    @Transactional
    public OutageSummary[] getCurrentOutages(int rows) {
        return this.m_outageDao.getNodeOutageSummaries(rows).toArray(new OutageSummary[0]);
    }
}

