/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.admin.thresholds;

import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.config.dao.thresholding.api.WriteableThresholdingDao;
import org.opennms.netmgt.config.threshd.Basethresholddef;
import org.opennms.netmgt.config.threshd.Expression;
import org.opennms.netmgt.config.threshd.FilterOperator;
import org.opennms.netmgt.config.threshd.Group;
import org.opennms.netmgt.config.threshd.ResourceFilter;
import org.opennms.netmgt.config.threshd.Threshold;
import org.opennms.netmgt.config.threshd.ThresholdType;
import org.opennms.netmgt.config.threshd.ThresholdingConfig;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.dao.support.GenericIndexResourceType;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.eventconf.AlarmData;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.LogDestType;
import org.opennms.netmgt.xml.eventconf.Logmsg;
import org.opennms.web.api.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class ThresholdController
extends AbstractController
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(ThresholdController.class);
    private static final String SAVE_BUTTON_TITLE = "Save";
    private static final String CANCEL_BUTTON_TITLE = "Cancel";
    private static final String ADDFILTER_BUTTON_TITLE = "Add";
    private static final String EDIT_BUTTON_TITLE = "Edit";
    private static final String DELETE_BUTTON_TITLE = "Delete";
    private static final String UPDATE_BUTTON_TITLE = "Update";
    private static final String MOVEUP_BUTTON_TITLE = "Up";
    private static final String MOVEDOWN_BUTTON_TITLE = "Down";
    private ResourceDao m_resourceDao;
    private EventConfDao m_eventConfDao;
    private boolean eventConfChanged = false;
    @Autowired
    private WriteableThresholdingDao thresholdingDao;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView;
        String editGroup = request.getParameter("editGroup");
        String deleteThreshold = request.getParameter("deleteThreshold");
        String editThreshold = request.getParameter("editThreshold");
        String newThreshold = request.getParameter("newThreshold");
        String finishThresholdEdit = request.getParameter("finishThresholdEdit");
        String deleteExpression = request.getParameter("deleteExpression");
        String editExpression = request.getParameter("editExpression");
        String newExpression = request.getParameter("newExpression");
        String finishExpressionEdit = request.getParameter("finishExpressionEdit");
        String groupName = request.getParameter("groupName");
        String reloadThreshdConfig = request.getParameter("reloadThreshdConfig");
        if (editGroup != null) {
            modelAndView = this.gotoGroupEdit(groupName);
        } else if (newThreshold != null) {
            modelAndView = this.gotoNewThreshold(groupName);
        } else if (editThreshold != null) {
            String thresholdIndexString = request.getParameter("thresholdIndex");
            modelAndView = this.gotoEditThreshold(thresholdIndexString, groupName);
        } else if (deleteThreshold != null) {
            String thresholdIndexString = request.getParameter("thresholdIndex");
            modelAndView = this.deleteThreshold(thresholdIndexString, groupName);
        } else if (finishThresholdEdit != null) {
            modelAndView = this.finishThresholdEdit(request);
        } else if (newExpression != null) {
            modelAndView = this.gotoNewExpression(groupName);
        } else if (editExpression != null) {
            String expressionIndexString = request.getParameter("expressionIndex");
            modelAndView = this.gotoEditExpression(expressionIndexString, groupName);
        } else if (deleteExpression != null) {
            String expressionIndexString = request.getParameter("expressionIndex");
            modelAndView = this.deleteExpression(expressionIndexString, groupName);
        } else {
            modelAndView = finishExpressionEdit != null ? this.finishExpressionEdit(request) : (reloadThreshdConfig != null ? this.reloadThreshdConfig() : this.gotoGroupList());
        }
        return modelAndView;
    }

    private ModelAndView gotoGroupEdit(String groupName) {
        ModelAndView modelAndView = new ModelAndView("admin/thresholds/editGroup");
        modelAndView.addObject("group", (Object)((ThresholdingConfig)this.thresholdingDao.getWriteableConfig()).getGroup(groupName));
        return modelAndView;
    }

    private void addStandardEditingBits(ModelAndView modelAndView) {
        LinkedHashMap<String, Object> dsTypes = new LinkedHashMap<String, Object>();
        dsTypes.put("node", "Node");
        dsTypes.put("if", "Interface");
        Collection resourceTypes = this.m_resourceDao.getResourceTypes();
        TreeMultimap genericDsTypes = TreeMultimap.create();
        for (OnmsResourceType resourceType : resourceTypes) {
            if (!(resourceType instanceof GenericIndexResourceType)) continue;
            String label = resourceType.getLabel();
            String name = resourceType.getName();
            if (label == null) {
                LOG.warn("Label should not be null for resource {}", (Object)resourceType);
                genericDsTypes.put((Object)name, (Object)name);
                continue;
            }
            genericDsTypes.put((Object)label, (Object)name);
        }
        for (ThresholdType[] rtLabel : genericDsTypes.keys()) {
            Collection rtNames = genericDsTypes.get((Object)rtLabel);
            for (String rtName : rtNames) {
                if (rtNames.size() > 1) {
                    dsTypes.put(rtName, (String)rtLabel + " [" + rtName + "]");
                    continue;
                }
                dsTypes.put(rtName, rtLabel);
            }
        }
        modelAndView.addObject("dsTypes", dsTypes);
        ArrayList<String> thresholdTypes = new ArrayList<String>();
        for (ThresholdType tt : ThresholdType.values()) {
            thresholdTypes.add(tt.getEnumName());
        }
        modelAndView.addObject("thresholdTypes", thresholdTypes);
        ArrayList<String> filterOperators = new ArrayList<String>();
        for (FilterOperator fo : FilterOperator.values()) {
            filterOperators.add(fo.getEnumName());
        }
        modelAndView.addObject("filterOperators", filterOperators);
        modelAndView.addObject("saveButtonTitle", (Object)SAVE_BUTTON_TITLE);
        modelAndView.addObject("cancelButtonTitle", (Object)CANCEL_BUTTON_TITLE);
        modelAndView.addObject("addFilterButtonTitle", (Object)ADDFILTER_BUTTON_TITLE);
        modelAndView.addObject("editButtonTitle", (Object)EDIT_BUTTON_TITLE);
        modelAndView.addObject("deleteButtonTitle", (Object)DELETE_BUTTON_TITLE);
        modelAndView.addObject("updateButtonTitle", (Object)UPDATE_BUTTON_TITLE);
        modelAndView.addObject("moveUpButtonTitle", (Object)MOVEUP_BUTTON_TITLE);
        modelAndView.addObject("moveDownButtonTitle", (Object)MOVEDOWN_BUTTON_TITLE);
    }

    private int addNewDefaultThreshold(Group group) {
        List thresholds = group.getThresholds();
        int thresholdIndex = thresholds.size();
        Threshold threshold = null;
        if (thresholdIndex > 0) {
            threshold = (Threshold)thresholds.get(thresholdIndex - 1);
            if (threshold.getDsName() == null || threshold.getDsName().equals("")) {
                --thresholdIndex;
            } else {
                threshold = null;
            }
        }
        if (threshold == null) {
            threshold = new Threshold();
            threshold.setDsType("node");
            threshold.setType(ThresholdType.HIGH);
            threshold.setTrigger("1");
            group.addThreshold(threshold);
        }
        if (threshold != thresholds.get(thresholdIndex)) {
            for (int i = 0; i < thresholds.size(); ++i) {
                if (threshold != thresholds.get(i)) continue;
                thresholdIndex = i;
                break;
            }
        }
        return thresholdIndex;
    }

    private ModelAndView gotoNewThreshold(String groupName) {
        Group group = ((ThresholdingConfig)this.thresholdingDao.getWriteableConfig()).getGroup(groupName);
        int thresholdIndex = this.addNewDefaultThreshold(group);
        Threshold threshold = (Threshold)group.getThresholds().get(thresholdIndex);
        ModelAndView modelAndView = new ModelAndView("admin/thresholds/editThreshold");
        modelAndView.addObject("threshold", (Object)threshold);
        modelAndView.addObject("thresholdIndex", (Object)thresholdIndex);
        modelAndView.addObject("groupName", (Object)groupName);
        modelAndView.addObject("isNew", (Object)true);
        this.addStandardEditingBits(modelAndView);
        return modelAndView;
    }

    private int addNewDefaultExpression(Group group) {
        List expressions = group.getExpressions();
        int expressionIndex = expressions.size();
        Expression expression = null;
        if (expressionIndex > 0) {
            expression = (Expression)expressions.get(expressionIndex - 1);
            if (expression.getExpression() == null || expression.getExpression().equals("")) {
                --expressionIndex;
            } else {
                expression = null;
            }
        }
        if (expression == null) {
            expression = new Expression();
            expression.setDsType("node");
            expression.setType(ThresholdType.HIGH);
            expression.setTrigger("1");
            group.addExpression(expression);
        }
        if (expression != expressions.get(expressionIndex)) {
            for (int i = 0; i < expressions.size(); ++i) {
                if (expression != expressions.get(i)) continue;
                expressionIndex = i;
                break;
            }
        }
        return expressionIndex;
    }

    private ModelAndView gotoNewExpression(String groupName) {
        Group group = ((ThresholdingConfig)this.thresholdingDao.getWriteableConfig()).getGroup(groupName);
        int expressionIndex = this.addNewDefaultExpression(group);
        Expression expression = (Expression)group.getExpressions().get(expressionIndex);
        ModelAndView modelAndView = new ModelAndView("admin/thresholds/editExpression");
        modelAndView.addObject("expression", (Object)expression);
        modelAndView.addObject("expressionIndex", (Object)expressionIndex);
        modelAndView.addObject("groupName", (Object)groupName);
        modelAndView.addObject("isNew", (Object)true);
        this.addStandardEditingBits(modelAndView);
        return modelAndView;
    }

    private ModelAndView gotoEditThreshold(String thresholdIndexString, String groupName) throws ServletException {
        if (thresholdIndexString == null) {
            throw new ServletException("thresholdIndex parameter required to edit a threshold");
        }
        int thresholdIndex = WebSecurityUtils.safeParseInt((String)thresholdIndexString);
        Threshold threshold = (Threshold)((ThresholdingConfig)this.thresholdingDao.getWriteableConfig()).getGroup(groupName).getThresholds().get(thresholdIndex);
        ModelAndView modelAndView = new ModelAndView("admin/thresholds/editThreshold");
        modelAndView.addObject("threshold", (Object)threshold);
        modelAndView.addObject("thresholdIndex", (Object)thresholdIndex);
        modelAndView.addObject("groupName", (Object)groupName);
        modelAndView.addObject("isNew", (Object)false);
        this.addStandardEditingBits(modelAndView);
        return modelAndView;
    }

    private void moveThresholdFilter(Basethresholddef threshold, int oldPos, int newPos) {
        if (newPos >= 0 && newPos < threshold.getResourceFilters().size()) {
            ResourceFilter oldFilter = (ResourceFilter)threshold.getResourceFilters().get(oldPos);
            ResourceFilter newFilter = (ResourceFilter)threshold.getResourceFilters().get(newPos);
            threshold.getResourceFilters().set(newPos, oldFilter);
            threshold.getResourceFilters().set(oldPos, newFilter);
        }
    }

    private List<ResourceFilter> getFilterList(HttpServletRequest request, boolean create) {
        return (List)request.getSession(create).getAttribute("savedFilters");
    }

    private void setFilterList(HttpServletRequest request, List<ResourceFilter> filters) {
        if (filters == null) {
            request.getSession(false).removeAttribute("savedFilters");
        } else {
            request.getSession(false).setAttribute("savedFilters", filters);
        }
    }

    private ModelAndView finishThresholdFilterEdit(HttpServletRequest request, Basethresholddef threshold) throws ServletException {
        String stringIndex;
        boolean isExpression = threshold instanceof Expression;
        int thresholdIndex = isExpression ? WebSecurityUtils.safeParseInt((String)request.getParameter("expressionIndex")) : WebSecurityUtils.safeParseInt((String)request.getParameter("thresholdIndex"));
        ModelAndView modelAndView = isExpression ? new ModelAndView("admin/thresholds/editExpression") : new ModelAndView("admin/thresholds/editThreshold");
        List<ResourceFilter> saved = this.getFilterList(request, true);
        if (saved == null || saved.size() == 0) {
            saved = new ArrayList<ResourceFilter>(threshold.getResourceFilters());
            this.setFilterList(request, saved);
        }
        int filterIndex = (stringIndex = request.getParameter("filterSelected")) != null && !stringIndex.equals("") ? WebSecurityUtils.safeParseInt((String)stringIndex) - 1 : 0;
        String submitAction = request.getParameter("submitAction");
        if (ADDFILTER_BUTTON_TITLE.equals(submitAction)) {
            String field = request.getParameter("filterField");
            String content = request.getParameter("filterRegexp");
            if (field != null && !field.equals("") && content != null && !content.equals("")) {
                ResourceFilter filter = new ResourceFilter();
                filter.setField(field);
                filter.setContent(content);
                threshold.addResourceFilter(filter);
            }
        } else if (DELETE_BUTTON_TITLE.equals(submitAction)) {
            threshold.getResourceFilters().remove(filterIndex);
        } else if (EDIT_BUTTON_TITLE.equals(submitAction)) {
            modelAndView.addObject("filterSelected", (Object)request.getParameter("filterSelected"));
        } else if (UPDATE_BUTTON_TITLE.equals(submitAction)) {
            ResourceFilter filter = (ResourceFilter)threshold.getResourceFilters().get(filterIndex);
            filter.setField(request.getParameter("updateFilterField"));
            filter.setContent(request.getParameter("updateFilterRegexp"));
        } else if (MOVEUP_BUTTON_TITLE.equals(submitAction)) {
            this.moveThresholdFilter(threshold, filterIndex, filterIndex - 1);
        } else if (MOVEDOWN_BUTTON_TITLE.equals(submitAction)) {
            this.moveThresholdFilter(threshold, filterIndex, filterIndex + 1);
        }
        this.commonFinishEdit(request, threshold);
        if (isExpression) {
            ((Expression)threshold).setExpression(request.getParameter("expression"));
        } else {
            ((Threshold)threshold).setDsName(request.getParameter("dsName"));
        }
        String isNew = request.getParameter("isNew");
        if ("true".equals(isNew)) {
            modelAndView.addObject("isNew", (Object)true);
        }
        if (isExpression) {
            modelAndView.addObject("expression", (Object)threshold);
            modelAndView.addObject("expressionIndex", (Object)thresholdIndex);
        } else {
            modelAndView.addObject("threshold", (Object)threshold);
            modelAndView.addObject("thresholdIndex", (Object)thresholdIndex);
        }
        modelAndView.addObject("groupName", (Object)request.getParameter("groupName"));
        this.addStandardEditingBits(modelAndView);
        return modelAndView;
    }

    private ModelAndView gotoEditExpression(String expressionIndexString, String groupName) throws ServletException {
        if (expressionIndexString == null) {
            throw new ServletException("expressionIndex parameter required to edit a threshold");
        }
        int expressionIndex = WebSecurityUtils.safeParseInt((String)expressionIndexString);
        Expression expression = (Expression)((ThresholdingConfig)this.thresholdingDao.getWriteableConfig()).getGroup(groupName).getExpressions().get(expressionIndex);
        ModelAndView modelAndView = new ModelAndView("admin/thresholds/editExpression");
        modelAndView.addObject("expression", (Object)expression);
        modelAndView.addObject("expressionIndex", (Object)expressionIndex);
        modelAndView.addObject("groupName", (Object)groupName);
        modelAndView.addObject("isNew", (Object)false);
        this.addStandardEditingBits(modelAndView);
        return modelAndView;
    }

    private EventBuilder createEventBuilder(String uei) {
        EventBuilder ebldr = new EventBuilder(uei, "Web UI");
        ebldr.setHost(InetAddressUtils.getLocalHostName());
        return ebldr;
    }

    private void sendNotifEvent(org.opennms.netmgt.xml.event.Event event) throws ServletException {
        try {
            Util.createEventProxy().send(event);
        }
        catch (Throwable e) {
            throw new ServletException("Could not send event " + event.getUei(), e);
        }
    }

    private void saveChanges() throws ServletException {
        try {
            this.thresholdingDao.saveConfig();
            EventBuilder ebldr = this.createEventBuilder("uei.opennms.org/internal/reloadDaemonConfig");
            ebldr.addParam("daemonName", "Threshd");
            ebldr.addParam("configFile", "thresholds.xml");
            this.sendNotifEvent(ebldr.getEvent());
        }
        catch (Throwable e) {
            throw new ServletException("Could not save the changes to the threshold because " + e.getMessage(), e);
        }
        if (this.eventConfChanged) {
            try {
                this.m_eventConfDao.saveCurrent();
                this.sendNotifEvent(this.createEventBuilder("uei.opennms.org/internal/eventsConfigChange").getEvent());
            }
            catch (Throwable e) {
                throw new ServletException("Could not save the changes to the event configuration because " + e.getMessage(), e);
            }
            this.eventConfChanged = false;
        }
    }

    private ModelAndView deleteThreshold(String thresholdIndexString, String groupName) throws ServletException {
        if (thresholdIndexString == null) {
            throw new ServletException("thresholdIndex parameter required to delete a threshold");
        }
        int thresholdIndex = WebSecurityUtils.safeParseInt((String)thresholdIndexString);
        Group group = ((ThresholdingConfig)this.thresholdingDao.getWriteableConfig()).getGroup(groupName);
        group.removeThreshold((Threshold)group.getThresholds().get(thresholdIndex));
        ModelAndView modelAndView = new ModelAndView("admin/thresholds/editGroup");
        modelAndView.addObject("group", (Object)group);
        this.saveChanges();
        return modelAndView;
    }

    private ModelAndView reloadThreshdConfig() throws ServletException {
        try {
            EventBuilder ebldr = this.createEventBuilder("uei.opennms.org/internal/reloadDaemonConfig");
            ebldr.addParam("daemonName", "Threshd");
            ebldr.addParam("configFile", "threshd-configuration.xml");
            this.sendNotifEvent(ebldr.getEvent());
        }
        catch (Throwable e) {
            throw new ServletException("Could not reload threshd-configuration.xml because " + e.getMessage(), e);
        }
        return this.gotoGroupList();
    }

    private ModelAndView deleteExpression(String expressionIndexString, String groupName) throws ServletException {
        if (expressionIndexString == null) {
            throw new ServletException("expressionIndex parameter required to delete a threshold expression");
        }
        int expressionIndex = WebSecurityUtils.safeParseInt((String)expressionIndexString);
        Group group = ((ThresholdingConfig)this.thresholdingDao.getWriteableConfig()).getGroup(groupName);
        group.removeExpression((Expression)group.getExpressions().get(expressionIndex));
        this.saveChanges();
        ModelAndView modelAndView = new ModelAndView("admin/thresholds/editGroup");
        modelAndView.addObject("group", (Object)group);
        return modelAndView;
    }

    private void commonFinishEdit(HttpServletRequest request, Basethresholddef baseDef) {
        String dsLabel = request.getParameter("dsLabel");
        if (dsLabel == null || "".equals(dsLabel)) {
            baseDef.setDsLabel(null);
        } else {
            baseDef.setDsLabel(dsLabel);
        }
        String description = request.getParameter("description");
        if (description == null || "".equals(description)) {
            baseDef.setDescription(null);
        } else {
            baseDef.setDescription(description);
        }
        String dsType = request.getParameter("dsType");
        String thresholdType = request.getParameter("type");
        baseDef.setDsType(dsType == null ? null : dsType);
        baseDef.setType(thresholdType == null ? null : ThresholdType.forName((String)thresholdType));
        try {
            baseDef.setRearm(request.getParameter("rearm"));
        }
        catch (NumberFormatException e) {
            LOG.warn("Failed to parse rearm ('{}') as a number.", (Object)request.getParameter("rearm"));
        }
        try {
            baseDef.setTrigger(request.getParameter("trigger"));
        }
        catch (NumberFormatException e) {
            LOG.warn("Failed to parse trigger ('{}') as a number.", (Object)request.getParameter("trigger"));
        }
        try {
            baseDef.setValue(request.getParameter("value"));
        }
        catch (NumberFormatException e) {
            LOG.warn("Failed to parse value ('{}') as a number.", (Object)request.getParameter("value"));
        }
        String clearKey = null;
        String triggeredUEI = request.getParameter("triggeredUEI");
        if (triggeredUEI == null || "".equals(triggeredUEI)) {
            baseDef.setTriggeredUEI(null);
        } else {
            Event source = this.getSourceEvent(baseDef.getType(), true);
            if (source != null && source.getAlarmData() != null && source.getAlarmData().getReductionKey() != null) {
                clearKey = source.getAlarmData().getReductionKey().replace("%uei%", triggeredUEI);
            }
            baseDef.setTriggeredUEI(triggeredUEI);
            this.ensureUEIInEventConf(source, triggeredUEI, baseDef.getType(), null, true);
        }
        String rearmedUEI = request.getParameter("rearmedUEI");
        if (rearmedUEI == null || "".equals(rearmedUEI) || baseDef.getType().equals((Object)ThresholdType.RELATIVE_CHANGE) || baseDef.getType().equals((Object)ThresholdType.ABSOLUTE_CHANGE)) {
            baseDef.setRearmedUEI(null);
        } else {
            Event source = this.getSourceEvent(baseDef.getType(), false);
            baseDef.setRearmedUEI(rearmedUEI);
            this.ensureUEIInEventConf(source, rearmedUEI, baseDef.getType(), clearKey, false);
        }
    }

    private Event getSourceEvent(ThresholdType thresholdType, boolean isTrigger) {
        String sourceUei = null;
        switch (thresholdType) {
            case HIGH: {
                sourceUei = isTrigger ? "uei.opennms.org/threshold/highThresholdExceeded" : "uei.opennms.org/threshold/highThresholdRearmed";
                break;
            }
            case LOW: {
                sourceUei = isTrigger ? "uei.opennms.org/threshold/lowThresholdExceeded" : "uei.opennms.org/threshold/lowThresholdRearmed";
                break;
            }
            case RELATIVE_CHANGE: {
                sourceUei = isTrigger ? "uei.opennms.org/threshold/relativeChangeExceeded" : null;
                break;
            }
            case ABSOLUTE_CHANGE: {
                sourceUei = isTrigger ? "uei.opennms.org/threshold/absoluteChangeExceeded" : null;
                break;
            }
            case REARMING_ABSOLUTE_CHANGE: {
                String string = sourceUei = isTrigger ? "uei.opennms.org/threshold/rearmingAbsoluteChangeExceeded" : "uei.opennms.org/threshold/rearmingAbsoluteChangeRearmed";
            }
        }
        if (sourceUei == null) {
            return null;
        }
        List eventsForUEI = this.m_eventConfDao.getEvents(sourceUei);
        if (eventsForUEI != null && eventsForUEI.size() > 0) {
            return (Event)eventsForUEI.get(0);
        }
        return null;
    }

    private void ensureUEIInEventConf(Event source, String targetUei, ThresholdType thresholdType, String clearKey, boolean isTrigger) {
        List eventsForUEI = this.m_eventConfDao.getEvents(targetUei);
        if (eventsForUEI == null || eventsForUEI.size() == 0) {
            String typeDesc = isTrigger ? "exceeded" : "rearmed";
            Event event = new Event();
            event.setUei(targetUei);
            event.setEventLabel("User-defined " + thresholdType + " threshold event " + typeDesc + ": " + targetUei);
            Logmsg logmsg = new Logmsg();
            event.setLogmsg(logmsg);
            if (source == null) {
                event.setDescr("Threshold " + typeDesc + " for %service% datasource %parm[ds]% on interface %interface%, parms: %parm[all]%");
                logmsg.setDest(LogDestType.LOGNDISPLAY);
                logmsg.setContent("Threshold " + typeDesc + " for %service% datasource %parm[ds]% on interface %interface%, parms: %parm[all]%");
                event.setLogmsg(logmsg);
                event.setSeverity("Warning");
            } else {
                event.setDescr(source.getDescr());
                event.setSeverity(source.getSeverity());
                event.setOperinstruct(source.getOperinstruct());
                logmsg.setDest(source.getLogmsg().getDest());
                logmsg.setContent(source.getLogmsg().getContent());
                if (source.getAlarmData() != null) {
                    AlarmData alarmData = new AlarmData();
                    AlarmData sourceAlarmData = source.getAlarmData();
                    alarmData.setAlarmType(sourceAlarmData.getAlarmType());
                    alarmData.setAutoClean(sourceAlarmData.getAutoClean());
                    alarmData.setReductionKey(sourceAlarmData.getReductionKey());
                    if (!isTrigger && clearKey != null) {
                        alarmData.setClearKey(clearKey);
                    }
                    event.setAlarmData(alarmData);
                }
            }
            this.m_eventConfDao.addEventToProgrammaticStore(event);
            this.eventConfChanged = true;
        }
    }

    private ModelAndView finishThresholdEdit(HttpServletRequest request) throws ServletException {
        String groupName = request.getParameter("groupName");
        String submitAction = request.getParameter("submitAction");
        Group group = ((ThresholdingConfig)this.thresholdingDao.getWriteableConfig()).getGroup(groupName);
        String thresholdIndexString = request.getParameter("thresholdIndex");
        if (thresholdIndexString == null) {
            throw new ServletException("thresholdIndex parameter required to modify or delete a threshold");
        }
        int thresholdIndex = WebSecurityUtils.safeParseInt((String)thresholdIndexString);
        if (thresholdIndex >= group.getThresholds().size()) {
            thresholdIndex = this.addNewDefaultThreshold(group);
        }
        Threshold threshold = (Threshold)group.getThresholds().get(thresholdIndex);
        if (SAVE_BUTTON_TITLE.equals(submitAction)) {
            this.commonFinishEdit(request, (Basethresholddef)threshold);
            String dsName = request.getParameter("dsName");
            String filterOperator = request.getParameter("filterOperator");
            if (dsName == null || dsName.equals("")) {
                throw new ServletException("ds-name cannot be null or empty string");
            }
            threshold.setDsName(dsName);
            threshold.setFilterOperator(filterOperator == null ? null : FilterOperator.valueOf((String)filterOperator.toUpperCase()));
            this.saveChanges();
        } else if (CANCEL_BUTTON_TITLE.equals(submitAction)) {
            String isNew = request.getParameter("isNew");
            if ("true".equals(isNew)) {
                group.removeThreshold(threshold);
            } else {
                List<ResourceFilter> filters = this.getFilterList(request, false);
                if (filters != null) {
                    threshold.setResourceFilters(filters);
                }
            }
        } else {
            return this.finishThresholdFilterEdit(request, (Basethresholddef)threshold);
        }
        this.setFilterList(request, null);
        ModelAndView modelAndView = new ModelAndView("admin/thresholds/editGroup");
        modelAndView.addObject("group", (Object)group);
        return modelAndView;
    }

    private ModelAndView finishExpressionEdit(HttpServletRequest request) throws ServletException {
        String groupName = request.getParameter("groupName");
        String submitAction = request.getParameter("submitAction");
        Group group = ((ThresholdingConfig)this.thresholdingDao.getWriteableConfig()).getGroup(groupName);
        String expressionIndexString = request.getParameter("expressionIndex");
        if (expressionIndexString == null) {
            throw new ServletException("expressionIndex parameter required to modify or delete a threshold expression");
        }
        int expressionIndex = WebSecurityUtils.safeParseInt((String)expressionIndexString);
        if (expressionIndex >= group.getExpressions().size()) {
            expressionIndex = this.addNewDefaultExpression(group);
        }
        Expression expression = (Expression)group.getExpressions().get(expressionIndex);
        if (SAVE_BUTTON_TITLE.equals(submitAction)) {
            this.commonFinishEdit(request, (Basethresholddef)expression);
            String expDef = request.getParameter("expression");
            String filterOperator = request.getParameter("filterOperator");
            if (expDef == null || expDef.equals("")) {
                throw new ServletException("expression content cannot be null or empty string");
            }
            expression.setExpression(expDef);
            expression.setFilterOperator(filterOperator == null ? null : FilterOperator.valueOf((String)filterOperator.toUpperCase()));
            this.saveChanges();
        } else if (CANCEL_BUTTON_TITLE.equals(submitAction)) {
            String isNew = request.getParameter("isNew");
            if ("true".equals(isNew)) {
                group.removeExpression(expression);
            } else {
                List<ResourceFilter> filters = this.getFilterList(request, false);
                if (filters != null) {
                    expression.setResourceFilters(filters);
                }
            }
        } else {
            return this.finishThresholdFilterEdit(request, (Basethresholddef)expression);
        }
        this.setFilterList(request, null);
        ModelAndView modelAndView = new ModelAndView("admin/thresholds/editGroup");
        modelAndView.addObject("group", (Object)group);
        return modelAndView;
    }

    private ModelAndView gotoGroupList() throws ServletException {
        try {
            this.thresholdingDao.reload();
        }
        catch (Throwable e) {
            throw new ServletException("Could not reload ThresholdingConfigFactory because " + e.getMessage(), e);
        }
        ModelAndView modelAndView = new ModelAndView("admin/thresholds/list");
        TreeMap groupMap = new TreeMap();
        ((ThresholdingConfig)this.thresholdingDao.getWriteableConfig()).getGroups().forEach(g -> groupMap.put(g.getName(), g));
        modelAndView.addObject("groupMap", groupMap);
        return modelAndView;
    }

    public void afterPropertiesSet() throws Exception {
    }

    public void setResourceDao(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    public void setEventConfDao(EventConfDao eventConfDao) {
        this.m_eventConfDao = eventConfDao;
    }
}

