/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema.walker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.ws.commons.schema.walker.XmlSchemaBaseSimpleType;
import org.apache.ws.commons.schema.walker.XmlSchemaRestriction;

public final class XmlSchemaTypeInfo {
    private Type type;
    private HashMap<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> facets;
    private boolean isMixed;
    private XmlSchemaBaseSimpleType baseSimpleType;
    private QName userRecognizedType;
    private List<XmlSchemaTypeInfo> childTypes;

    public XmlSchemaTypeInfo(XmlSchemaTypeInfo listType) {
        this.type = Type.LIST;
        this.childTypes = new ArrayList<XmlSchemaTypeInfo>(1);
        this.childTypes.add(listType);
        this.isMixed = false;
        this.facets = null;
        this.userRecognizedType = null;
    }

    public XmlSchemaTypeInfo(XmlSchemaTypeInfo listType, HashMap<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> facets) {
        this(listType);
        this.facets = facets;
    }

    public XmlSchemaTypeInfo(List<XmlSchemaTypeInfo> unionTypes) {
        this.type = Type.UNION;
        this.childTypes = unionTypes;
        this.isMixed = false;
        this.facets = null;
        this.userRecognizedType = null;
    }

    public XmlSchemaTypeInfo(List<XmlSchemaTypeInfo> unionTypes, HashMap<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> facets) {
        this(unionTypes);
        this.facets = facets;
    }

    public XmlSchemaTypeInfo(XmlSchemaBaseSimpleType baseSimpleType) {
        this.type = baseSimpleType.equals((Object)XmlSchemaBaseSimpleType.ANYTYPE) ? Type.COMPLEX : Type.ATOMIC;
        this.baseSimpleType = baseSimpleType;
        this.isMixed = false;
        this.facets = null;
        this.childTypes = null;
        this.userRecognizedType = null;
    }

    public XmlSchemaTypeInfo(XmlSchemaBaseSimpleType baseSimpleType, HashMap<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> facets) {
        this(baseSimpleType);
        this.facets = facets;
    }

    public XmlSchemaTypeInfo(boolean isMixed) {
        this.type = Type.COMPLEX;
        this.baseSimpleType = XmlSchemaBaseSimpleType.ANYTYPE;
        this.isMixed = isMixed;
        this.facets = null;
        this.childTypes = null;
        this.userRecognizedType = null;
    }

    public HashMap<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> getFacets() {
        return this.facets;
    }

    public XmlSchemaBaseSimpleType getBaseType() {
        return this.baseSimpleType;
    }

    public Type getType() {
        return this.type;
    }

    public List<XmlSchemaTypeInfo> getChildTypes() {
        return this.childTypes;
    }

    public QName getUserRecognizedType() {
        return this.userRecognizedType;
    }

    public boolean isMixed() {
        return this.isMixed;
    }

    public void setUserRecognizedType(QName userRecType) {
        this.userRecognizedType = userRecType;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("XmlSchemaTypeInfo [");
        str.append((Object)this.type).append("] Base Type: ").append((Object)this.baseSimpleType);
        str.append(" User Recognized Type: ").append(this.userRecognizedType);
        str.append(" Is Mixed: ").append(this.isMixed);
        str.append(" Num Children: ");
        str.append(this.childTypes == null ? 0 : this.childTypes.size());
        return str.toString();
    }

    public static enum Type {
        LIST,
        UNION,
        ATOMIC,
        COMPLEX;

    }
}

