/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import net.jradius.tls.Arrays;
import net.jradius.tls.ByteQueue;
import net.jradius.tls.Certificate;
import net.jradius.tls.CertificateVerifyer;
import net.jradius.tls.DefaultTlsClient;
import net.jradius.tls.RecordStream;
import net.jradius.tls.SecurityParameters;
import net.jradius.tls.TlsClient;
import net.jradius.tls.TlsInputStream;
import net.jradius.tls.TlsKeyExchange;
import net.jradius.tls.TlsOutputStream;
import net.jradius.tls.TlsUtils;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Object;
import org.opennms.shaded.org.bouncycastle.asn1.x509.X509Name;
import org.opennms.shaded.org.bouncycastle.crypto.prng.ThreadedSeedGenerator;

public class TlsProtocolHandler {
    private static final int TLS_EMPTY_RENEGOTIATION_INFO_SCSV = 255;
    private static final short RL_CHANGE_CIPHER_SPEC = 20;
    private static final short RL_ALERT = 21;
    private static final short RL_HANDSHAKE = 22;
    private static final short RL_APPLICATION_DATA = 23;
    private static final short HP_HELLO_REQUEST = 0;
    private static final short HP_CLIENT_HELLO = 1;
    private static final short HP_SERVER_HELLO = 2;
    private static final short HP_CERTIFICATE = 11;
    private static final short HP_SERVER_KEY_EXCHANGE = 12;
    private static final short HP_CERTIFICATE_REQUEST = 13;
    private static final short HP_SERVER_HELLO_DONE = 14;
    private static final short HP_CERTIFICATE_VERIFY = 15;
    private static final short HP_CLIENT_KEY_EXCHANGE = 16;
    private static final short HP_FINISHED = 20;
    private static final short CS_CLIENT_HELLO_SEND = 1;
    private static final short CS_SERVER_HELLO_RECEIVED = 2;
    private static final short CS_SERVER_CERTIFICATE_RECEIVED = 3;
    private static final short CS_SERVER_KEY_EXCHANGE_RECEIVED = 4;
    private static final short CS_CERTIFICATE_REQUEST_RECEIVED = 5;
    private static final short CS_SERVER_HELLO_DONE_RECEIVED = 6;
    private static final short CS_CLIENT_KEY_EXCHANGE_SEND = 7;
    private static final short CS_CERTIFICATE_VERIFY_SEND = 8;
    private static final short CS_CLIENT_CHANGE_CIPHER_SPEC_SEND = 9;
    private static final short CS_CLIENT_FINISHED_SEND = 10;
    private static final short CS_SERVER_CHANGE_CIPHER_SPEC_RECEIVED = 11;
    public static final short CS_DONE = 12;
    protected static final short AL_warning = 1;
    protected static final short AL_fatal = 2;
    protected static final short AP_close_notify = 0;
    protected static final short AP_unexpected_message = 10;
    protected static final short AP_bad_record_mac = 20;
    protected static final short AP_decryption_failed = 21;
    protected static final short AP_record_overflow = 22;
    protected static final short AP_decompression_failure = 30;
    protected static final short AP_handshake_failure = 40;
    protected static final short AP_bad_certificate = 42;
    protected static final short AP_unsupported_certificate = 43;
    protected static final short AP_certificate_revoked = 44;
    protected static final short AP_certificate_expired = 45;
    protected static final short AP_certificate_unknown = 46;
    protected static final short AP_illegal_parameter = 47;
    protected static final short AP_unknown_ca = 48;
    protected static final short AP_access_denied = 49;
    protected static final short AP_decode_error = 50;
    protected static final short AP_decrypt_error = 51;
    protected static final short AP_export_restriction = 60;
    protected static final short AP_protocol_version = 70;
    protected static final short AP_insufficient_security = 71;
    protected static final short AP_internal_error = 80;
    protected static final short AP_user_canceled = 90;
    protected static final short AP_no_renegotiation = 100;
    protected static final short AP_unknown_psk_identity = 115;
    private static final byte[] emptybuf = new byte[0];
    private static final String TLS_ERROR_MESSAGE = "Internal TLS error, this could be an attack";
    private ByteQueue applicationDataQueue = new ByteQueue();
    private ByteQueue changeCipherSpecQueue = new ByteQueue();
    private ByteQueue alertQueue = new ByteQueue();
    private ByteQueue handshakeQueue = new ByteQueue();
    private RecordStream rs;
    private SecureRandom random;
    private TlsInputStream tlsInputStream = null;
    private TlsOutputStream tlsOutputStream = null;
    private boolean closed = false;
    private boolean failedWithError = false;
    private boolean appDataReady = false;
    private boolean extendedClientHello;
    private SecurityParameters securityParameters = null;
    private TlsClient tlsClient = null;
    private int[] offeredCipherSuites = null;
    private TlsKeyExchange keyExchange = null;
    private short connection_state = 0;
    private KeyManager[] keyManagers = null;
    private TrustManager[] trustManagers = null;
    private boolean isSendCertificate = false;

    private static SecureRandom createSecureRandom() {
        ThreadedSeedGenerator tsg = new ThreadedSeedGenerator();
        SecureRandom random = new SecureRandom();
        random.setSeed(tsg.generateSeed(20, true));
        return random;
    }

    public TlsProtocolHandler(InputStream is, OutputStream os) {
        this(is, os, TlsProtocolHandler.createSecureRandom());
    }

    public TlsProtocolHandler(InputStream is, OutputStream os, SecureRandom sr) {
        this.rs = new RecordStream(this, is, os);
        this.random = sr;
    }

    public TlsProtocolHandler() {
        this.rs = new RecordStream(this);
        this.random = TlsProtocolHandler.createSecureRandom();
    }

    SecureRandom getRandom() {
        return this.random;
    }

    public void setSendCertificate(boolean b) {
        this.isSendCertificate = b;
    }

    protected void processData(short protocol, byte[] buf, int offset, int len) throws IOException {
        switch (protocol) {
            case 20: {
                this.changeCipherSpecQueue.addData(buf, offset, len);
                this.processChangeCipherSpec();
                break;
            }
            case 21: {
                this.alertQueue.addData(buf, offset, len);
                this.processAlert();
                break;
            }
            case 22: {
                this.handshakeQueue.addData(buf, offset, len);
                this.processHandshake();
                break;
            }
            case 23: {
                if (!this.appDataReady) {
                    this.failWithError((short)2, (short)10);
                }
                this.applicationDataQueue.addData(buf, offset, len);
                this.processApplicationData();
                break;
            }
        }
    }

    private void processHandshake() throws IOException {
        boolean read;
        do {
            read = false;
            if (this.handshakeQueue.size() < 4) continue;
            byte[] beginning = new byte[4];
            this.handshakeQueue.read(beginning, 0, 4, 0);
            ByteArrayInputStream bis = new ByteArrayInputStream(beginning);
            short type = TlsUtils.readUint8(bis);
            int len = TlsUtils.readUint24(bis);
            if (this.handshakeQueue.size() < len + 4) continue;
            byte[] buf = new byte[len];
            this.handshakeQueue.read(buf, 0, len, 4);
            this.handshakeQueue.removeData(len + 4);
            switch (type) {
                case 0: 
                case 20: {
                    break;
                }
                default: {
                    this.rs.updateHandshakeData(beginning, 0, 4);
                    this.rs.updateHandshakeData(buf, 0, len);
                }
            }
            this.processHandshakeMessage(type, buf);
            read = true;
        } while (read);
    }

    private void processHandshakeMessage(short type, byte[] buf) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(buf);
        block0 : switch (type) {
            case 11: {
                switch (this.connection_state) {
                    case 2: {
                        Certificate serverCertificate = Certificate.parse(is);
                        this.assertEmpty(is);
                        this.keyExchange.processServerCertificate(serverCertificate);
                        break;
                    }
                    default: {
                        this.failWithError((short)2, (short)10);
                    }
                }
                this.connection_state = (short)3;
                break;
            }
            case 20: {
                switch (this.connection_state) {
                    case 11: {
                        byte[] serverVerifyData = new byte[12];
                        TlsUtils.readFully(serverVerifyData, is);
                        this.assertEmpty(is);
                        byte[] expectedServerVerifyData = TlsUtils.PRF(this.securityParameters.masterSecret, "server finished", this.rs.getCurrentHash(), 12);
                        if (!Arrays.constantTimeAreEqual(expectedServerVerifyData, serverVerifyData)) {
                            this.failWithError((short)2, (short)40);
                        }
                        this.connection_state = (short)12;
                        this.appDataReady = true;
                        break block0;
                    }
                }
                this.failWithError((short)2, (short)10);
                break;
            }
            case 2: {
                switch (this.connection_state) {
                    case 1: {
                        TlsUtils.checkVersion(is, this);
                        this.securityParameters.serverRandom = new byte[32];
                        TlsUtils.readFully(this.securityParameters.serverRandom, is);
                        byte[] sessionID = TlsUtils.readOpaque8(is);
                        if (sessionID.length > 32) {
                            this.failWithError((short)2, (short)47);
                        }
                        this.tlsClient.notifySessionID(sessionID);
                        int selectedCipherSuite = TlsUtils.readUint16(is);
                        if (!this.wasCipherSuiteOffered(selectedCipherSuite)) {
                            this.failWithError((short)2, (short)47);
                        }
                        this.tlsClient.notifySelectedCipherSuite(selectedCipherSuite);
                        short compressionMethod = TlsUtils.readUint8(is);
                        if (compressionMethod != 0) {
                            this.failWithError((short)2, (short)47);
                        }
                        if (this.extendedClientHello) {
                            Hashtable<Integer, byte[]> serverExtensions = new Hashtable<Integer, byte[]>();
                            if (is.available() > 0) {
                                byte[] extBytes = TlsUtils.readOpaque16(is);
                                ByteArrayInputStream ext = new ByteArrayInputStream(extBytes);
                                while (ext.available() > 0) {
                                    int extType = TlsUtils.readUint16(ext);
                                    byte[] extValue = TlsUtils.readOpaque16(ext);
                                    serverExtensions.put(new Integer(extType), extValue);
                                }
                            }
                            this.tlsClient.processServerExtensions(serverExtensions);
                        }
                        this.assertEmpty(is);
                        this.keyExchange = this.tlsClient.createKeyExchange();
                        this.connection_state = (short)2;
                        break block0;
                    }
                }
                this.failWithError((short)2, (short)10);
                break;
            }
            case 14: {
                switch (this.connection_state) {
                    case 3: {
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 4: 
                    case 5: {
                        byte[] clientCertificateSignature;
                        this.assertEmpty(is);
                        boolean isClientCertificateRequested = this.connection_state == 5 || this.isSendCertificate;
                        this.connection_state = (short)6;
                        if (isClientCertificateRequested) {
                            this.sendClientCertificate(this.tlsClient.getCertificate());
                        }
                        this.sendClientKeyExchange(this.keyExchange.generateClientKeyExchange());
                        this.connection_state = (short)7;
                        if (isClientCertificateRequested && (clientCertificateSignature = this.tlsClient.generateCertificateSignature(this.rs.getCurrentHash())) != null) {
                            this.sendCertificateVerify(clientCertificateSignature);
                            this.connection_state = (short)8;
                        }
                        byte[] cmessage = new byte[]{1};
                        this.rs.writeMessage((short)20, cmessage, 0, cmessage.length);
                        this.connection_state = (short)9;
                        byte[] pms = this.keyExchange.generatePremasterSecret();
                        this.securityParameters.masterSecret = TlsUtils.PRF(pms, "master secret", TlsUtils.concat(this.securityParameters.clientRandom, this.securityParameters.serverRandom), 48);
                        Arrays.fill(pms, (byte)0);
                        this.rs.clientCipherSpecDecided(this.tlsClient.createCipher(this.securityParameters));
                        byte[] clientVerifyData = TlsUtils.PRF(this.securityParameters.masterSecret, "client finished", this.rs.getCurrentHash(), 12);
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        TlsUtils.writeUint8((short)20, bos);
                        TlsUtils.writeOpaque24(clientVerifyData, bos);
                        byte[] message = bos.toByteArray();
                        this.rs.writeMessage((short)22, message, 0, message.length);
                        this.connection_state = (short)10;
                        break block0;
                    }
                }
                this.failWithError((short)2, (short)40);
                break;
            }
            case 12: {
                switch (this.connection_state) {
                    case 2: {
                        this.keyExchange.skipServerCertificate();
                    }
                    case 3: {
                        this.keyExchange.processServerKeyExchange(is, this.securityParameters);
                        this.assertEmpty(is);
                        break;
                    }
                    default: {
                        this.failWithError((short)2, (short)10);
                    }
                }
                this.connection_state = (short)4;
                break;
            }
            case 13: {
                switch (this.connection_state) {
                    case 3: {
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 4: {
                        byte[] types = TlsUtils.readOpaque8(is);
                        byte[] authorities = TlsUtils.readOpaque16(is);
                        this.assertEmpty(is);
                        ArrayList<X509Name> authorityDNs = new ArrayList<X509Name>();
                        ByteArrayInputStream bis = new ByteArrayInputStream(authorities);
                        while (bis.available() > 0) {
                            byte[] dnBytes = TlsUtils.readOpaque16(bis);
                            authorityDNs.add(X509Name.getInstance(ASN1Object.fromByteArray(dnBytes)));
                        }
                        this.tlsClient.processServerCertificateRequest(types, authorityDNs);
                        break;
                    }
                    default: {
                        this.failWithError((short)2, (short)10);
                    }
                }
                this.connection_state = (short)5;
                break;
            }
            case 0: {
                if (this.connection_state != 12) break;
                this.sendAlert((short)1, (short)100);
                break;
            }
            default: {
                this.failWithError((short)2, (short)10);
            }
        }
    }

    private void processApplicationData() {
    }

    private void processAlert() throws IOException {
        while (this.alertQueue.size() >= 2) {
            byte[] tmp = new byte[2];
            this.alertQueue.read(tmp, 0, 2, 0);
            this.alertQueue.removeData(2);
            short level = tmp[0];
            short description = tmp[1];
            if (level == 2) {
                this.failedWithError = true;
                this.closed = true;
                try {
                    this.rs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new IOException(TLS_ERROR_MESSAGE);
            }
            if (description != 0) continue;
            this.failWithError((short)1, (short)0);
        }
    }

    private void processChangeCipherSpec() throws IOException {
        while (this.changeCipherSpecQueue.size() > 0) {
            byte[] b = new byte[1];
            this.changeCipherSpecQueue.read(b, 0, 1, 0);
            this.changeCipherSpecQueue.removeData(1);
            if (b[0] != 1) {
                this.failWithError((short)2, (short)10);
            }
            if (this.connection_state != 10) {
                this.failWithError((short)2, (short)40);
            }
            this.rs.serverClientSpecReceived();
            this.connection_state = (short)11;
        }
    }

    private void sendClientCertificate(Certificate clientCert) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)11, bos);
        clientCert.encode(bos);
        byte[] message = bos.toByteArray();
        this.rs.writeMessage((short)22, message, 0, message.length);
    }

    private void sendClientKeyExchange(byte[] keData) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)16, bos);
        if (keData == null) {
            TlsUtils.writeUint24(0, bos);
        } else {
            TlsUtils.writeUint24(keData.length + 2, bos);
            TlsUtils.writeOpaque16(keData, bos);
        }
        byte[] message = bos.toByteArray();
        this.rs.writeMessage((short)22, message, 0, message.length);
    }

    private void sendCertificateVerify(byte[] data) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)15, bos);
        TlsUtils.writeUint24(data.length + 2, bos);
        TlsUtils.writeOpaque16(data, bos);
        byte[] message = bos.toByteArray();
        this.rs.writeMessage((short)22, message, 0, message.length);
    }

    public void connect(ByteArrayInputStream is, ByteArrayOutputStream out, CertificateVerifyer verifyer) throws IOException {
        this.connect(is, out, new DefaultTlsClient(verifyer));
    }

    public void connect(ByteArrayInputStream is, ByteArrayOutputStream out, TlsClient tlsClient) throws IOException {
        if (tlsClient == null) {
            throw new IllegalArgumentException("'tlsClient' cannot be null");
        }
        if (this.tlsClient != null) {
            throw new IllegalStateException("connect can only be called once");
        }
        this.rs.setInputStream(is);
        this.rs.setOutputStream(out);
        this.tlsClient = tlsClient;
        this.tlsClient.init(this);
        this.securityParameters = new SecurityParameters();
        this.securityParameters.clientRandom = new byte[32];
        this.random.nextBytes(this.securityParameters.clientRandom);
        TlsUtils.writeGMTUnixTime(this.securityParameters.clientRandom, 0);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TlsUtils.writeVersion(os);
        os.write(this.securityParameters.clientRandom);
        TlsUtils.writeUint8((short)0, os);
        this.offeredCipherSuites = this.tlsClient.getCipherSuites();
        TlsUtils.writeUint16(2 * this.offeredCipherSuites.length, os);
        for (int i = 0; i < this.offeredCipherSuites.length; ++i) {
            TlsUtils.writeUint16(this.offeredCipherSuites[i], os);
        }
        byte[] compressionMethods = new byte[]{0};
        TlsUtils.writeOpaque8(compressionMethods, os);
        Hashtable clientExtensions = this.tlsClient.generateClientExtensions();
        boolean bl = this.extendedClientHello = clientExtensions != null && !clientExtensions.isEmpty();
        if (this.extendedClientHello) {
            ByteArrayOutputStream ext = new ByteArrayOutputStream();
            Enumeration keys = clientExtensions.keys();
            while (keys.hasMoreElements()) {
                Integer extType = (Integer)keys.nextElement();
                byte[] extValue = (byte[])clientExtensions.get(extType);
                TlsUtils.writeUint16(extType, ext);
                TlsUtils.writeOpaque16(extValue, ext);
            }
            TlsUtils.writeOpaque16(ext.toByteArray(), os);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)1, bos);
        TlsUtils.writeUint24(os.size(), bos);
        bos.write(os.toByteArray());
        byte[] message = bos.toByteArray();
        this.rs.writeMessage((short)22, message, 0, message.length);
        this.connection_state = 1;
    }

    public void writeApplicationData(ByteArrayInputStream is, ByteArrayOutputStream os, byte[] b) throws IOException {
        this.rs.setInputStream(is);
        this.rs.setOutputStream(os);
        this.writeData(b, 0, b.length);
        this.tlsInputStream = new TlsInputStream(this);
        this.tlsOutputStream = new TlsOutputStream(this);
    }

    public byte[] readApplicationData(ByteArrayInputStream is, ByteArrayOutputStream os) throws IOException {
        this.rs.setInputStream(is);
        this.rs.setOutputStream(os);
        return this.readApplicationData();
    }

    protected byte[] readApplicationData() throws IOException {
        while (this.rs.hasMore()) {
            if (this.failedWithError) {
                throw new IOException(TLS_ERROR_MESSAGE);
            }
            if (this.closed) {
                return null;
            }
            try {
                this.rs.readData();
            }
            catch (IOException e) {
                if (!this.closed) {
                    this.failWithError((short)2, (short)80);
                }
                throw e;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                if (!this.closed) {
                    this.failWithError((short)2, (short)80);
                }
                throw e;
            }
        }
        int len = this.applicationDataQueue.size();
        byte[] b = new byte[len];
        this.applicationDataQueue.read(b, 0, len, 0);
        this.applicationDataQueue.removeData(len);
        return b;
    }

    public short updateConnectState(ByteArrayInputStream is, ByteArrayOutputStream os) throws IOException {
        this.rs.setInputStream(is);
        this.rs.setOutputStream(os);
        while (this.connection_state != 12 && this.rs.hasMore()) {
            this.rs.readData();
        }
        return this.connection_state;
    }

    protected int readApplicationData(byte[] buf, int offset, int len) throws IOException {
        while (this.applicationDataQueue.size() == 0) {
            if (this.closed) {
                if (this.failedWithError) {
                    throw new IOException(TLS_ERROR_MESSAGE);
                }
                return -1;
            }
            try {
                this.rs.readData();
            }
            catch (IOException e) {
                if (!this.closed) {
                    this.failWithError((short)2, (short)80);
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (!this.closed) {
                    this.failWithError((short)2, (short)80);
                }
                throw e;
            }
        }
        len = Math.min(len, this.applicationDataQueue.size());
        this.applicationDataQueue.read(buf, offset, len, 0);
        this.applicationDataQueue.removeData(len);
        return len;
    }

    protected void writeData(byte[] buf, int offset, int len) throws IOException {
        int toWrite;
        if (this.closed) {
            if (this.failedWithError) {
                throw new IOException(TLS_ERROR_MESSAGE);
            }
            throw new IOException("Sorry, connection has been closed, you cannot write more data");
        }
        this.rs.writeMessage((short)23, emptybuf, 0, 0);
        do {
            toWrite = Math.min(len, 16384);
            try {
                this.rs.writeMessage((short)23, buf, offset, toWrite);
            }
            catch (IOException e) {
                if (!this.closed) {
                    this.failWithError((short)2, (short)80);
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (!this.closed) {
                    this.failWithError((short)2, (short)80);
                }
                throw e;
            }
            offset += toWrite;
        } while ((len -= toWrite) > 0);
    }

    public OutputStream getOutputStream() {
        return this.tlsOutputStream;
    }

    public InputStream getInputStream() {
        return this.tlsInputStream;
    }

    protected void failWithError(short alertLevel, short alertDescription) throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (alertLevel == 2) {
                this.failedWithError = true;
            }
            this.sendAlert(alertLevel, alertDescription);
            this.rs.close();
            if (alertLevel == 2) {
                throw new IOException(TLS_ERROR_MESSAGE);
            }
        } else {
            throw new IOException(TLS_ERROR_MESSAGE);
        }
    }

    private void sendAlert(short alertLevel, short alertDescription) throws IOException {
        byte[] error = new byte[]{(byte)alertLevel, (byte)alertDescription};
        this.rs.writeMessage((short)21, error, 0, 2);
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.failWithError((short)1, (short)0);
        }
    }

    protected void assertEmpty(ByteArrayInputStream is) throws IOException {
        if (is.available() > 0) {
            this.failWithError((short)2, (short)50);
        }
    }

    protected void flush() throws IOException {
        this.rs.flush();
    }

    private boolean wasCipherSuiteOffered(int cipherSuite) {
        for (int i = 0; i < this.offeredCipherSuites.length; ++i) {
            if (this.offeredCipherSuites[i] != cipherSuite) continue;
            return true;
        }
        return false;
    }

    public void setKeyManagers(KeyManager[] keyManagers) {
        this.keyManagers = keyManagers;
    }

    public void setTrustManagers(TrustManager[] trustManagers) {
        this.trustManagers = trustManagers;
    }
}

