/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.radsec;

import java.io.File;
import java.io.FileInputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.jradius.util.KeyStoreUtil;
import org.springframework.beans.factory.InitializingBean;

public class SimpleTrustManager
implements X509TrustManager,
InitializingBean {
    private Boolean trustAll = Boolean.FALSE;
    private String certFile;
    private String certFileType;
    private String certFilePassword;
    private X509TrustManager trustManager;

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        for (X509Certificate c : chain) {
            System.err.println("Checking Client: " + c.getSubjectDN());
        }
        this.trustManager.checkClientTrusted(chain, authType);
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        for (X509Certificate c : chain) {
            System.err.println("Checking Server: " + c.getSubjectDN());
        }
        this.trustManager.checkServerTrusted(chain, authType);
    }

    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] chain;
        if (this.trustAll.booleanValue()) {
            return new X509Certificate[0];
        }
        for (X509Certificate c : chain = this.trustManager.getAcceptedIssuers()) {
            System.err.println("Accepted Issuer: " + c.getSubjectDN());
        }
        return chain;
    }

    public void afterPropertiesSet() throws Exception {
        TrustManager[] managers = KeyStoreUtil.loadTrustManager(this.certFileType, new FileInputStream(new File(this.certFile)), this.certFilePassword);
        if (managers != null && managers.length != 0) {
            this.trustManager = (X509TrustManager)managers[0];
        }
    }

    public void setCertFile(String keyFile) {
        this.certFile = keyFile;
    }

    public void setCertFileType(String keyFileType) {
        this.certFileType = keyFileType;
    }

    public void setCertFilePassword(String keyFilePassword) {
        this.certFilePassword = keyFilePassword;
    }

    public void setTrustAll(Boolean trustAll) {
        this.trustAll = trustAll;
    }
}

