/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.memoryusage.internal;

import java.io.File;
import java.io.PrintStream;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.felix.shell.Command;
import org.apache.felix.webconsole.plugins.memoryusage.internal.MemoryUsageSupport;

class MemoryUsageCommand
implements Command {
    private static final String HELP_CMD = "help";
    private static final String POOLS_CMD = "pools";
    private static final String DUMP_CMD = "dump";
    private static final String OPT_DUMP_ALL = "-a";
    private static final String LS_CMD = "ls";
    private static final String RM_CMD = "rm";
    private final MemoryUsageSupport support;

    MemoryUsageCommand(MemoryUsageSupport support) {
        this.support = support;
    }

    public void execute(String commandLine, PrintStream out, PrintStream err) {
        PrintWriterPrintHelper printHelper = new PrintWriterPrintHelper(out);
        StringTokenizer st = new StringTokenizer(commandLine);
        st.nextToken();
        String command = null;
        try {
            command = st.nextToken();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (command == null) {
            this.mem(printHelper);
        } else if (command.equals(HELP_CMD)) {
            this.help(out, st);
        } else if (command.equals(POOLS_CMD)) {
            this.pools(printHelper);
        } else if (command.equals(DUMP_CMD)) {
            this.dump(out, st, err);
        } else if (command.equals(LS_CMD)) {
            this.ls(printHelper);
        } else if (command.equals(RM_CMD)) {
            this.rm(out, err, st);
        } else {
            err.println("Unknown command: " + command);
        }
        printHelper.flush();
    }

    public String getName() {
        return "mem";
    }

    public String getShortDescription() {
        return "Prints Java VM Memory Consumption or writes a heap dump";
    }

    public String getUsage() {
        return "mem help";
    }

    private void mem(MemoryUsageSupport.PrintHelper printHelper) {
        this.support.printOverallMemory(printHelper);
    }

    private void pools(MemoryUsageSupport.PrintHelper printHelper) {
        this.support.printMemoryPools(printHelper);
    }

    private void help(PrintStream out, StringTokenizer word) {
        String command = HELP_CMD;
        if (word.hasMoreTokens()) {
            command = word.nextToken();
        }
        if (command.equals(DUMP_CMD)) {
            out.printf("%s %s [ %s ]%n", this.getName(), DUMP_CMD, OPT_DUMP_ALL);
            out.println("This command requests a heap dump to be created. If the\n-a option is not added, only live objects are dumped.");
        } else if (command.equals(LS_CMD)) {
            out.printf("%s %s%n", this.getName(), LS_CMD);
            out.println("This command lists all heap dumps created with the\ndump command.");
        } else if (command.equals(RM_CMD)) {
            out.printf("%s %s <dump>%n", this.getName(), RM_CMD);
            out.println("This command removes the indicated heap dump file.\nUse the ls to list heap dumps which may be removed.");
        } else if (command.equals(POOLS_CMD)) {
            out.printf("%s %s%n", this.getName(), POOLS_CMD);
            out.println("This command shows information about all memory pools.");
        } else {
            out.printf("%s %s [ %s | %s | %s | %s ]%n", this.getName(), HELP_CMD, DUMP_CMD, LS_CMD, RM_CMD, POOLS_CMD);
            out.printf("%s %s [ %s ]%n", this.getName(), DUMP_CMD, OPT_DUMP_ALL);
            out.printf("%s %s%n", this.getName(), LS_CMD);
            out.printf("%s %s <dump>%n", this.getName(), RM_CMD);
            out.printf("%s %s%n", this.getName(), POOLS_CMD);
            out.println("Using the " + this.getName() + " command without any arguments prints a memory use overview.");
        }
    }

    private void dump(PrintStream out, StringTokenizer words, PrintStream err) {
        String dumpTarget = null;
        boolean all = false;
        while (words.hasMoreTokens()) {
            String word = words.nextToken();
            if (OPT_DUMP_ALL.equals(word)) {
                all = true;
                continue;
            }
            dumpTarget = word;
        }
        try {
            File dumpFile = this.support.dumpHeap(dumpTarget, !all);
            out.println("Heap dumped to " + dumpFile + " (" + dumpFile.length() + " bytes)");
        }
        catch (NoSuchElementException e) {
            err.println("Failed dumping the heap, JVM does not provide known mechanism to create a Heap Dump");
        }
    }

    private void ls(MemoryUsageSupport.PrintHelper printHelper) {
        this.support.listDumpFiles(printHelper);
    }

    private void rm(PrintStream out, PrintStream err, StringTokenizer words) {
        if (words.hasMoreTokens()) {
            do {
                String name;
                if (this.support.rmDumpFile(name = words.nextToken())) {
                    out.println("rm: " + name + " removed");
                    out.flush();
                    continue;
                }
                err.println("rm: " + name + ": No such dump file");
                err.flush();
            } while (words.hasMoreTokens());
        }
    }

    private static class PrintWriterPrintHelper
    implements MemoryUsageSupport.PrintHelper {
        private static final String INDENTS = "          ";
        private final PrintStream pw;
        private String indent;

        PrintWriterPrintHelper(PrintStream pw) {
            this.pw = pw;
            this.indent = "";
        }

        public void title(String title, int level) {
            this.pw.printf("%s%s%n", PrintWriterPrintHelper.getIndent(level - 1), title);
            this.indent = PrintWriterPrintHelper.getIndent(level);
        }

        public void val(String value) {
            this.pw.printf("%s%s%n", this.indent, value);
        }

        public void keyVal(String key, Object value) {
            if (value == null) {
                this.val(key);
            } else {
                this.pw.printf("%s%s: %s%n", this.indent, key, value);
            }
        }

        void flush() {
            this.pw.flush();
        }

        private static String getIndent(int level) {
            if (level <= 0) {
                return "";
            }
            int indent = 2 * level;
            if (indent > INDENTS.length()) {
                return INDENTS;
            }
            return INDENTS.substring(0, indent);
        }
    }
}

