/*
 * Decompiled with CFR 0.152.
 */
package geo.google.datamodel;

import geo.google.datamodel.GeoCoordinate;

public class GeoUtils {
    private static final double KM_IN_ONE_MILE = 1.609344;
    private static final double MAGIC_NUMBER = 69.09;
    private static final double EARTH_RADIUS = 6371.0;

    private GeoUtils() {
    }

    public static double distanceBetweenInMiles(GeoCoordinate c1, GeoCoordinate c2) {
        return GeoUtils.distanceInMiles(c1.getLatitude(), c2.getLatitude(), c1.getLongitude(), c2.getLongitude());
    }

    public static double distanceBetweenInKm(GeoCoordinate c1, GeoCoordinate c2) {
        return GeoUtils.distanceInMiles(c1.getLatitude(), c2.getLatitude(), c1.getLongitude(), c2.getLongitude()) * 1.609344;
    }

    private static double distanceInMiles(double lat1, double lat2, double lon1, double lon2) {
        double theta = lon1 - lon2;
        double dist = Math.sin(Math.toRadians(lat1)) * Math.sin(Math.toRadians(lat2)) + Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2)) * Math.cos(Math.toRadians(theta));
        dist = Math.acos(dist);
        dist = Math.toDegrees(dist);
        return dist * 69.09;
    }

    public static double haversineDistanceBetweenInKm(GeoCoordinate c1, GeoCoordinate c2) {
        return GeoUtils.distanceHaversineForumla(c1.getLatitude(), c2.getLatitude(), c1.getLongitude(), c2.getLongitude());
    }

    public static double haversineDistanceBetweenInMiles(GeoCoordinate c1, GeoCoordinate c2) {
        return GeoUtils.distanceHaversineForumla(c1.getLatitude(), c2.getLatitude(), c1.getLongitude(), c2.getLongitude()) / 1.609344;
    }

    private static double distanceHaversineForumla(double lat1, double lat2, double lon1, double lon2) {
        double dLat = Math.toRadians(lat2 - lat1);
        double dLon = Math.toRadians(lon2 - lon1);
        double a = Math.pow(Math.sin(dLat / 2.0), 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin(dLon / 2.0), 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return 6371.0 * c;
    }
}

