/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.opennms;

import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.systemreport.AbstractSystemReportPlugin;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class LogReportPlugin
extends AbstractSystemReportPlugin {
    @Override
    public String getName() {
        return "Logs";
    }

    @Override
    public String getDescription() {
        return "OpenNMS log files (full output only)";
    }

    @Override
    public int getPriority() {
        return 21;
    }

    @Override
    public boolean getFullOutputOnly() {
        return true;
    }

    @Override
    public boolean getOutputsFiles() {
        return true;
    }

    @Override
    public Map<String, Resource> getEntries() {
        TreeMap<String, Resource> map = new TreeMap<String, Resource>();
        File f = new File(System.getProperty("opennms.home") + File.separator + "logs");
        this.processFile(f, map);
        return map;
    }

    public void processFile(File file, Map<String, Resource> map) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                this.processFile(f, map);
            }
        } else {
            String filename = file.getPath();
            if ((filename = filename.replaceFirst("^" + System.getProperty("opennms.home") + File.separator + "logs" + File.separator + "?", "")).endsWith(".log") && file.length() > 0L) {
                map.put(filename, (Resource)new FileSystemResource(file));
            }
        }
    }
}

