/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.formatters;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.opennms.systemreport.SystemReportFormatter;
import org.opennms.systemreport.SystemReportPlugin;
import org.opennms.systemreport.formatters.AbstractSystemReportFormatter;
import org.opennms.systemreport.formatters.TextSystemReportFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class ZipSystemReportFormatter
extends AbstractSystemReportFormatter
implements SystemReportFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(ZipSystemReportFormatter.class);
    private File m_tempFile;
    private ZipOutputStream m_zipOutputStream;
    private Set<String> m_directories = new HashSet<String>();

    public ZipSystemReportFormatter() {
        try {
            this.m_tempFile = File.createTempFile(this.getName(), null);
            this.m_tempFile.deleteOnExit();
        }
        catch (IOException e) {
            LOG.error("Unable to create temporary file!", (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return "zip";
    }

    @Override
    public String getDescription() {
        return "Compressed file of all resources (full output)";
    }

    @Override
    public String getContentType() {
        return "application/zip";
    }

    @Override
    public String getExtension() {
        return "zip";
    }

    @Override
    public boolean canStdout() {
        return false;
    }

    @Override
    public void begin() {
        super.begin();
        try {
            this.m_zipOutputStream = new ZipOutputStream(new FileOutputStream(this.m_tempFile));
            this.m_zipOutputStream.setLevel(9);
        }
        catch (Exception e) {
            LOG.error("Unable to create zip file '{}'", (Object)this.m_tempFile, (Object)e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(SystemReportPlugin plugin) {
        String name = plugin.getName() + ".txt";
        try {
            this.createDirectory("");
        }
        catch (Exception e) {
            LOG.error("Unable to create entry '{}'", (Object)name, (Object)e);
            return;
        }
        if (!plugin.getFullOutputOnly()) {
            try {
                this.createEntry(name);
            }
            catch (Exception e) {
                LOG.error("Unable to create entry '{}'", (Object)name, (Object)e);
                return;
            }
            TextSystemReportFormatter formatter = new TextSystemReportFormatter();
            formatter.setOutputStream(this.m_zipOutputStream);
            formatter.begin();
            ((AbstractSystemReportFormatter)formatter).write(plugin);
            formatter.end();
        }
        if (plugin.getOutputsFiles()) {
            byte[] buf = new byte[1024];
            for (Map.Entry<String, Resource> entry : plugin.getEntries().entrySet()) {
                Resource resource = entry.getValue();
                try {
                    this.createDirectory(plugin.getName());
                }
                catch (Exception e) {
                    LOG.error("Unable to create directory '{}'", (Object)plugin.getName(), (Object)e);
                    return;
                }
                String entryName = String.format("%s/%s", plugin.getName(), entry.getKey());
                try {
                    this.createEntry(entryName);
                }
                catch (Exception e) {
                    LOG.error("Unable to create entry '{}'", (Object)entryName, (Object)e);
                    return;
                }
                InputStream is = null;
                try {
                    int len;
                    is = resource.getInputStream();
                    while ((len = is.read(buf)) > 0) {
                        this.m_zipOutputStream.write(buf, 0, len);
                    }
                }
                catch (Throwable e) {
                    LOG.warn("Unable to read resource '{}'", (Object)resource, (Object)e);
                    return;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end() {
        try {
            this.m_zipOutputStream.closeEntry();
        }
        catch (IOException e) {
            LOG.warn("Unable to close last entry.", (Throwable)e);
        }
        IOUtils.closeQuietly((OutputStream)this.m_zipOutputStream);
        FileInputStream is = null;
        try {
            int len;
            byte[] buf = new byte[1024];
            is = new FileInputStream(this.m_tempFile);
            OutputStream os = this.getOutputStream();
            while ((len = ((InputStream)is).read(buf)) > 0) {
                os.write(buf, 0, len);
            }
        }
        catch (Exception e) {
            try {
                LOG.warn("Unable to read temporary zip file '{}'", (Object)this.m_tempFile, (Object)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    private void createEntry(String name) throws IOException {
        LOG.info("adding to zip: opennms-system-report/{}", (Object)name);
        this.m_zipOutputStream.putNextEntry(new ZipEntry("opennms-system-report/" + name));
    }

    private void createDirectory(String name) throws IOException {
        if (this.m_directories.contains(name)) {
            return;
        }
        this.createEntry(name + "/");
        this.m_directories.add(name);
    }
}

