/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.formatters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.opennms.systemreport.SystemReportFormatter;
import org.opennms.systemreport.SystemReportPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public abstract class AbstractSystemReportFormatter
implements SystemReportFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSystemReportFormatter.class);
    protected OutputStream m_outputStream = null;
    private String m_output;

    protected String getOutput() {
        return this.m_output;
    }

    @Override
    public void setOutput(String output) {
        this.m_output = output;
    }

    protected OutputStream getOutputStream() {
        return this.m_outputStream;
    }

    @Override
    public void setOutputStream(OutputStream stream) {
        this.m_outputStream = stream;
    }

    @Override
    public boolean needsOutputStream() {
        return true;
    }

    @Override
    public String getName() {
        LOG.warn("Plugin did not implement getFormatName()! Using the class name: {}", (Object)this.getClass().getName());
        return this.getClass().getName();
    }

    @Override
    public String getDescription() {
        LOG.warn("Plugin {} did not implement getDescription()! Using the format name.", (Object)this.getName());
        return this.getName();
    }

    @Override
    public void write(SystemReportPlugin plugin) {
        LOG.warn("Plugin {} did not implement write()! No data was written.", (Object)this.getName());
    }

    @Override
    public void begin() {
        if (this.needsOutputStream() && this.m_outputStream == null) {
            LOG.error("The output stream is not set and this formatter requires an output stream.");
        }
    }

    @Override
    public void end() {
    }

    @Override
    public final int compareTo(SystemReportFormatter o) {
        return new CompareToBuilder().append((Object)this.getName(), (Object)(o == null ? null : o.getName())).append((Object)this.getDescription(), (Object)(o == null ? null : o.getDescription())).toComparison();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getResourceText(Resource r) {
        BufferedReader br;
        InputStreamReader isr;
        InputStream is;
        block9: {
            String string;
            block8: {
                if (r instanceof ByteArrayResource) {
                    return new String(((ByteArrayResource)r).getByteArray());
                }
                is = null;
                isr = null;
                br = null;
                try {
                    is = r.getInputStream();
                    if (is != null) {
                        StringBuilder sb = new StringBuilder();
                        String line = null;
                        isr = new InputStreamReader(is, Charset.defaultCharset());
                        br = new BufferedReader(isr);
                        while ((line = br.readLine()) != null) {
                            sb.append(line).append("\n");
                        }
                        sb.deleteCharAt(sb.length());
                        string = sb.toString();
                        IOUtils.closeQuietly((Reader)br);
                        break block8;
                    }
                    IOUtils.closeQuietly(br);
                    break block9;
                }
                catch (IOException e) {
                    LOG.warn("Unable to get inputstream for resource '{}'", (Object)r, (Object)e);
                    String string2 = null;
                    return string2;
                }
            }
            IOUtils.closeQuietly((Reader)isr);
            IOUtils.closeQuietly((InputStream)is);
            return string;
        }
        IOUtils.closeQuietly(isr);
        IOUtils.closeQuietly((InputStream)is);
        return null;
        finally {
            IOUtils.closeQuietly(br);
            IOUtils.closeQuietly(isr);
            IOUtils.closeQuietly((InputStream)is);
        }
    }
}

