/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import com.google.common.collect.Table;
import java.net.InetAddress;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.common.TopologyUpdater;
import org.opennms.netmgt.enlinkd.model.NodeTopologyEntity;
import org.opennms.netmgt.enlinkd.model.OspfAreaTopologyEntity;
import org.opennms.netmgt.enlinkd.model.OspfElement;
import org.opennms.netmgt.enlinkd.service.api.NodeTopologyService;
import org.opennms.netmgt.enlinkd.service.api.OspfTopologyService;
import org.opennms.netmgt.enlinkd.service.api.ProtocolSupported;
import org.opennms.netmgt.enlinkd.service.api.Topology;
import org.opennms.netmgt.enlinkd.service.api.TopologyService;
import org.opennms.netmgt.topologies.service.api.OnmsTopology;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyDao;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyEdge;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyPort;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyProtocol;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyVertex;

public class OspfAreaOnmsTopologyUpdater
extends TopologyUpdater {
    private final OspfTopologyService m_ospfTopologyService;

    public static OspfAreaOnmsTopologyUpdater clone(OspfAreaOnmsTopologyUpdater bpu) {
        OspfAreaOnmsTopologyUpdater update = new OspfAreaOnmsTopologyUpdater(bpu.getTopologyDao(), bpu.getOspfTopologyService(), bpu.getNodeTopologyService());
        update.setRunned(bpu.isRunned());
        update.setTopology(bpu.getTopology());
        return update;
    }

    public static OnmsTopologyPort createNodePort(OnmsTopologyVertex source, OspfElement sourceElement, OspfAreaTopologyEntity targetArea) {
        if (Objects.isNull(sourceElement)) {
            throw new IllegalArgumentException("No OspfElement associated to area : " + targetArea.getOspfAreaId());
        }
        OnmsTopologyPort port = OnmsTopologyPort.create((String)targetArea.getNodeIdAsString(), (OnmsTopologyVertex)source, null);
        port.setAddr(InetAddressUtils.str((InetAddress)targetArea.getOspfAreaId()));
        port.setToolTipText("");
        return port;
    }

    public static OnmsTopologyPort createAreaPort(OnmsTopologyVertex source, OspfAreaTopologyEntity sourceArea, OspfElement targetElement) {
        OnmsTopologyPort port = OnmsTopologyPort.create((String)InetAddressUtils.str((InetAddress)sourceArea.getOspfAreaId()), (OnmsTopologyVertex)source, null);
        port.setAddr(InetAddressUtils.str((InetAddress)sourceArea.getOspfAreaId()));
        port.setToolTipText("");
        return port;
    }

    public static OnmsTopologyVertex createAreaVertex(OspfAreaTopologyEntity area) {
        Objects.requireNonNull(area);
        OnmsTopologyVertex ospfVertex = OnmsTopologyVertex.create((String)area.getOspfAreaId().getHostAddress(), (String)("Ospf Area: " + area.getOspfAreaId().getHostAddress()), (String)InetAddressUtils.str((InetAddress)area.getOspfAreaId()), (String)Topology.getCloudIconKey());
        ospfVertex.setToolTipText("TBD");
        return ospfVertex;
    }

    public static OnmsTopologyVertex createOspfNodeVertex(NodeTopologyEntity node, OspfElement ospfElement) {
        OnmsTopologyVertex ospfNodeVertex = OnmsTopologyVertex.create((String)node.getId().toString(), (String)node.getLabel(), (String)InetAddressUtils.str((InetAddress)ospfElement.getOspfRouterId()), (String)Topology.getIconKey((NodeTopologyEntity)node));
        ospfNodeVertex.setToolTipText(node.getLabel() + "/" + node.getId() + "ospf stat: " + ospfElement.getOspfAdminStat());
        return ospfNodeVertex;
    }

    public OspfAreaOnmsTopologyUpdater(OnmsTopologyDao topologyDao, OspfTopologyService ospfTopologyService, NodeTopologyService nodeTopologyService) {
        super((TopologyService)ospfTopologyService, topologyDao, nodeTopologyService);
        this.m_ospfTopologyService = ospfTopologyService;
    }

    public String getName() {
        return "OspfAreaTopologyUpdater";
    }

    public OnmsTopology buildTopology() {
        Map nodeMap = this.getNodeMap();
        Map ipMap = this.getIpPrimaryMap();
        Table nodeToOnmsSnmpTable = this.getSnmpInterfaceTable();
        OnmsTopology topology = new OnmsTopology();
        Map ospfElementMap = this.m_ospfTopologyService.findAllOspfElements().stream().collect(Collectors.toMap(e -> e.getNode().getId(), Function.identity()));
        for (OspfAreaTopologyEntity area : this.getOspfTopologyService().findAllOspfAreas()) {
            if (topology.getVertex(area.getNodeIdAsString()) == null) {
                topology.getVertices().add(OspfAreaOnmsTopologyUpdater.createOspfNodeVertex((NodeTopologyEntity)nodeMap.get(area.getNodeId()), (OspfElement)ospfElementMap.get(area.getNodeId())));
            }
            if (topology.getVertex(area.getOspfAreaId().getHostAddress()) == null) {
                topology.getVertices().add(OspfAreaOnmsTopologyUpdater.createAreaVertex(area));
            }
            OnmsTopologyVertex nodeVertex = topology.getVertex(area.getNodeIdAsString());
            OnmsTopologyVertex areaVertex = topology.getVertex(area.getOspfAreaId().getHostAddress());
            topology.getEdges().add(OnmsTopologyEdge.create((String)Topology.getDefaultEdgeId((String)nodeVertex.getId(), (String)areaVertex.getId()), (OnmsTopologyPort)OspfAreaOnmsTopologyUpdater.createNodePort(nodeVertex, (OspfElement)ospfElementMap.get(area.getNodeId()), area), (OnmsTopologyPort)OspfAreaOnmsTopologyUpdater.createAreaPort(areaVertex, area, (OspfElement)ospfElementMap.get(area.getNodeId()))));
        }
        return topology;
    }

    public OnmsTopologyProtocol getProtocol() {
        return OspfAreaOnmsTopologyUpdater.create((ProtocolSupported)ProtocolSupported.OSPFAREA);
    }

    public OspfTopologyService getOspfTopologyService() {
        return this.m_ospfTopologyService;
    }
}

