/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.core.XmlTemplate;
import org.jrobin.graph.RrdGraphConstants;
import org.jrobin.graph.RrdGraphDef;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class RrdGraphDefTemplate
extends XmlTemplate
implements RrdGraphConstants {
    static final Color BLIND_COLOR = new Color(0, 0, 0, 0);
    private RrdGraphDef rrdGraphDef;

    public RrdGraphDefTemplate(InputSource inputSource) throws IOException, RrdException {
        super(inputSource);
    }

    public RrdGraphDefTemplate(File xmlFile) throws IOException, RrdException {
        super(xmlFile);
    }

    public RrdGraphDefTemplate(String xmlString) throws IOException, RrdException {
        super(xmlString);
    }

    public RrdGraphDef getRrdGraphDef() throws RrdException {
        Node[] childNodes;
        if (!this.root.getTagName().equals("rrd_graph_def")) {
            throw new RrdException("XML definition must start with <rrd_graph_def>");
        }
        this.validateTagsOnlyOnce(this.root, new String[]{"filename", "span", "options", "datasources", "graph"});
        this.rrdGraphDef = new RrdGraphDef();
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(this.root)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("filename")) {
                this.resolveFilename(childNode);
                continue;
            }
            if (nodeName.equals("span")) {
                this.resolveSpan(childNode);
                continue;
            }
            if (nodeName.equals("options")) {
                this.resolveOptions(childNode);
                continue;
            }
            if (nodeName.equals("datasources")) {
                this.resolveDatasources(childNode);
                continue;
            }
            if (!nodeName.equals("graph")) continue;
            this.resolveGraphElements(childNode);
        }
        return this.rrdGraphDef;
    }

    private void resolveGraphElements(Node graphNode) throws RrdException {
        Node[] childNodes;
        this.validateTagsOnlyOnce(graphNode, new String[]{"area*", "line*", "stack*", "print*", "gprint*", "hrule*", "vrule*", "comment*"});
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(graphNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("area")) {
                this.resolveArea(childNode);
                continue;
            }
            if (nodeName.equals("line")) {
                this.resolveLine(childNode);
                continue;
            }
            if (nodeName.equals("stack")) {
                this.resolveStack(childNode);
                continue;
            }
            if (nodeName.equals("print")) {
                this.resolvePrint(childNode, false);
                continue;
            }
            if (nodeName.equals("gprint")) {
                this.resolvePrint(childNode, true);
                continue;
            }
            if (nodeName.equals("hrule")) {
                this.resolveHRule(childNode);
                continue;
            }
            if (nodeName.equals("vrule")) {
                this.resolveVRule(childNode);
                continue;
            }
            if (!nodeName.equals("comment")) continue;
            this.rrdGraphDef.comment(this.getValue(childNode));
        }
    }

    private void resolveVRule(Node parentNode) throws RrdException {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"time", "color", "legend"});
        long timestamp = Long.MIN_VALUE;
        Paint color = null;
        String legend = null;
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("time")) {
                timestamp = Util.getTimestamp(this.getValue(childNode));
                continue;
            }
            if (nodeName.equals("color")) {
                color = this.getValueAsColor(childNode);
                continue;
            }
            if (!nodeName.equals("legend")) continue;
            legend = this.getValue(childNode);
        }
        if (timestamp == Long.MIN_VALUE || color == null) {
            throw new RrdException("Incomplete VRULE settings");
        }
        this.rrdGraphDef.vrule(timestamp, color, legend);
    }

    private void resolveHRule(Node parentNode) throws RrdException {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"value", "color", "legend"});
        double value = Double.NaN;
        Paint color = null;
        String legend = null;
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("value")) {
                value = this.getValueAsDouble(childNode);
                continue;
            }
            if (nodeName.equals("color")) {
                color = this.getValueAsColor(childNode);
                continue;
            }
            if (!nodeName.equals("legend")) continue;
            legend = this.getValue(childNode);
        }
        if (Double.isNaN(value) || color == null) {
            throw new RrdException("Incomplete HRULE settings");
        }
        this.rrdGraphDef.hrule(value, color, legend);
    }

    private void resolvePrint(Node parentNode, boolean isInGraph) throws RrdException {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"datasource", "cf", "format"});
        String datasource = null;
        String cf = null;
        String format = null;
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("datasource")) {
                datasource = this.getValue(childNode);
                continue;
            }
            if (nodeName.equals("cf")) {
                cf = this.getValue(childNode);
                continue;
            }
            if (!nodeName.equals("format")) continue;
            format = this.getValue(childNode);
        }
        if (datasource != null && cf != null && format != null) {
            if (isInGraph) {
                this.rrdGraphDef.gprint(datasource, cf, format);
            } else {
                this.rrdGraphDef.print(datasource, cf, format);
            }
        } else {
            throw new RrdException("Incomplete " + (isInGraph ? "GRPINT" : "PRINT") + " settings");
        }
    }

    private void resolveStack(Node parentNode) throws RrdException {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"datasource", "color", "legend"});
        String datasource = null;
        String legend = null;
        Paint color = null;
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("datasource")) {
                datasource = this.getValue(childNode);
                continue;
            }
            if (nodeName.equals("color")) {
                color = this.getValueAsColor(childNode);
                continue;
            }
            if (!nodeName.equals("legend")) continue;
            legend = this.getValue(childNode);
        }
        if (datasource != null) {
            if (color != null) {
                this.rrdGraphDef.stack(datasource, color, legend);
            } else {
                this.rrdGraphDef.stack(datasource, BLIND_COLOR, legend);
            }
        } else {
            throw new RrdException("Incomplete STACK settings");
        }
    }

    private void resolveLine(Node parentNode) throws RrdException {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"datasource", "color", "legend", "width"});
        String datasource = null;
        String legend = null;
        Paint color = null;
        float width = 1.0f;
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("datasource")) {
                datasource = this.getValue(childNode);
                continue;
            }
            if (nodeName.equals("color")) {
                color = this.getValueAsColor(childNode);
                continue;
            }
            if (nodeName.equals("legend")) {
                legend = this.getValue(childNode);
                continue;
            }
            if (!nodeName.equals("width")) continue;
            width = (float)this.getValueAsDouble(childNode);
        }
        if (datasource != null) {
            if (color != null) {
                this.rrdGraphDef.line(datasource, color, legend, width);
            } else {
                this.rrdGraphDef.line(datasource, BLIND_COLOR, legend, width);
            }
        } else {
            throw new RrdException("Incomplete LINE settings");
        }
    }

    private void resolveArea(Node parentNode) throws RrdException {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"datasource", "color", "legend"});
        String datasource = null;
        String legend = null;
        Paint color = null;
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("datasource")) {
                datasource = this.getValue(childNode);
                continue;
            }
            if (nodeName.equals("color")) {
                color = this.getValueAsColor(childNode);
                continue;
            }
            if (!nodeName.equals("legend")) continue;
            legend = this.getValue(childNode);
        }
        if (datasource != null) {
            if (color != null) {
                this.rrdGraphDef.area(datasource, color, legend);
            } else {
                this.rrdGraphDef.area(datasource, BLIND_COLOR, legend);
            }
        } else {
            throw new RrdException("Incomplete AREA settings");
        }
    }

    private void resolveDatasources(Node datasourcesNode) throws RrdException {
        Node[] childNodes;
        this.validateTagsOnlyOnce(datasourcesNode, new String[]{"def*", "cdef*", "sdef*"});
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(datasourcesNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("def")) {
                this.resolveDef(childNode);
                continue;
            }
            if (nodeName.equals("cdef")) {
                this.resolveCDef(childNode);
                continue;
            }
            if (!nodeName.equals("sdef")) continue;
            this.resolveSDef(childNode);
        }
    }

    private void resolveSDef(Node parentNode) throws RrdException {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"name", "source", "cf"});
        String name = null;
        String source = null;
        String cf = null;
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("name")) {
                name = this.getValue(childNode);
                continue;
            }
            if (nodeName.equals("source")) {
                source = this.getValue(childNode);
                continue;
            }
            if (!nodeName.equals("cf")) continue;
            cf = this.getValue(childNode);
        }
        if (name == null || source == null || cf == null) {
            throw new RrdException("Incomplete SDEF settings");
        }
        this.rrdGraphDef.datasource(name, source, cf);
    }

    private void resolveCDef(Node parentNode) throws RrdException {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"name", "rpn"});
        String name = null;
        String rpn = null;
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("name")) {
                name = this.getValue(childNode);
                continue;
            }
            if (!nodeName.equals("rpn")) continue;
            rpn = this.getValue(childNode);
        }
        if (name == null || rpn == null) {
            throw new RrdException("Incomplete CDEF settings");
        }
        this.rrdGraphDef.datasource(name, rpn);
    }

    private void resolveDef(Node parentNode) throws RrdException {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"name", "rrd", "source", "cf", "backend"});
        String name = null;
        String rrd = null;
        String source = null;
        String cf = null;
        String backend = null;
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("name")) {
                name = this.getValue(childNode);
                continue;
            }
            if (nodeName.equals("rrd")) {
                rrd = this.getValue(childNode);
                continue;
            }
            if (nodeName.equals("source")) {
                source = this.getValue(childNode);
                continue;
            }
            if (nodeName.equals("cf")) {
                cf = this.getValue(childNode);
                continue;
            }
            if (!nodeName.equals("backend")) continue;
            backend = this.getValue(childNode);
        }
        if (name == null || rrd == null || source == null || cf == null) {
            throw new RrdException("Incomplete DEF settings");
        }
        this.rrdGraphDef.datasource(name, rrd, source, cf, backend);
    }

    private void resolveFilename(Node filenameNode) {
        String filename = this.getValue(filenameNode);
        this.rrdGraphDef.setFilename(filename);
    }

    private void resolveSpan(Node spanNode) throws RrdException {
        this.validateTagsOnlyOnce(spanNode, new String[]{"start", "end"});
        String startStr = this.getChildValue(spanNode, "start");
        String endStr = this.getChildValue(spanNode, "end");
        long[] span = Util.getTimestamps(startStr, endStr);
        this.rrdGraphDef.setStartTime(span[0]);
        this.rrdGraphDef.setEndTime(span[1]);
    }

    private void resolveOptions(Node rootOptionNode) throws RrdException {
        Node[] optionNodes;
        this.validateTagsOnlyOnce(rootOptionNode, new String[]{"anti_aliasing", "use_pool", "time_grid", "value_grid", "alt_y_grid", "alt_y_mrtg", "no_minor_grid", "alt_autoscale", "alt_autoscale_max", "units_exponent", "units_length", "vertical_label", "width", "height", "interlaced", "image_info", "image_format", "image_quality", "background_image", "overlay_image", "unit", "lazy", "min_value", "max_value", "rigid", "base", "logarithmic", "colors", "no_legend", "only_graph", "force_rules_legend", "title", "step", "fonts", "first_day_of_week", "signature"});
        for (Node optionNode : optionNodes = RrdGraphDefTemplate.getChildNodes(rootOptionNode)) {
            String option = optionNode.getNodeName();
            if (option.equals("use_pool")) {
                this.rrdGraphDef.setPoolUsed(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("anti_aliasing")) {
                this.rrdGraphDef.setAntiAliasing(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("time_grid")) {
                this.resolveTimeGrid(optionNode);
                continue;
            }
            if (option.equals("value_grid")) {
                this.resolveValueGrid(optionNode);
                continue;
            }
            if (option.equals("no_minor_grid")) {
                this.rrdGraphDef.setNoMinorGrid(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("alt_y_grid")) {
                this.rrdGraphDef.setAltYGrid(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("alt_y_mrtg")) {
                this.rrdGraphDef.setAltYMrtg(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("alt_autoscale")) {
                this.rrdGraphDef.setAltAutoscale(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("alt_autoscale_max")) {
                this.rrdGraphDef.setAltAutoscaleMax(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("units_exponent")) {
                this.rrdGraphDef.setUnitsExponent(this.getValueAsInt(optionNode));
                continue;
            }
            if (option.equals("units_length")) {
                this.rrdGraphDef.setUnitsLength(this.getValueAsInt(optionNode));
                continue;
            }
            if (option.equals("vertical_label")) {
                this.rrdGraphDef.setVerticalLabel(this.getValue(optionNode));
                continue;
            }
            if (option.equals("width")) {
                this.rrdGraphDef.setWidth(this.getValueAsInt(optionNode));
                continue;
            }
            if (option.equals("height")) {
                this.rrdGraphDef.setHeight(this.getValueAsInt(optionNode));
                continue;
            }
            if (option.equals("interlaced")) {
                this.rrdGraphDef.setInterlaced(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("image_info")) {
                this.rrdGraphDef.setImageInfo(this.getValue(optionNode));
                continue;
            }
            if (option.equals("image_format")) {
                this.rrdGraphDef.setImageFormat(this.getValue(optionNode));
                continue;
            }
            if (option.equals("image_quality")) {
                this.rrdGraphDef.setImageQuality((float)this.getValueAsDouble(optionNode));
                continue;
            }
            if (option.equals("background_image")) {
                this.rrdGraphDef.setBackgroundImage(this.getValue(optionNode));
                continue;
            }
            if (option.equals("overlay_image")) {
                this.rrdGraphDef.setOverlayImage(this.getValue(optionNode));
                continue;
            }
            if (option.equals("unit")) {
                this.rrdGraphDef.setUnit(this.getValue(optionNode));
                continue;
            }
            if (option.equals("lazy")) {
                this.rrdGraphDef.setLazy(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("min_value")) {
                this.rrdGraphDef.setMinValue(this.getValueAsDouble(optionNode));
                continue;
            }
            if (option.equals("max_value")) {
                this.rrdGraphDef.setMaxValue(this.getValueAsDouble(optionNode));
                continue;
            }
            if (option.equals("rigid")) {
                this.rrdGraphDef.setRigid(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("base")) {
                this.rrdGraphDef.setBase(this.getValueAsDouble(optionNode));
                continue;
            }
            if (option.equals("logarithmic")) {
                this.rrdGraphDef.setLogarithmic(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("colors")) {
                this.resolveColors(optionNode);
                continue;
            }
            if (option.equals("no_legend")) {
                this.rrdGraphDef.setNoLegend(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("only_graph")) {
                this.rrdGraphDef.setOnlyGraph(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("force_rules_legend")) {
                this.rrdGraphDef.setForceRulesLegend(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("title")) {
                this.rrdGraphDef.setTitle(this.getValue(optionNode));
                continue;
            }
            if (option.equals("step")) {
                this.rrdGraphDef.setStep(this.getValueAsLong(optionNode));
                continue;
            }
            if (option.equals("fonts")) {
                this.resolveFonts(optionNode);
                continue;
            }
            if (option.equals("first_day_of_week")) {
                int dayIndex = this.resolveFirstDayOfWeek(this.getValue(optionNode));
                this.rrdGraphDef.setFirstDayOfWeek(dayIndex);
                continue;
            }
            if (!option.equals("signature")) continue;
            this.rrdGraphDef.setShowSignature(this.getValueAsBoolean(optionNode));
        }
    }

    private int resolveFirstDayOfWeek(String firstDayOfWeek) throws RrdException {
        if (firstDayOfWeek.equalsIgnoreCase("sunday")) {
            return 1;
        }
        if (firstDayOfWeek.equalsIgnoreCase("monday")) {
            return 2;
        }
        if (firstDayOfWeek.equalsIgnoreCase("tuesday")) {
            return 3;
        }
        if (firstDayOfWeek.equalsIgnoreCase("wednesday")) {
            return 4;
        }
        if (firstDayOfWeek.equalsIgnoreCase("thursday")) {
            return 5;
        }
        if (firstDayOfWeek.equalsIgnoreCase("friday")) {
            return 6;
        }
        if (firstDayOfWeek.equalsIgnoreCase("saturday")) {
            return 7;
        }
        throw new RrdException("Never heard for this day of week: " + firstDayOfWeek);
    }

    private void resolveFonts(Node parentNode) throws RrdException {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"small_font", "large_font"});
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("small_font")) {
                this.rrdGraphDef.setSmallFont(this.resolveFont(childNode));
                continue;
            }
            if (!nodeName.equals("large_font")) continue;
            this.rrdGraphDef.setLargeFont(this.resolveFont(childNode));
        }
    }

    private Font resolveFont(Node parentNode) throws RrdException {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"name", "style", "size"});
        String name = null;
        String style = null;
        int size = 0;
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("name")) {
                name = this.getValue(childNode);
                continue;
            }
            if (nodeName.equals("style")) {
                style = this.getValue(childNode).toLowerCase();
                continue;
            }
            if (!nodeName.equals("size")) continue;
            size = this.getValueAsInt(childNode);
        }
        if (name != null && style != null && size > 0) {
            boolean isItalic = style.contains("italic");
            boolean isBold = style.contains("bold");
            int fstyle = 0;
            if (isItalic && isBold) {
                fstyle = 3;
            } else if (isItalic) {
                fstyle = 2;
            } else if (isBold) {
                fstyle = 1;
            }
            return new Font(name, fstyle, size);
        }
        throw new RrdException("Incomplete font specification");
    }

    private void resolveColors(Node parentNode) throws RrdException {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, COLOR_NAMES);
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String colorName = childNode.getNodeName();
            this.rrdGraphDef.setColor(colorName, this.getValueAsColor(childNode));
        }
    }

    private void resolveValueGrid(Node parentNode) throws RrdException {
        Node[] childNodes;
        int NOT_SET;
        this.validateTagsOnlyOnce(parentNode, new String[]{"show_grid", "grid_step", "label_factor"});
        boolean showGrid = true;
        double gridStep = Double.NaN;
        int labelFactor = NOT_SET = Integer.MIN_VALUE;
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("show_grid")) {
                showGrid = this.getValueAsBoolean(childNode);
                continue;
            }
            if (nodeName.equals("grid_step")) {
                gridStep = this.getValueAsDouble(childNode);
                continue;
            }
            if (!nodeName.equals("label_factor")) continue;
            labelFactor = this.getValueAsInt(childNode);
        }
        this.rrdGraphDef.setDrawYGrid(showGrid);
        if (!Double.isNaN(gridStep) && labelFactor != NOT_SET) {
            this.rrdGraphDef.setValueAxis(gridStep, labelFactor);
        } else if (!Double.isNaN(gridStep) || labelFactor != NOT_SET) {
            throw new RrdException("Incomplete value axis settings");
        }
    }

    private void resolveTimeGrid(Node parentNode) throws RrdException {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"show_grid", "minor_grid_unit", "minor_grid_unit_count", "major_grid_unit", "major_grid_unit_count", "label_unit", "label_unit_count", "label_span", "label_format"});
        boolean showGrid = true;
        int NOT_SET = Integer.MIN_VALUE;
        int minorGridUnit = Integer.MIN_VALUE;
        int minorGridUnitCount = Integer.MIN_VALUE;
        int majorGridUnit = Integer.MIN_VALUE;
        int majorGridUnitCount = Integer.MIN_VALUE;
        int labelUnit = Integer.MIN_VALUE;
        int labelUnitCount = Integer.MIN_VALUE;
        int labelSpan = Integer.MIN_VALUE;
        String labelFormat = null;
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("show_grid")) {
                showGrid = this.getValueAsBoolean(childNode);
                continue;
            }
            if (nodeName.equals("minor_grid_unit")) {
                minorGridUnit = this.resolveTimeUnit(this.getValue(childNode));
                continue;
            }
            if (nodeName.equals("minor_grid_unit_count")) {
                minorGridUnitCount = this.getValueAsInt(childNode);
                continue;
            }
            if (nodeName.equals("major_grid_unit")) {
                majorGridUnit = this.resolveTimeUnit(this.getValue(childNode));
                continue;
            }
            if (nodeName.equals("major_grid_unit_count")) {
                majorGridUnitCount = this.getValueAsInt(childNode);
                continue;
            }
            if (nodeName.equals("label_unit")) {
                labelUnit = this.resolveTimeUnit(this.getValue(childNode));
                continue;
            }
            if (nodeName.equals("label_unit_count")) {
                labelUnitCount = this.getValueAsInt(childNode);
                continue;
            }
            if (nodeName.equals("label_span")) {
                labelSpan = this.getValueAsInt(childNode);
                continue;
            }
            if (!nodeName.equals("label_format")) continue;
            labelFormat = this.getValue(childNode);
        }
        this.rrdGraphDef.setDrawXGrid(showGrid);
        if (minorGridUnit != Integer.MIN_VALUE && minorGridUnitCount != Integer.MIN_VALUE && majorGridUnit != Integer.MIN_VALUE && majorGridUnitCount != Integer.MIN_VALUE && labelUnit != Integer.MIN_VALUE && labelUnitCount != Integer.MIN_VALUE && labelSpan != Integer.MIN_VALUE && labelFormat != null) {
            this.rrdGraphDef.setTimeAxis(minorGridUnit, minorGridUnitCount, majorGridUnit, majorGridUnitCount, labelUnit, labelUnitCount, labelSpan, labelFormat);
        } else if (minorGridUnit != Integer.MIN_VALUE || minorGridUnitCount != Integer.MIN_VALUE || majorGridUnit != Integer.MIN_VALUE || majorGridUnitCount != Integer.MIN_VALUE || labelUnit != Integer.MIN_VALUE || labelUnitCount != Integer.MIN_VALUE || labelSpan != Integer.MIN_VALUE || labelFormat != null) {
            throw new RrdException("Incomplete time axis settings");
        }
    }

    private int resolveTimeUnit(String unit) throws RrdException {
        if (unit.equalsIgnoreCase("second")) {
            return 13;
        }
        if (unit.equalsIgnoreCase("minute")) {
            return 12;
        }
        if (unit.equalsIgnoreCase("hour")) {
            return 11;
        }
        if (unit.equalsIgnoreCase("day")) {
            return 5;
        }
        if (unit.equalsIgnoreCase("week")) {
            return 3;
        }
        if (unit.equalsIgnoreCase("month")) {
            return 2;
        }
        if (unit.equalsIgnoreCase("year")) {
            return 1;
        }
        throw new RrdException("Unknown time unit specified: " + unit);
    }
}

