/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.web.api.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;

public class OpenNMSlLogoutSuccessHandler
extends SimpleUrlLogoutSuccessHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenNMSlLogoutSuccessHandler.class);

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        String targetUrl = this.determineTargetUrl(request, response);
        targetUrl = Util.calculateUrlBase((HttpServletRequest)request, (String)targetUrl);
        if (response.isCommitted()) {
            LOGGER.debug("Response has already been committed. Unable to redirect to " + targetUrl);
        } else {
            this.getRedirectStrategy().sendRedirect(request, response, targetUrl);
        }
    }
}

