/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.web.api.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.util.StringUtils;

public class OpenNMSAuthSuccessHandler
extends SimpleUrlAuthenticationSuccessHandler {
    public static final String PASSWORD_GATE_USERNAME = "admin";
    public static final String PASSWORD_GATE_PASSWORD = "admin";
    protected final Logger logger = LoggerFactory.getLogger(OpenNMSAuthSuccessHandler.class);
    private final RequestCache requestCache = new HttpSessionRequestCache();

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws ServletException, IOException {
        request.changeSessionId();
        boolean defaultAdminLogin = this.isDefaultAdminLogin(request.getParameter("j_username"), request.getParameter("j_password"));
        if (defaultAdminLogin) {
            this.handleDefaultAdminLogin(request, response);
        } else {
            DefaultSavedRequest savedRequest = (DefaultSavedRequest)this.requestCache.getRequest(request, response);
            if (savedRequest == null) {
                super.clearAuthenticationAttributes(request);
                this.getRedirectStrategy().sendRedirect(request, response, this.createTargetURL(request, response));
            } else {
                String targetUrlParameter = this.getTargetUrlParameter();
                if (!(this.isAlwaysUseDefaultTargetUrl() || targetUrlParameter != null && StringUtils.hasText((String)request.getParameter(targetUrlParameter)))) {
                    this.clearAuthenticationAttributes(request);
                    String targetUrl = Util.calculateUrlBase((HttpServletRequest)request, (String)(savedRequest.getServletPath() + (String)(savedRequest.getQueryString() == null ? "" : "?" + savedRequest.getQueryString())));
                    this.logger.debug("Redirecting to DefaultSavedRequest Url: " + targetUrl);
                    this.getRedirectStrategy().sendRedirect(request, response, targetUrl);
                } else {
                    this.requestCache.removeRequest(request, response);
                    this.getRedirectStrategy().sendRedirect(request, response, this.createTargetURL(request, response));
                }
            }
        }
    }

    private void handleDefaultAdminLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String targetUrl = Util.calculateUrlBase((HttpServletRequest)request, (String)"/account/selfService/passwordGate.jsp");
        this.logger.debug("User used default admin password. Redirecting to Password Gate, url: " + targetUrl);
        super.clearAuthenticationAttributes(request);
        this.getRedirectStrategy().sendRedirect(request, response, targetUrl);
    }

    private String createTargetURL(HttpServletRequest request, HttpServletResponse response) {
        return Util.calculateUrlBase((HttpServletRequest)request, (String)this.determineTargetUrl(request, response));
    }

    private boolean isDefaultAdminLogin(String username, String password) {
        return username != null && username.equals("admin") && password != null && password.equals("admin");
    }
}

