/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.notifd.AutoAcknowledge;
import org.opennms.netmgt.config.notifd.NotifdConfiguration;
import org.opennms.netmgt.config.notifications.Notification;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NotifdConfigManager {
    private static final Logger LOG = LoggerFactory.getLogger(NotifdConfigManager.class);
    protected NotifdConfiguration configuration;

    public synchronized void parseXml(InputStream stream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(stream);){
            this.configuration = (NotifdConfiguration)JaxbUtils.unmarshal(NotifdConfiguration.class, (Reader)reader);
        }
    }

    public NotifdConfiguration getConfiguration() throws IOException {
        this.update();
        return this.configuration;
    }

    protected abstract void update() throws IOException;

    public String getNotificationStatus() throws IOException {
        this.update();
        return this.configuration.getStatus();
    }

    public final void turnNotifdOn() throws IOException {
        this.configuration.setStatus("on");
        this.saveCurrent();
    }

    public final void turnNotifdOff() throws IOException {
        this.configuration.setStatus("off");
        this.saveCurrent();
    }

    public boolean getNotificationMatch() throws IOException {
        this.update();
        return this.configuration.getMatchAll();
    }

    public synchronized void saveCurrent() throws IOException {
        String xml = JaxbUtils.marshal((Object)this.configuration);
        this.saveXml(xml);
        this.update();
    }

    protected abstract void saveXml(String var1) throws IOException;

    public String getNextNotifIdSql() throws IOException {
        return this.getConfiguration().getNextNotifId();
    }

    public boolean matchNotificationParameters(Event event, Notification notification) {
        boolean parmmatch = false;
        if (notification.getVarbind() != null && notification.getVarbind().getVbname() != null) {
            String notfValue = notification.getVarbind().getVbvalue();
            if (notfValue == null) {
                LOG.debug("BroadcastEventProcessor:matchNotificationParameters:  Null value for varbind, assuming true.");
                return true;
            }
            String notfName = notification.getVarbind().getVbname();
            for (Parm parm : event.getParmCollection()) {
                if (!parmmatch) {
                    Value parmValue;
                    String parmName = parm.getParmName();
                    if (!parmName.equals(notfName) || (parmValue = parm.getValue()) == null) continue;
                    String parmContent = parmValue.getContent();
                    if (notfValue.charAt(0) == '~') {
                        if (!parmContent.matches(notfValue.substring(1))) continue;
                        parmmatch = true;
                        continue;
                    }
                    if (!parmContent.startsWith(notfValue)) continue;
                    parmmatch = true;
                    continue;
                }
                break;
            }
        } else if (notification.getVarbind() == null || notification.getVarbind().getVbname() == null) {
            parmmatch = true;
        }
        return parmmatch;
    }

    public String getNextUserNotifIdSql() throws IOException {
        return this.getConfiguration().getNextUserNotifId();
    }

    public Collection<AutoAcknowledge> getAutoAcknowledges() throws IOException {
        return this.getConfiguration().getAutoAcknowledges();
    }

    public Collection<String> getOutageCalendarNames() throws IOException {
        return this.getConfiguration().getOutageCalendars();
    }
}

