/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema.docpath;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public final class SaxWalkerOverDom {
    private List<ContentHandler> listeners = null;

    public SaxWalkerOverDom() {
    }

    public SaxWalkerOverDom(ContentHandler contentHandler) {
        this();
        this.listeners = new ArrayList<ContentHandler>(1);
        this.listeners.add(contentHandler);
    }

    public SaxWalkerOverDom(List<ContentHandler> contentHandlers) {
        this();
        this.listeners = contentHandlers;
    }

    public void addContentHandler(ContentHandler contentHandler) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ContentHandler>(1);
        }
        this.listeners.add(contentHandler);
    }

    public boolean removeContentHandler(ContentHandler contentHandler) {
        if (this.listeners != null) {
            return this.listeners.remove(contentHandler);
        }
        return false;
    }

    public void walk(Document document) throws SAXException {
        if (document == null) {
            throw new IllegalArgumentException("Document cannot be null.");
        }
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        for (ContentHandler listener : this.listeners) {
            listener.startDocument();
        }
        List<String> prefixes = this.startPrefixMappings(document);
        this.walk(document.getDocumentElement());
        for (ContentHandler listener : this.listeners) {
            for (String prefix : prefixes) {
                listener.endPrefixMapping(prefix);
            }
            listener.endDocument();
        }
    }

    private void walk(Element element) throws SAXException {
        DomAttrsAsSax attrs = new DomAttrsAsSax(element.getAttributes());
        List<String> prefixes = this.startPrefixMappings(element);
        for (ContentHandler listener : this.listeners) {
            listener.startElement(SaxWalkerOverDom.convertNullToEmptyString(element.getNamespaceURI()), SaxWalkerOverDom.convertNullToEmptyString(element.getLocalName()), SaxWalkerOverDom.convertNullToEmptyString(element.getNodeName()), attrs);
        }
        NodeList children = element.getChildNodes();
        for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
            Node node = children.item(childIndex);
            if (node instanceof Element) {
                this.walk((Element)node);
                continue;
            }
            if (node instanceof Text) {
                this.walk((Text)node);
                continue;
            }
            if (node instanceof Comment) continue;
            throw new SAXException("Unrecognized child of " + element.getTagName() + " of type " + node.getClass().getName());
        }
        for (ContentHandler listener : this.listeners) {
            listener.endElement(SaxWalkerOverDom.convertNullToEmptyString(element.getNamespaceURI()), SaxWalkerOverDom.convertNullToEmptyString(element.getLocalName()), SaxWalkerOverDom.convertNullToEmptyString(element.getNodeName()));
            for (String prefix : prefixes) {
                listener.endPrefixMapping(prefix);
            }
        }
    }

    private void walk(Text text) throws SAXException {
        if (text.getLength() > 0) {
            char[] data = text.getData().toCharArray();
            for (ContentHandler listener : this.listeners) {
                listener.characters(data, 0, data.length);
            }
        }
    }

    private static String convertNullToEmptyString(String input) {
        if (input == null) {
            return "";
        }
        return input;
    }

    private List<String> startPrefixMappings(Node node) throws DOMException, SAXException {
        switch (node.getNodeType()) {
            case 1: 
            case 9: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot start prefix mappings for a node of type " + node.getNodeType());
            }
        }
        ArrayList<String> prefixes = new ArrayList<String>();
        NamedNodeMap attrs = node.getAttributes();
        if (attrs == null) {
            return prefixes;
        }
        for (int attrIndex = 0; attrIndex < attrs.getLength(); ++attrIndex) {
            Node attr = attrs.item(attrIndex);
            String attrUri = attr.getNamespaceURI();
            if (!"http://www.w3.org/2000/xmlns/".equals(attrUri)) continue;
            String localName = attr.getLocalName();
            String prefix = null;
            prefix = "xmlns".equals(localName) ? "" : localName;
            prefixes.add(prefix);
            for (ContentHandler listener : this.listeners) {
                listener.startPrefixMapping(prefix, attr.getNodeValue());
            }
        }
        return prefixes;
    }

    private static class DomAttrsAsSax
    implements Attributes {
        private final List<Attr> attributes = new ArrayList<Attr>();
        private final Map<String, Attr> attrsByQualifiedName = new HashMap<String, Attr>();
        private final Map<QName, Attr> attrsByQName = new HashMap<QName, Attr>();
        private final Map<String, Integer> indexByQualifiedName = new HashMap<String, Integer>();
        private final Map<QName, Integer> indexByQName = new HashMap<QName, Integer>();

        DomAttrsAsSax(NamedNodeMap domAttrs) throws SAXException {
            if (domAttrs != null) {
                for (int attrIdx = 0; attrIdx < domAttrs.getLength(); ++attrIdx) {
                    Node domAttr = domAttrs.item(attrIdx);
                    if ("http://www.w3.org/2000/xmlns/".equals(domAttr.getNamespaceURI())) continue;
                    Attr attribute = new Attr(domAttr);
                    this.attributes.add(attribute);
                    this.attrsByQualifiedName.put(attribute.qualifiedName, attribute);
                    this.attrsByQName.put(attribute.qName, attribute);
                    this.indexByQualifiedName.put(attribute.qualifiedName, attrIdx);
                    this.indexByQName.put(attribute.qName, attrIdx);
                }
            }
        }

        @Override
        public int getLength() {
            return this.attributes.size();
        }

        @Override
        public String getURI(int index) {
            if (this.attributes.size() <= index) {
                return null;
            }
            return this.attributes.get((int)index).qName.getNamespaceURI();
        }

        @Override
        public String getLocalName(int index) {
            if (this.attributes.size() <= index) {
                return null;
            }
            return this.attributes.get((int)index).qName.getLocalPart();
        }

        @Override
        public String getQName(int index) {
            if (this.attributes.size() <= index) {
                return null;
            }
            return this.attributes.get((int)index).qualifiedName;
        }

        @Override
        public String getType(int index) {
            if (this.attributes.size() <= index) {
                return null;
            }
            return "CDATA";
        }

        @Override
        public String getValue(int index) {
            if (this.attributes.size() <= index) {
                return null;
            }
            return this.attributes.get((int)index).value;
        }

        @Override
        public int getIndex(String uri, String localName) {
            if (uri == null || localName == null) {
                return -1;
            }
            QName qName = new QName(uri, localName);
            Integer index = this.indexByQName.get(qName);
            if (index == null) {
                return -1;
            }
            return index;
        }

        @Override
        public int getIndex(String qName) {
            if (qName == null) {
                return -1;
            }
            Integer index = this.indexByQualifiedName.get(qName);
            if (index == null) {
                return -1;
            }
            return index;
        }

        @Override
        public String getType(String uri, String localName) {
            if (uri == null || localName == null) {
                return null;
            }
            Attr attr = this.attrsByQName.get(new QName(uri, localName));
            return attr == null ? null : "CDATA";
        }

        @Override
        public String getType(String qName) {
            if (qName == null) {
                return null;
            }
            Attr attr = this.attrsByQualifiedName.get(qName);
            return attr == null ? null : "CDATA";
        }

        @Override
        public String getValue(String uri, String localName) {
            if (uri == null || localName == null) {
                return null;
            }
            Attr attr = this.attrsByQName.get(new QName(uri, localName));
            return attr == null ? null : attr.value;
        }

        @Override
        public String getValue(String qName) {
            if (qName == null) {
                return null;
            }
            Attr attr = this.attrsByQualifiedName.get(qName);
            return attr == null ? null : attr.value;
        }
    }

    private static class Attr {
        final QName qName;
        final String qualifiedName;
        final String value;

        Attr(String namespace, String localName, String qualName, String val) {
            this.qName = new QName(namespace, localName);
            this.qualifiedName = qualName;
            this.value = val;
        }

        Attr(Node node) {
            this(node.getNamespaceURI(), node.getLocalName(), node.getNodeName(), node.getNodeValue());
        }
    }
}

