/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jcifs.CIFSContext;
import jcifs.DfsReferralData;
import jcifs.DfsResolver;
import jcifs.SmbTransport;
import jcifs.internal.dfs.DfsReferralDataImpl;
import jcifs.internal.dfs.DfsReferralDataInternal;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbTransportImpl;
import jcifs.smb.SmbTransportInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DfsImpl
implements DfsResolver {
    private static final DfsReferralDataImpl NEGATIVE_ENTRY = new DfsReferralDataImpl();
    private static final Logger log = LoggerFactory.getLogger(DfsImpl.class);
    private static final String DC_ENTRY = "dc";
    private CacheEntry<Map<String, CacheEntry<DfsReferralDataInternal>>> _domains = null;
    private final Object domainsLock = new Object();
    private final Map<String, CacheEntry<DfsReferralDataInternal>> dcCache = new HashMap<String, CacheEntry<DfsReferralDataInternal>>();
    private final Object dcLock = new Object();
    private CacheEntry<DfsReferralDataInternal> referrals = null;
    private final Object referralsLock = new Object();

    public DfsImpl(CIFSContext tc) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Map<String, CacheEntry<DfsReferralDataInternal>>> getTrustedDomains(CIFSContext tf) throws SmbAuthException {
        if (tf.getConfig().isDfsDisabled()) return null;
        if (tf.getCredentials().getUserDomain() == null) return null;
        if (tf.getCredentials().getUserDomain().isEmpty()) {
            return null;
        }
        if (this._domains != null && System.currentTimeMillis() > this._domains.expiration) {
            this._domains = null;
        }
        if (this._domains != null) {
            return this._domains.map;
        }
        try {
            String authDomain = tf.getCredentials().getUserDomain();
            try (SmbTransport dc = this.getDc(tf, authDomain);){
                DfsReferralDataInternal start;
                SmbTransportInternal trans;
                CacheEntry entry = new CacheEntry(tf.getConfig().getDfsTtl() * 10L);
                DfsReferralData initial = null;
                SmbTransportInternal smbTransportInternal = trans = dc != null ? dc.unwrap(SmbTransportInternal.class) : null;
                if (trans != null) {
                    initial = trans.getDfsReferrals(tf.withAnonymousCredentials(), "", trans.getRemoteHostName(), authDomain, 0);
                }
                if (initial == null) return null;
                DfsReferralDataInternal dr = start = initial.unwrap(DfsReferralDataInternal.class);
                do {
                    String domain = dr.getServer().toLowerCase();
                    entry.map.put(domain, new HashMap());
                    if (!log.isTraceEnabled()) continue;
                    log.trace("Inserting cache entry for domain " + domain + ": " + dr);
                } while ((dr = dr.next()) != start);
                this._domains = entry;
                Map<String, Map<String, CacheEntry<DfsReferralDataInternal>>> map = this._domains.map;
                return map;
            }
        }
        catch (IOException ioe) {
            if (log.isDebugEnabled()) {
                log.debug("getting trusted domains failed: " + tf.getCredentials().getUserDomain(), (Throwable)ioe);
            }
            CacheEntry entry = new CacheEntry(tf.getConfig().getDfsTtl() * 10L);
            this._domains = entry;
            if (!tf.getConfig().isDfsStrictView()) return this._domains.map;
            if (!(ioe instanceof SmbAuthException)) return this._domains.map;
            throw (SmbAuthException)ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTrustedDomain(CIFSContext tf, String domain) throws SmbAuthException {
        Object object = this.domainsLock;
        synchronized (object) {
            Map<String, Map<String, CacheEntry<DfsReferralDataInternal>>> domains = this.getTrustedDomains(tf);
            if (domains == null) {
                return false;
            }
            boolean bl = domains.get(domain = domain.toLowerCase(Locale.ROOT)) != null;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DfsReferralData getDcReferrals(CIFSContext tf, String domain) throws SmbAuthException {
        if (tf.getConfig().isDfsDisabled()) {
            return null;
        }
        String dom = domain.toLowerCase(Locale.ROOT);
        Object object = this.dcLock;
        synchronized (object) {
            CacheEntry<DfsReferralDataInternal> ce;
            block29: {
                ce = this.dcCache.get(dom);
                if (ce != null && System.currentTimeMillis() > ce.expiration) {
                    ce = null;
                }
                if (ce != null) {
                    DfsReferralDataInternal ri = (DfsReferralDataInternal)ce.map.get(DC_ENTRY);
                    if (ri == NEGATIVE_ENTRY) {
                        return null;
                    }
                    return ri;
                }
                ce = new CacheEntry(tf.getConfig().getDfsTtl());
                try (SmbTransportInternal trans = tf.getTransportPool().getSmbTransport(tf, domain, 0, false, false).unwrap(SmbTransportInternal.class);){
                    SmbTransportInternal smbTransportInternal = trans;
                    synchronized (smbTransportInternal) {
                        DfsReferralData dr = trans.getDfsReferrals(tf.withAnonymousCredentials(), "\\" + dom, domain, dom, 1);
                        if (dr != null) {
                            if (log.isDebugEnabled()) {
                                log.debug("Got DC referral " + dr);
                            }
                            DfsReferralDataInternal dri = dr.unwrap(DfsReferralDataInternal.class);
                            ce.map.put(DC_ENTRY, dri);
                            this.dcCache.put(dom, ce);
                            DfsReferralData dfsReferralData = dr;
                            return dfsReferralData;
                        }
                    }
                }
                catch (IOException ioe) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Getting domain controller for %s failed", domain), (Throwable)ioe);
                    }
                    ce.map.put(DC_ENTRY, NEGATIVE_ENTRY);
                    if (!tf.getConfig().isDfsStrictView() || !(ioe instanceof SmbAuthException)) break block29;
                    throw (SmbAuthException)ioe;
                }
            }
            ce.map.put(DC_ENTRY, NEGATIVE_ENTRY);
            this.dcCache.put(dom, ce);
            return null;
        }
    }

    @Override
    public SmbTransport getDc(CIFSContext tf, String domain) throws SmbAuthException {
        if (tf.getConfig().isDfsDisabled()) {
            return null;
        }
        SmbTransportImpl transport = DfsImpl.getReferralTransport(tf, this.getDcReferrals(tf, domain));
        if (transport == null && log.isDebugEnabled()) {
            log.debug(String.format("Failed to connect to domain controller for %s", domain));
        }
        return transport;
    }

    private static SmbTransportImpl getReferralTransport(CIFSContext tf, DfsReferralData dr) throws SmbAuthException {
        block8: {
            try {
                if (dr != null) {
                    DfsReferralData start = dr;
                    IOException e = null;
                    do {
                        if (dr.getServer() != null && !dr.getServer().isEmpty()) {
                            try {
                                SmbTransportImpl transport = tf.getTransportPool().getSmbTransport(tf, dr.getServer(), 0, false, !tf.getCredentials().isAnonymous() && tf.getConfig().isSigningEnabled() && tf.getConfig().isIpcSigningEnforced()).unwrap(SmbTransportImpl.class);
                                transport.ensureConnected();
                                return transport;
                            }
                            catch (IOException ex) {
                                log.debug("Connection failed " + dr.getServer(), (Throwable)ex);
                                e = ex;
                                dr = dr.next();
                            }
                        } else {
                            log.debug("No server name in referral");
                            return null;
                        }
                    } while (dr != start);
                    throw e;
                }
            }
            catch (IOException ioe) {
                if (!tf.getConfig().isDfsStrictView() || !(ioe instanceof SmbAuthException)) break block8;
                throw (SmbAuthException)ioe;
            }
        }
        return null;
    }

    protected DfsReferralDataInternal getReferral(CIFSContext tf, SmbTransportInternal trans, String target, String targetDomain, String targetHost, String root, String path) throws SmbAuthException {
        block8: {
            if (tf.getConfig().isDfsDisabled()) {
                return null;
            }
            String p = "\\" + target + "\\" + root;
            if (path != null) {
                p = p + path;
            }
            try {
                DfsReferralData dr;
                if (log.isDebugEnabled()) {
                    log.debug("Fetching referral for " + p);
                }
                if ((dr = trans.getDfsReferrals(tf, p, targetHost, targetDomain, 0)) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Referral for %s: %s", p, dr));
                    }
                    return dr.unwrap(DfsReferralDataInternal.class);
                }
            }
            catch (IOException ioe) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Getting referral for %s failed", p), (Throwable)ioe);
                }
                if (!tf.getConfig().isDfsStrictView() || !(ioe instanceof SmbAuthException)) break block8;
                throw (SmbAuthException)ioe;
            }
        }
        return null;
    }

    @Override
    public DfsReferralData resolve(CIFSContext tf, String domain, String root, String path) throws SmbAuthException {
        return this.resolve(tf, domain, root, path, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DfsReferralData resolve(CIFSContext tf, String domain, String root, String path, int depthLimit) throws SmbAuthException {
        if (tf.getConfig().isDfsDisabled() || root == null || root.equals("IPC$") || depthLimit <= 0) {
            return null;
        }
        if (domain == null) {
            return null;
        }
        domain = domain.toLowerCase();
        if (log.isTraceEnabled()) {
            log.trace(String.format("Resolving \\%s\\%s%s", domain, root, path != null ? path : ""));
        }
        DfsReferralDataInternal dr = null;
        long now = System.currentTimeMillis();
        Object object = this.domainsLock;
        synchronized (object) {
            Map<String, Map<String, CacheEntry<DfsReferralDataInternal>>> domains = this.getTrustedDomains(tf);
            if (domains != null) {
                if (log.isTraceEnabled()) {
                    DfsImpl.dumpReferralCache(domains);
                }
                root = root.toLowerCase();
                Map<String, CacheEntry<DfsReferralDataInternal>> roots = domains.get(domain);
                if (roots != null) {
                    dr = this.getLinkReferral(tf, domain, root, path, now, roots);
                }
                if (tf.getConfig().isDfsConvertToFQDN() && dr instanceof DfsReferralDataImpl) {
                    ((DfsReferralDataImpl)dr).fixupDomain(domain);
                }
            }
        }
        if (dr == null && path != null) {
            dr = this.getStandaloneCached(domain, root, path, now);
        }
        if (dr != null && dr.isIntermediate()) {
            dr = this.resolveIntermediates(tf, path, depthLimit, dr);
        }
        return dr;
    }

    private DfsReferralDataInternal resolveIntermediates(CIFSContext tf, String path, int depthLimit, DfsReferralDataInternal dr) throws SmbAuthException {
        DfsReferralDataInternal start;
        DfsReferralDataInternal res = null;
        DfsReferralDataInternal r = start = dr;
        do {
            DfsReferralData nextstart;
            DfsReferralData next;
            r = start.next();
            String refPath = dr.getPath() != null ? '\\' + dr.getPath() : "";
            String nextPath = refPath + (path != null ? path.substring(r.getPathConsumed()) : "");
            if (log.isDebugEnabled()) {
                log.debug(String.format("Intermediate referral, server %s share %s refPath %s origPath %s nextPath %s", r.getServer(), r.getShare(), r.getPath(), path, nextPath));
            }
            if ((next = (nextstart = this.resolve(tf, r.getServer(), r.getShare(), nextPath, depthLimit - 1))) == null) continue;
            do {
                if (log.isDebugEnabled()) {
                    log.debug("Next referral is " + next);
                }
                if (res == null) {
                    res = r.combine(next);
                    continue;
                }
                res.append(r.combine(next));
            } while (next != nextstart);
        } while (r != start);
        if (res != null) {
            return res;
        }
        return dr;
    }

    private static void dumpReferralCache(Map<String, Map<String, CacheEntry<DfsReferralDataInternal>>> domains) {
        for (Map.Entry<String, Map<String, CacheEntry<DfsReferralDataInternal>>> entry : domains.entrySet()) {
            log.trace("Domain " + entry.getKey());
            for (Map.Entry<String, CacheEntry<DfsReferralDataInternal>> entry2 : entry.getValue().entrySet()) {
                log.trace("  Root " + entry2.getKey());
                if (entry2.getValue().map == null) continue;
                for (Map.Entry entry3 : entry2.getValue().map.entrySet()) {
                    DfsReferralDataInternal start;
                    DfsReferralDataInternal r = start = (DfsReferralDataInternal)entry3.getValue();
                    do {
                        log.trace("    " + entry3.getKey() + " => " + entry3.getValue());
                    } while ((r = start.next()) != start);
                }
            }
        }
    }

    private DfsReferralDataInternal getLinkReferral(CIFSContext tf, String domain, String root, String path, long now, Map<String, CacheEntry<DfsReferralDataInternal>> roots) throws SmbAuthException {
        CacheEntry<DfsReferralDataInternal> links;
        DfsReferralDataInternal dr = null;
        if (log.isTraceEnabled()) {
            log.trace("Is a domain referral for " + domain);
        }
        if (log.isTraceEnabled()) {
            log.trace("Resolving root " + root);
        }
        if ((links = roots.get(root)) != null && now > links.expiration) {
            if (log.isDebugEnabled()) {
                log.debug("Removing expired " + links.map);
            }
            roots.remove(root);
            links = null;
        }
        if (links == null) {
            log.trace("Loadings roots");
            String refServerName = domain;
            dr = this.fetchRootReferral(tf, domain, root, refServerName);
            links = DfsImpl.cacheRootReferral(tf, domain, root, roots, dr, links);
        } else if (links instanceof NegativeCacheEntry) {
            links = null;
        } else {
            dr = (DfsReferralDataInternal)links.map.get("\\");
        }
        if (links != null) {
            return this.getLinkReferral(tf, domain, root, path, dr, now, links);
        }
        return dr;
    }

    private static CacheEntry<DfsReferralDataInternal> cacheRootReferral(CIFSContext tf, String domain, String root, Map<String, CacheEntry<DfsReferralDataInternal>> roots, DfsReferralDataInternal dr, CacheEntry<DfsReferralDataInternal> links) {
        if (dr != null) {
            links = new CacheEntry(tf.getConfig().getDfsTtl());
            links.map.put("\\", dr);
            DfsReferralDataInternal tmp = dr;
            do {
                tmp.setCacheMap(links.map);
                tmp.setKey("\\");
            } while ((tmp = tmp.next()) != dr);
            if (log.isDebugEnabled()) {
                log.debug("Have referral " + dr);
            }
            roots.put(root, links);
        } else {
            roots.put(root, new NegativeCacheEntry(tf.getConfig().getDfsTtl()));
        }
        return links;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DfsReferralDataInternal fetchRootReferral(CIFSContext tf, String domain, String root, String refServerName) throws SmbAuthException {
        DfsReferralDataInternal dr;
        try (SmbTransport dc = this.getDc(tf, domain);){
            SmbTransportInternal trans;
            if (dc == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Failed to get domain controller for " + domain);
                }
                DfsReferralDataInternal dfsReferralDataInternal = null;
                return dfsReferralDataInternal;
            }
            SmbTransportInternal smbTransportInternal = trans = dc.unwrap(SmbTransportInternal.class);
            synchronized (smbTransportInternal) {
                try {
                    trans.ensureConnected();
                    refServerName = trans.getRemoteHostName();
                }
                catch (IOException e) {
                    log.warn("Failed to connect to domain controller", (Throwable)e);
                }
                dr = this.getReferral(tf, trans, domain, domain, refServerName, root, null);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("Have DC referral " + dr);
        }
        if (dr != null && domain.equals(dr.getServer()) && root.equals(dr.getShare())) {
            log.warn("Dropping self-referential referral " + dr);
            dr = null;
        }
        return dr;
    }

    private DfsReferralDataInternal getLinkReferral(CIFSContext tf, String domain, String root, String path, DfsReferralDataInternal rootDr, long now, CacheEntry<DfsReferralDataInternal> links) throws SmbAuthException {
        String link;
        DfsReferralDataInternal dr;
        block31: {
            dr = rootDr;
            link = path == null || path.length() <= 1 ? "\\" : (path.charAt(path.length() - 1) == '\\' ? path.substring(0, path.length() - 1) : path);
            if (log.isTraceEnabled()) {
                log.trace("Initial link is " + link);
            }
            if (dr == null || !link.equals(dr.getLink())) {
                while (true) {
                    if ((dr = (DfsReferralDataInternal)links.map.get(link)) != null) {
                        if (log.isTraceEnabled()) {
                            log.trace("Found at " + link);
                        }
                        break block31;
                    }
                    int nextSep = link.lastIndexOf(92);
                    if (nextSep <= 0) break;
                    link = link.substring(0, nextSep);
                }
                if (log.isTraceEnabled()) {
                    log.trace("Not found " + link);
                }
            }
        }
        if (dr != null && now > dr.getExpiration()) {
            if (log.isTraceEnabled()) {
                log.trace("Expiring links " + link);
            }
            links.map.remove(link);
            dr = null;
        }
        if (dr == null) {
            try (SmbTransportImpl trans = DfsImpl.getReferralTransport(tf, rootDr);){
                if (trans == null) {
                    DfsReferralDataInternal dfsReferralDataInternal = null;
                    return dfsReferralDataInternal;
                }
                dr = this.getReferral(tf, trans, domain, domain, trans.getRemoteHostName(), root, path);
                if (dr != null) {
                    if (tf.getConfig().isDfsConvertToFQDN() && dr instanceof DfsReferralDataImpl) {
                        ((DfsReferralDataImpl)dr).fixupDomain(domain);
                    }
                    dr.stripPathConsumed(1 + domain.length() + 1 + root.length());
                    if (dr.getPathConsumed() > (path != null ? path.length() : 0)) {
                        log.error("Consumed more than we provided");
                    }
                    link = path != null && dr.getPathConsumed() > 0 ? path.substring(0, dr.getPathConsumed()) : "\\";
                    dr.setLink(link);
                    if (log.isTraceEnabled()) {
                        log.trace("Have referral " + dr);
                    }
                    links.map.put(link, dr);
                }
                log.debug("No referral found for " + link);
            }
        } else if (log.isTraceEnabled()) {
            log.trace("Have cached referral for " + dr.getLink() + " " + dr);
        }
        return dr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DfsReferralDataInternal getStandaloneCached(String domain, String root, String path, long now) {
        CacheEntry<DfsReferralDataInternal> refs;
        if (log.isTraceEnabled()) {
            log.trace("No match for domain based root, checking standalone " + domain);
        }
        Object object = this.referralsLock;
        synchronized (object) {
            refs = this.referrals;
            if (refs == null || now > refs.expiration) {
                refs = new CacheEntry(0L);
            }
            this.referrals = refs;
        }
        String key = "\\" + domain + "\\" + root;
        if (!path.equals("\\")) {
            key = key + path;
        }
        key = key.toLowerCase(Locale.ROOT);
        Iterator<String> iter = refs.map.keySet().iterator();
        int searchLen = key.length();
        while (iter.hasNext()) {
            String cachedKey = iter.next();
            int cachedKeyLen = cachedKey.length();
            boolean match = false;
            if (cachedKeyLen == searchLen) {
                match = cachedKey.equals(key);
            } else if (cachedKeyLen < searchLen) {
                match = key.startsWith(cachedKey);
            } else if (log.isTraceEnabled()) {
                log.trace(key + " vs. " + cachedKey);
            }
            if (!match) continue;
            if (log.isDebugEnabled()) {
                log.debug("Matched " + cachedKey);
            }
            return (DfsReferralDataInternal)refs.map.get(cachedKey);
        }
        if (log.isTraceEnabled()) {
            log.trace("No match for " + key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void cache(CIFSContext tc, String path, DfsReferralData dr) {
        if (tc.getConfig().isDfsDisabled() || !(dr instanceof DfsReferralDataInternal)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Inserting referral for " + path);
        }
        int s1 = path.indexOf(92, 1);
        int s2 = path.indexOf(92, s1 + 1);
        if (s1 < 0 || s2 < 0) {
            log.error("Invalid UNC path " + path);
            return;
        }
        String server = path.substring(1, s1).toLowerCase(Locale.ROOT);
        String share = path.substring(s1 + 1, s2);
        String key = path.substring(0, dr.getPathConsumed()).toLowerCase(Locale.ROOT);
        DfsReferralDataInternal dri = (DfsReferralDataInternal)dr;
        if (tc.getConfig().isDfsConvertToFQDN()) {
            dri.fixupHost(server);
        }
        if (log.isDebugEnabled()) {
            log.debug("Adding key " + key + " to " + dr);
        }
        dri.stripPathConsumed(1 + server.length() + 1 + share.length());
        if (key.charAt(key.length() - 1) != '\\') {
            key = key + '\\';
        }
        if (log.isDebugEnabled()) {
            log.debug("Key is " + key);
        }
        CacheEntry<DfsReferralDataInternal> refs = this.referrals;
        Object object = this.referralsLock;
        synchronized (object) {
            if (refs == null || System.currentTimeMillis() + 10000L > refs.expiration) {
                refs = new CacheEntry(tc.getConfig().getDfsTtl());
            }
            this.referrals = refs;
        }
        refs.map.put(key, dri);
    }

    private static class NegativeCacheEntry<T>
    extends CacheEntry<T> {
        NegativeCacheEntry(long ttl) {
            super(ttl);
        }
    }

    private static class CacheEntry<T> {
        long expiration;
        Map<String, T> map;

        CacheEntry(long ttl) {
            this.expiration = System.currentTimeMillis() + ttl * 1000L;
            this.map = new ConcurrentHashMap<String, T>();
        }
    }
}

