/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb1.com;

import jcifs.Configuration;
import jcifs.internal.smb1.ServerMessageBlock;
import jcifs.internal.util.SMBUtil;

public class SmbComWrite
extends ServerMessageBlock {
    private int fid;
    private int count;
    private int offset;
    private int remaining;
    private int off;
    private byte[] b;

    public SmbComWrite(Configuration config) {
        super(config, (byte)11);
    }

    public SmbComWrite(Configuration config, int fid, int offset, int remaining, byte[] b, int off, int len) {
        super(config, (byte)11);
        this.fid = fid;
        this.count = len;
        this.offset = offset;
        this.remaining = remaining;
        this.b = b;
        this.off = off;
    }

    public final void setParam(int fid, long offset, int remaining, byte[] b, int off, int len) {
        this.fid = fid;
        this.offset = (int)(offset & 0xFFFFFFFFL);
        this.remaining = remaining;
        this.b = b;
        this.off = off;
        this.count = len;
        this.digest = null;
    }

    @Override
    protected int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(this.fid, dst, dstIndex);
        SMBUtil.writeInt2(this.count, dst, dstIndex += 2);
        SMBUtil.writeInt4(this.offset, dst, dstIndex += 2);
        SMBUtil.writeInt2(this.remaining, dst, dstIndex += 4);
        return (dstIndex += 2) - start;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        dst[dstIndex++] = 1;
        SMBUtil.writeInt2(this.count, dst, dstIndex);
        System.arraycopy(this.b, this.off, dst, dstIndex += 2, this.count);
        return (dstIndex += this.count) - start;
    }

    @Override
    protected int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    public String toString() {
        return new String("SmbComWrite[" + super.toString() + ",fid=" + this.fid + ",count=" + this.count + ",offset=" + this.offset + ",remaining=" + this.remaining + "]");
    }
}

