/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.correlation.drools;

import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.drools.io.ClassPathResource;
import org.kie.api.KieServices;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.io.Resource;
import org.kie.api.logger.KieRuntimeLogger;
import org.kie.api.runtime.KieSession;
import org.kie.internal.utils.KieHelper;

public abstract class CorrelationExample {
    public static void main(String[] args) throws Exception {
        KieSession session = new KieHelper().addResource((Resource)new ClassPathResource("CorrelationExample.drl")).build(new KieBaseOption[0]).newKieSession();
        KieRuntimeLogger logger = KieServices.Factory.get().getLoggers().newFileLogger((KieRuntimeEventManager)session, "log/correlation");
        try (InputStream in = CorrelationExample.class.getResourceAsStream("simulation");){
            Simulation simulation = new Simulation();
            System.out.println("Loading Simulation");
            simulation.load(in);
            System.out.println("Executing Simulation");
            simulation.simulate(session);
        }
        logger.close();
    }

    private static void sleep(int delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static class PossibleCause {
        private Node m_node;
        private Outage m_outage;
        private boolean m_verified;

        public PossibleCause(Node node, Outage outage) {
            this(node, outage, false);
        }

        public PossibleCause(Node node, Outage outage, boolean verified) {
            this.m_node = node;
            this.m_outage = outage;
            this.m_verified = verified;
        }

        public Node getNode() {
            return this.m_node;
        }

        public Outage getOutage() {
            return this.m_outage;
        }

        public boolean isVerified() {
            return this.m_verified;
        }

        public void setVerified(boolean verified) {
            this.m_verified = verified;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("node", (Object)this.m_node).append("outage", (Object)this.m_outage).toString();
        }
    }

    public static class EventBean {
        private String m_uei;
        private Node m_node;

        public EventBean(String uei, Node node) {
            this.m_uei = uei;
            this.m_node = node;
        }

        public String getUei() {
            return this.m_uei;
        }

        public Node getNode() {
            return this.m_node;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("uei", (Object)this.m_uei).append("node", (Object)this.m_node).toString();
        }
    }

    public static class Node {
        private Integer m_id;
        private Node m_parent;
        private String m_label;

        public Node(Integer id, String label, Node parent) {
            this.m_id = id;
            this.m_label = label;
            this.m_parent = parent;
        }

        public Integer getId() {
            return this.m_id;
        }

        public Node getParent() {
            return this.m_parent;
        }

        public String getLabel() {
            return this.m_label;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("id", (Object)this.m_id).append("label", (Object)this.m_label).toString();
        }
    }

    public static class Outage {
        private EventBean m_problem;
        private EventBean m_resolution;
        private Node m_cause;
        private Node m_node;

        public Outage(Node node, EventBean problem) {
            this.m_node = node;
            this.m_problem = problem;
        }

        public Node getNode() {
            return this.m_node;
        }

        public EventBean getProblem() {
            return this.m_problem;
        }

        public EventBean getResolution() {
            return this.m_resolution;
        }

        public void setResolution(EventBean resolution) {
            this.m_resolution = resolution;
        }

        public Node getCause() {
            return this.m_cause;
        }

        public void setCause(Node cause) {
            this.m_cause = cause;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("problem", (Object)this.m_problem).append("cause", (Object)this.m_cause).append("resolution", (Object)this.m_resolution).toString();
        }
    }

    public static class Simulation {
        final Map<Integer, Node> m_nodes = new HashMap<Integer, Node>();
        final List<SimItem> m_eventSequence = new LinkedList<SimItem>();

        public void load(InputStream in) {
            Scanner scanner = new Scanner(in);
            while (scanner.hasNext()) {
                String lineType = scanner.next();
                if ("#".equals(lineType)) {
                    scanner.nextLine();
                } else if ("node".equals(lineType)) {
                    String nodeLabel = scanner.next();
                    Integer nodeId = scanner.nextInt();
                    assert (this.m_nodes.get(nodeId) == null) : "Already have a node with id " + nodeId;
                    Integer parentId = null;
                    if (scanner.hasNextInt()) {
                        parentId = scanner.nextInt();
                    }
                    assert (parentId == null || this.m_nodes.containsKey(parentId)) : "Reference to parentId " + parentId + " that is not yet defined";
                    Node parent = parentId == null ? null : this.m_nodes.get(parentId);
                    Node node = new Node(nodeId, nodeLabel, parent);
                    this.m_nodes.put(nodeId, node);
                } else if ("event".equals(lineType)) {
                    int delay = scanner.nextInt();
                    String uei = scanner.next();
                    Integer nodeId = scanner.nextInt();
                    assert (this.m_nodes.containsKey(nodeId)) : "Invalid nodeId " + nodeId;
                    EventBean e = new EventBean(uei, this.m_nodes.get(nodeId));
                    SimItem item = new SimItem(delay, e);
                    this.m_eventSequence.add(item);
                }
                scanner.close();
            }
        }

        public void simulate(KieSession session) {
            for (SimItem item : this.m_eventSequence) {
                item.simulate(session);
                System.out.println("Memory Size = " + session.getObjects().size());
            }
        }

        public static class SimItem {
            final int m_delay;
            final EventBean m_event;

            public SimItem(int delay, EventBean event) {
                this.m_delay = delay;
                this.m_event = event;
            }

            public void simulate(KieSession session) {
                CorrelationExample.sleep(this.m_delay);
                System.out.println("Start simulation of " + this);
                session.insert((Object)this.m_event);
                session.fireAllRules();
                System.out.println("End simulation of " + this);
            }
        }
    }
}

