/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.configuration;

import java.io.PrintWriter;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.felix.webconsole.internal.AbstractConfigurationPrinter;
import org.apache.felix.webconsole.internal.configuration.ConfigAdminSupport;
import org.apache.felix.webconsole.internal.configuration.MetaTypeServiceSupport;
import org.apache.felix.webconsole.internal.configuration.MetaTypeSupport;
import org.apache.felix.webconsole.internal.misc.ConfigurationRender;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;

public class ConfigurationAdminConfigurationPrinter
extends AbstractConfigurationPrinter {
    private static final String TITLE = "Configurations";

    @Override
    public String getTitle() {
        return TITLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printConfiguration(PrintWriter pw) {
        block18: {
            ServiceReference sr = this.getBundleContext().getServiceReference(ConfigurationAdmin.class);
            try {
                ConfigurationAdmin ca;
                ConfigurationAdmin configurationAdmin = ca = sr == null ? null : (ConfigurationAdmin)this.getBundleContext().getService(sr);
                if (ca == null) {
                    pw.println("Status: Configuration Admin Service not available");
                    break block18;
                }
                MetaTypeServiceSupport metatypeSupport = null;
                ServiceReference msr = this.getBundleContext().getServiceReference("org.osgi.service.metatype.MetaTypeService");
                try {
                    Configuration[] configs;
                    Object metaTypeService;
                    if (msr != null && (metaTypeService = this.getBundleContext().getService(msr)) != null) {
                        metatypeSupport = new MetaTypeServiceSupport(this.getBundleContext(), metaTypeService);
                    }
                    if ((configs = ca.listConfigurations(null)) != null && configs.length > 0) {
                        HashSet<String> factories = new HashSet<String>();
                        TreeMap<String, Configuration> sm = new TreeMap<String, Configuration>();
                        for (int i = 0; i < configs.length; ++i) {
                            sm.put(configs[i].getPid(), configs[i]);
                            String fpid = configs[i].getFactoryPid();
                            if (null == fpid) continue;
                            factories.add(fpid);
                        }
                        if (factories.isEmpty()) {
                            pw.println("Status: " + configs.length + " configurations available");
                        } else {
                            pw.println("Status: " + configs.length + " configurations with " + factories.size() + " different factories available");
                        }
                        pw.println();
                        Iterator mi = sm.values().iterator();
                        while (mi.hasNext()) {
                            this.printConfiguration(pw, metatypeSupport, (Configuration)mi.next());
                        }
                    } else {
                        pw.println("Status: No Configurations available");
                    }
                }
                finally {
                    if (msr != null) {
                        this.getBundleContext().ungetService(msr);
                    }
                }
            }
            catch (Exception ignore) {
                pw.println("Status: Configuration Admin Service not accessible");
            }
            finally {
                if (sr != null) {
                    this.getBundleContext().ungetService(sr);
                }
            }
        }
    }

    private void printConfiguration(PrintWriter pw, MetaTypeServiceSupport metatypeSupport, Configuration config) {
        Dictionary props;
        ConfigurationRender.infoLine(pw, "", "PID", config.getPid());
        if (config.getFactoryPid() != null) {
            ConfigurationRender.infoLine(pw, "  ", "Factory PID", config.getFactoryPid());
        }
        if (config.getBundleLocation() != null) {
            ConfigurationRender.infoLine(pw, "  ", "BundleLocation", config.getBundleLocation());
        }
        if ((props = config.getProperties()) != null) {
            AttributeDefinition[] ad;
            ObjectClassDefinition ocd;
            HashSet<String> obfuscateProperties = new HashSet<String>();
            if (metatypeSupport != null && config != null && (ocd = metatypeSupport.getObjectClassDefinition(config, null)) != null && (ad = ocd.getAttributeDefinitions(-1)) != null) {
                for (AttributeDefinition def : ad) {
                    if (def.getType() != 12) continue;
                    obfuscateProperties.add(def.getID());
                }
            }
            TreeSet<String> keys = new TreeSet<String>();
            Enumeration ke = props.keys();
            while (ke.hasMoreElements()) {
                keys.add((String)ke.nextElement());
            }
            for (String key : keys) {
                if (ConfigAdminSupport.CONFIG_PROPERTIES_HIDE.contains(key)) continue;
                String value = obfuscateProperties.contains(key) || MetaTypeSupport.isPasswordProperty(key) ? "********" : props.get(key);
                ConfigurationRender.infoLine(pw, "  ", key, value);
            }
        }
        pw.println();
    }
}

