/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import javax.inject.Inject;
import org.opennms.netmgt.config.GroupManager;
import org.opennms.netmgt.config.NotificationCommandManager;
import org.opennms.netmgt.config.NotificationManager;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.config.groups.Group;
import org.opennms.netmgt.config.notificationCommands.Command;
import org.opennms.netmgt.config.notifications.Notification;
import org.opennms.netmgt.config.users.Contact;
import org.opennms.netmgt.config.users.User;
import org.opennms.netmgt.notifd.BroadcastEventProcessor;
import org.opennms.netmgt.notifd.ExecutorStrategy;
import org.opennms.netmgt.notifd.NotificationTask;
import org.opennms.netmgt.notifd.api.NotificationTester;
import org.opennms.netmgt.xml.event.Event;

public class NotificationTesterImpl
implements NotificationTester {
    private final BroadcastEventProcessor broadcastEventProcessor;
    private final NotificationManager notificationManager;
    private final NotificationCommandManager notificationCommandManager;
    private final GroupManager groupManager;
    private final UserManager userManager;
    private static final Executor rejectingExecutor = command -> {
        throw new RejectedExecutionException();
    };

    @Inject
    public NotificationTesterImpl(BroadcastEventProcessor broadcastEventProcessor, NotificationManager notificationManager, NotificationCommandManager notificationCommandManager, GroupManager groupManager, UserManager userManager) {
        this.broadcastEventProcessor = Objects.requireNonNull(broadcastEventProcessor);
        this.notificationManager = Objects.requireNonNull(notificationManager);
        this.notificationCommandManager = Objects.requireNonNull(notificationCommandManager);
        this.groupManager = Objects.requireNonNull(groupManager);
        this.userManager = Objects.requireNonNull(userManager);
    }

    public void triggerNotificationsForTarget(String targetName, String commandName) {
        List<User> users;
        try {
            users = this.getUsersForTarget(targetName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (users.isEmpty()) {
            throw new RuntimeException(String.format("No users for target='%s' found.", targetName));
        }
        Command command = this.notificationCommandManager.getCommand(commandName);
        if (command == null) {
            throw new RuntimeException(String.format("No command with name='%s' found.", commandName));
        }
        Notification notification = new Notification();
        notification.setTextMessage("THIS IS A TEST MESSAGE");
        notification.setNumericMessage("TEST NUMERIC");
        notification.setSubject("THIS IS A TEST SUBJECT");
        Event event = new Event();
        event.setUei("uei.opennms.org/nodes/nodeLostService");
        event.setDbid(Integer.valueOf(0));
        Map<String, String> parameterMap = this.broadcastEventProcessor.buildParameterMap(notification, event, 0);
        for (User user : users) {
            this.triggerNotificationTask(user, command, parameterMap);
        }
    }

    private void triggerNotificationTask(User user, Command command, Map<String, String> parameterMap) {
        NotificationTask task = new NotificationTask(this.notificationManager, this.userManager, System.currentTimeMillis(), parameterMap, Collections.emptyList(), Boolean.FALSE.toString(), rejectingExecutor);
        task.setUser(user);
        task.setCommands(new Command[]{command});
        ExecutorStrategy strategy = NotificationTask.getExecutorStrategy(command);
        strategy.execute(command.getExecute(), task.getArgumentList(command));
    }

    public List<User> getUsersForTarget(String target) throws IOException {
        LinkedList<User> users = new LinkedList<User>();
        Group group = this.groupManager.getGroup(target);
        if (group != null) {
            List groupUsers = group.getUsers();
            for (String groupUser : groupUsers) {
                User user = this.userManager.getUser(groupUser);
                if (user == null) continue;
                users.add(user);
            }
            return users;
        }
        if (this.userManager.hasOnCallRole(target)) {
            String[] userNames;
            for (String userName : userNames = this.userManager.getUsersScheduledForRole(target, new Date())) {
                User user = this.userManager.getUser(userName);
                if (user == null) continue;
                users.add(user);
            }
            return users;
        }
        User user = this.userManager.getUser(target);
        if (user != null) {
            return Collections.singletonList(user);
        }
        if (target.indexOf(64) >= 0) {
            user = new User();
            user.setUserId(target);
            Contact contact = new Contact();
            contact.setType("email");
            contact.setInfo(target);
            user.addContact(contact);
            return Collections.singletonList(user);
        }
        return Collections.emptyList();
    }
}

