/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.shell;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.opennms.netmgt.telemetry.shell.Utils;

public enum Format {
    PLAIN{

        private Stream<String> indent(String first, String other, Stream<String> input) {
            AtomicBoolean state = new AtomicBoolean(true);
            return input.map(line -> String.format("%s%s", state.compareAndSet(true, false) ? first : other, line));
        }

        private Stream<String> object(JsonObject data) {
            return data.entrySet().stream().flatMap(entry -> {
                String name = StringUtils.capitalize((String)StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)((String)entry.getKey())), (String)" "));
                if (((JsonElement)entry.getValue()).isJsonNull()) {
                    return Stream.empty();
                }
                if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                    return Stream.of(String.format("%s = %s", name, ((JsonElement)entry.getValue()).getAsJsonPrimitive().getAsString()));
                }
                if (((JsonElement)entry.getValue()).isJsonArray()) {
                    return Stream.concat(Stream.of(String.format("%s:", name)), this.indent("  ", "  ", this.array(((JsonElement)entry.getValue()).getAsJsonArray())));
                }
                if (((JsonElement)entry.getValue()).isJsonObject()) {
                    return Stream.concat(Stream.of(String.format("%s:", name)), this.indent("  ", "  ", this.object(((JsonElement)entry.getValue()).getAsJsonObject())));
                }
                throw new IllegalArgumentException(((JsonElement)entry.getValue()).toString());
            });
        }

        private Stream<String> array(JsonArray data) {
            return StreamSupport.stream(data.spliterator(), false).flatMap(element -> {
                if (element.isJsonNull()) {
                    return Stream.empty();
                }
                if (element.isJsonPrimitive()) {
                    return Stream.of(String.format("- %s", element.getAsJsonPrimitive().getAsString()));
                }
                if (element.isJsonObject()) {
                    return this.indent("- ", "  ", this.object(element.getAsJsonObject()));
                }
                if (element.isJsonArray()) {
                    return this.indent("- ", "  ", this.array(element.getAsJsonArray()));
                }
                throw new IllegalArgumentException(element.toString());
            });
        }

        @Override
        public void print(List<JsonObject> data) {
            data.forEach(element -> {
                JsonObject json = Utils.GSON.toJsonTree(element).getAsJsonObject();
                this.object(json).forEach(System.out::println);
                System.out.println();
            });
        }
    }
    ,
    JSON{

        @Override
        public void print(List<JsonObject> data) {
            String json = Utils.GSON.toJson(data);
            System.out.println(json);
        }
    };


    public abstract void print(List<JsonObject> var1);
}

