/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xml.eventconf;

import com.google.common.base.MoreObjects;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.model.ResourceTypeUtils;

@XmlRootElement(name="collectionGroup")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="eventconf.xsd")
@XmlType(propOrder={"rrd", "collection"})
public class CollectionGroup
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlAttribute(name="resourceType")
    private String resourceType = "nodeSnmp";
    @XmlAttribute(name="instance")
    private String instance;
    @XmlElement(name="rrd")
    private Rrd rrd;
    @XmlElement(name="collection")
    private List<Collection> collection = new ArrayList<Collection>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public Rrd getRrd() {
        return this.rrd;
    }

    public void setRrd(Rrd rrd) {
        this.rrd = rrd;
    }

    public List<Collection> getCollection() {
        return this.collection;
    }

    public void setCollection(List<Collection> collection) {
        this.collection = collection;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.resourceType, this.rrd);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CollectionGroup) {
            CollectionGroup that = (CollectionGroup)obj;
            return Objects.equals(this.name, that.name) && Objects.equals(this.resourceType, that.resourceType) && Objects.equals(this.rrd, that.rrd) && Objects.equals(this.collection, that.collection);
        }
        return false;
    }

    @XmlRootElement(name="paramValue")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class ParamValue {
        @XmlAttribute(name="key", required=true)
        private String name;
        @XmlAttribute(name="value", required=true)
        private Double value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Double getValue() {
            return this.value;
        }

        public void setValue(Double value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParamValue that = (ParamValue)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.value).toString();
        }
    }

    @XmlRootElement(name="collection")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class Collection {
        @XmlAttribute(name="name", required=true)
        private String name;
        @XmlAttribute(name="rename")
        private String rename;
        @XmlAttribute(name="type")
        private AttributeType type;
        @XmlElement(name="paramValue")
        private List<ParamValue> paramValue = new ArrayList<ParamValue>();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRename() {
            return this.rename;
        }

        public void setRename(String rename) {
            this.rename = rename;
        }

        public AttributeType getType() {
            return this.type;
        }

        public void setType(AttributeType type) {
            this.type = type;
        }

        public List<ParamValue> getParamValue() {
            return this.paramValue;
        }

        public void setParamValue(List<ParamValue> paramValue) {
            this.paramValue = paramValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Collection that = (Collection)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.paramValue, that.paramValue);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type, this.paramValue);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).add("paramValue", this.paramValue).toString();
        }
    }

    @XmlRootElement(name="rrd")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class Rrd {
        private static final File DEFAULT_BASE_DIRECTORY = new File(ResourceTypeUtils.DEFAULT_RRD_ROOT, "snmp");
        @XmlAttribute(name="step")
        private Integer step;
        @XmlAttribute(name="heartBeat")
        private Integer heartBeat = -1;
        @XmlElement(name="rra")
        private List<String> rras = new ArrayList<String>();

        public Integer getStep() {
            return this.step;
        }

        public void setStep(Integer step) {
            this.step = step;
        }

        public int getHeartBeat() {
            return this.heartBeat == -1 ? this.getStep() * 2 : this.heartBeat;
        }

        public void setHeartBeat(int heartBeat) {
            this.heartBeat = heartBeat;
        }

        public List<String> getRras() {
            return this.rras;
        }

        public void setRras(List<String> rras) {
            this.rras = rras;
        }

        public File getBaseDir() {
            return DEFAULT_BASE_DIRECTORY;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Rrd that = (Rrd)o;
            return Objects.equals(this.step, that.step) && Objects.equals(this.rras, that.rras) && Objects.equals(this.heartBeat, that.heartBeat);
        }

        public int hashCode() {
            return Objects.hash(this.step, this.rras, this.heartBeat);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("step", (Object)this.step).add("rras", this.rras).add("heartBeat", (Object)this.heartBeat).toString();
        }
    }
}

