/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.commands;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.snmp.SnmpStrategy;
import org.snmp4j.smi.OctetString;

@Command(scope="opennms", name="snmp-local-engine-id", description="Display the Local Engine Id used for Traps/Informs")
@Service
public class LocalEngineIdCommand
implements Action {
    @Reference
    private SnmpStrategy snmpStrategy;

    public Object execute() throws Exception {
        if (this.snmpStrategy != null) {
            byte[] localEngineId = this.snmpStrategy.getLocalEngineID();
            if (localEngineId != null) {
                OctetString engineIdString = new OctetString(localEngineId);
                System.out.printf("localEngineId = %s \n", engineIdString);
                return engineIdString;
            }
            System.out.println("localEngineId is not configured in SnmpStrategy");
        } else {
            System.out.println("SnmpStrategy is not registered");
        }
        return null;
    }
}

