/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.config.EnhancedLinkdConfig;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.enlinkd.BridgeOnmsTopologyUpdater;
import org.opennms.netmgt.enlinkd.CdpOnmsTopologyUpdater;
import org.opennms.netmgt.enlinkd.DiscoveryBridgeDomains;
import org.opennms.netmgt.enlinkd.IsisOnmsTopologyUpdater;
import org.opennms.netmgt.enlinkd.LldpOnmsTopologyUpdater;
import org.opennms.netmgt.enlinkd.NetworkRouterTopologyUpdater;
import org.opennms.netmgt.enlinkd.NodeCollectionGroupBridge;
import org.opennms.netmgt.enlinkd.NodeCollectionGroupCdp;
import org.opennms.netmgt.enlinkd.NodeCollectionGroupIpNetToMedia;
import org.opennms.netmgt.enlinkd.NodeCollectionGroupIsis;
import org.opennms.netmgt.enlinkd.NodeCollectionGroupLldp;
import org.opennms.netmgt.enlinkd.NodeCollectionGroupOspf;
import org.opennms.netmgt.enlinkd.NodesOnmsTopologyUpdater;
import org.opennms.netmgt.enlinkd.OspfAreaOnmsTopologyUpdater;
import org.opennms.netmgt.enlinkd.OspfOnmsTopologyUpdater;
import org.opennms.netmgt.enlinkd.UserDefinedLinkTopologyUpdater;
import org.opennms.netmgt.enlinkd.api.ReloadableTopologyDaemon;
import org.opennms.netmgt.enlinkd.common.SchedulableNodeCollectorGroup;
import org.opennms.netmgt.enlinkd.common.TopologyUpdater;
import org.opennms.netmgt.enlinkd.service.api.BridgeTopologyService;
import org.opennms.netmgt.enlinkd.service.api.CdpTopologyService;
import org.opennms.netmgt.enlinkd.service.api.IpNetToMediaTopologyService;
import org.opennms.netmgt.enlinkd.service.api.IsisTopologyService;
import org.opennms.netmgt.enlinkd.service.api.LldpTopologyService;
import org.opennms.netmgt.enlinkd.service.api.Node;
import org.opennms.netmgt.enlinkd.service.api.NodeTopologyService;
import org.opennms.netmgt.enlinkd.service.api.OspfTopologyService;
import org.opennms.netmgt.enlinkd.service.api.ProtocolSupported;
import org.opennms.netmgt.scheduler.LegacyPriorityExecutor;
import org.opennms.netmgt.scheduler.LegacyScheduler;
import org.opennms.netmgt.scheduler.PriorityReadyRunnable;
import org.opennms.netmgt.scheduler.Schedulable;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class EnhancedLinkd
extends AbstractServiceDaemon
implements ReloadableTopologyDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(EnhancedLinkd.class);
    private static final String LOG_PREFIX = "enlinkd";
    private LegacyScheduler m_scheduler;
    private LegacyPriorityExecutor m_executor;
    private NodeTopologyService m_queryMgr;
    private BridgeTopologyService m_bridgeTopologyService;
    private CdpTopologyService m_cdpTopologyService;
    private IsisTopologyService m_isisTopologyService;
    private IpNetToMediaTopologyService m_ipNetToMediaTopologyService;
    private LldpTopologyService m_lldpTopologyService;
    private OspfTopologyService m_ospfTopologyService;
    private EnhancedLinkdConfig m_linkdConfig;
    @Autowired
    private LocationAwareSnmpClient m_locationAwareSnmpClient;
    @Autowired
    private NodesOnmsTopologyUpdater m_nodesTopologyUpdater;
    @Autowired
    private BridgeOnmsTopologyUpdater m_bridgeTopologyUpdater;
    @Autowired
    private CdpOnmsTopologyUpdater m_cdpTopologyUpdater;
    @Autowired
    private LldpOnmsTopologyUpdater m_lldpTopologyUpdater;
    @Autowired
    private IsisOnmsTopologyUpdater m_isisTopologyUpdater;
    @Autowired
    private OspfOnmsTopologyUpdater m_ospfTopologyUpdater;
    @Autowired
    private OspfAreaOnmsTopologyUpdater m_ospfAreaTopologyUpdater;
    @Autowired
    private DiscoveryBridgeDomains m_discoveryBridgeDomains;
    @Autowired
    private UserDefinedLinkTopologyUpdater m_userDefinedLinkTopologyUpdater;
    @Autowired
    private NetworkRouterTopologyUpdater m_networkRouterTopologyUpdater;
    private final List<SchedulableNodeCollectorGroup> m_groups = new ArrayList<SchedulableNodeCollectorGroup>();

    public EnhancedLinkd() {
        super(LOG_PREFIX);
    }

    protected void onInit() {
        BeanUtils.assertAutowiring((Object)((Object)this));
        try {
            LOG.info("init: Creating EnhancedLinkd scheduler");
            this.m_scheduler = new LegacyScheduler("EnhancedLinkd", this.m_linkdConfig.getThreads());
        }
        catch (RuntimeException e) {
            LOG.error("init: Failed to create EnhancedLinkd scheduler", (Throwable)e);
            throw e;
        }
        try {
            LOG.info("init: Creating EnhancedLinkd executor");
            this.m_executor = new LegacyPriorityExecutor("EnhancedLinkd", Integer.valueOf(this.m_linkdConfig.getExecutorThreads()), Integer.valueOf(this.m_linkdConfig.getExecutorQueueSize()));
        }
        catch (RuntimeException e) {
            LOG.error("init: Failed to create EnhancedLinkd executor", (Throwable)e);
            throw e;
        }
        LOG.debug("init: Loading Bridge Topology.....");
        this.m_bridgeTopologyService.load();
        LOG.debug("init: Bridge Topology loaded.");
        this.schedule(true);
    }

    private void schedule(boolean init) {
        if (init) {
            this.scheduleAndRegisterOnmsTopologyUpdater(this.m_nodesTopologyUpdater);
            this.scheduleAndRegisterOnmsTopologyUpdater(this.m_networkRouterTopologyUpdater);
            this.scheduleAndRegisterOnmsTopologyUpdater(this.m_userDefinedLinkTopologyUpdater);
        }
        if (this.m_linkdConfig.useCdpDiscovery()) {
            NodeCollectionGroupCdp nodeCollectionGroupCdp = new NodeCollectionGroupCdp(this.m_linkdConfig.getCdpRescanInterval(), this.m_linkdConfig.getInitialSleepTime(), this.m_executor, this.m_linkdConfig.getCdpPriority(), this.m_queryMgr, this.m_locationAwareSnmpClient, this.m_cdpTopologyService);
            nodeCollectionGroupCdp.setScheduler(this.m_scheduler);
            nodeCollectionGroupCdp.schedule();
            this.m_groups.add(nodeCollectionGroupCdp);
            this.scheduleAndRegisterOnmsTopologyUpdater(this.m_cdpTopologyUpdater);
        } else {
            this.m_cdpTopologyService.deletePersistedData();
        }
        if (this.m_linkdConfig.useLldpDiscovery()) {
            NodeCollectionGroupLldp nodeCollectionGroupLldp = new NodeCollectionGroupLldp(this.m_linkdConfig.getLldpRescanInterval(), this.m_linkdConfig.getInitialSleepTime(), this.m_executor, this.m_linkdConfig.getLldpPriority(), this.m_queryMgr, this.m_locationAwareSnmpClient, this.m_lldpTopologyService);
            nodeCollectionGroupLldp.setScheduler(this.m_scheduler);
            nodeCollectionGroupLldp.schedule();
            this.m_groups.add(nodeCollectionGroupLldp);
            this.scheduleAndRegisterOnmsTopologyUpdater(this.m_lldpTopologyUpdater);
        } else {
            this.m_lldpTopologyService.deletePersistedData();
        }
        if (this.m_linkdConfig.useIsisDiscovery()) {
            NodeCollectionGroupIsis nodeCollectionGroupIsis = new NodeCollectionGroupIsis(this.m_linkdConfig.getIsisRescanInterval(), this.m_linkdConfig.getInitialSleepTime(), this.m_executor, this.m_linkdConfig.getIsisPriority(), this.m_queryMgr, this.m_locationAwareSnmpClient, this.m_isisTopologyService);
            nodeCollectionGroupIsis.setScheduler(this.m_scheduler);
            nodeCollectionGroupIsis.schedule();
            this.m_groups.add(nodeCollectionGroupIsis);
            this.scheduleAndRegisterOnmsTopologyUpdater(this.m_isisTopologyUpdater);
        } else {
            this.m_isisTopologyService.deletePersistedData();
        }
        if (this.m_linkdConfig.useOspfDiscovery()) {
            NodeCollectionGroupOspf nodeCollectionGroupOspf = new NodeCollectionGroupOspf(this.m_linkdConfig.getOspfRescanInterval(), this.m_linkdConfig.getInitialSleepTime(), this.m_executor, this.m_linkdConfig.getOspfPriority(), this.m_queryMgr, this.m_locationAwareSnmpClient, this.m_ospfTopologyService);
            nodeCollectionGroupOspf.setScheduler(this.m_scheduler);
            nodeCollectionGroupOspf.schedule();
            this.m_groups.add(nodeCollectionGroupOspf);
            this.scheduleAndRegisterOnmsTopologyUpdater(this.m_ospfTopologyUpdater);
            this.scheduleAndRegisterOnmsTopologyUpdater(this.m_ospfAreaTopologyUpdater);
        } else {
            this.m_ospfTopologyService.deletePersistedData();
        }
        if (this.m_linkdConfig.useBridgeDiscovery()) {
            NodeCollectionGroupIpNetToMedia nodeCollectionGroupIpNetToMedia = new NodeCollectionGroupIpNetToMedia(this.m_linkdConfig.getBridgeRescanInterval(), this.m_linkdConfig.getInitialSleepTime(), this.m_executor, this.m_linkdConfig.getBridgePriority(), this.m_queryMgr, this.m_locationAwareSnmpClient, this.m_ipNetToMediaTopologyService);
            nodeCollectionGroupIpNetToMedia.setScheduler(this.m_scheduler);
            nodeCollectionGroupIpNetToMedia.schedule();
            this.m_groups.add(nodeCollectionGroupIpNetToMedia);
            NodeCollectionGroupBridge nodeCollectionGroupBridge = new NodeCollectionGroupBridge(this.m_linkdConfig.getBridgeRescanInterval(), this.m_linkdConfig.getInitialSleepTime(), this.m_executor, this.m_linkdConfig.getBridgePriority(), this.m_queryMgr, this.m_locationAwareSnmpClient, this.m_bridgeTopologyService, this.m_linkdConfig.getMaxBft(), this.m_linkdConfig.disableBridgeVlanDiscovery());
            nodeCollectionGroupBridge.setScheduler(this.m_scheduler);
            nodeCollectionGroupBridge.schedule();
            this.m_groups.add(nodeCollectionGroupBridge);
            this.scheduleDiscoveryBridgeDomain();
            this.scheduleAndRegisterOnmsTopologyUpdater(this.m_bridgeTopologyUpdater);
        } else {
            this.m_bridgeTopologyService.deletePersistedData();
        }
    }

    public void scheduleAndRegisterOnmsTopologyUpdater(TopologyUpdater onmsTopologyUpdater) {
        onmsTopologyUpdater.setScheduler(this.m_scheduler);
        onmsTopologyUpdater.setPollInterval(this.m_linkdConfig.getTopologyInterval());
        onmsTopologyUpdater.setInitialSleepTime(0L);
        LOG.info("scheduleOnmsTopologyUpdater: Scheduling {}", (Object)onmsTopologyUpdater.getInfo());
        onmsTopologyUpdater.schedule();
        onmsTopologyUpdater.register();
    }

    public void scheduleDiscoveryBridgeDomain() {
        this.m_discoveryBridgeDomains.setScheduler(this.m_scheduler);
        this.m_discoveryBridgeDomains.setPollInterval(this.m_linkdConfig.getBridgeTopologyInterval());
        this.m_discoveryBridgeDomains.setInitialSleepTime(this.m_linkdConfig.getBridgeTopologyInterval() + this.m_linkdConfig.getInitialSleepTime());
        this.m_discoveryBridgeDomains.setMaxthreads(this.m_linkdConfig.getDiscoveryBridgeThreads());
        LOG.info("scheduleDiscoveryBridgeDomain: Scheduling {}", (Object)this.m_discoveryBridgeDomains.getInfo());
        this.m_discoveryBridgeDomains.schedule();
    }

    protected synchronized void onStart() {
        this.m_scheduler.start();
        this.m_executor.start();
    }

    protected synchronized void onStop() {
        this.m_scheduler.stop();
        this.m_scheduler = null;
        this.m_executor.stop();
    }

    protected synchronized void onPause() {
        this.m_scheduler.pause();
        this.m_executor.pause();
    }

    protected synchronized void onResume() {
        this.m_scheduler.resume();
        this.m_executor.resume();
    }

    public boolean execSingleSnmpCollection(int nodeId) {
        Node node = this.m_queryMgr.getSnmpNode(nodeId);
        if (node == null) {
            return false;
        }
        for (SchedulableNodeCollectorGroup group : this.m_groups) {
            this.m_executor.addPriorityReadyRunnable((PriorityReadyRunnable)group.getNodeCollector(node, 0));
        }
        return true;
    }

    public boolean runSingleSnmpCollection(String nodeId, String proto) {
        Node node = this.m_queryMgr.getSnmpNode(nodeId);
        if (node == null) {
            return false;
        }
        boolean runned = false;
        for (SchedulableNodeCollectorGroup group : this.m_groups) {
            if (!group.getProtocolSupported().name().equalsIgnoreCase(proto)) continue;
            group.getNodeCollector(node, 0).collect();
            runned = true;
        }
        return runned;
    }

    public boolean runSingleSnmpCollection(int nodeId) {
        Node node = this.m_queryMgr.getSnmpNode(nodeId);
        if (node == null) {
            return false;
        }
        for (SchedulableNodeCollectorGroup group : this.m_groups) {
            group.getNodeCollector(node, 0).collect();
        }
        return true;
    }

    public void runDiscoveryBridgeDomains() {
        this.m_discoveryBridgeDomains.runSchedulable();
    }

    public void forceTopologyUpdaterRun(ProtocolSupported proto) {
        switch (proto) {
            case CDP: {
                if (!this.m_linkdConfig.useCdpDiscovery()) break;
                this.m_cdpTopologyUpdater.forceRun();
                break;
            }
            case LLDP: {
                if (!this.m_linkdConfig.useLldpDiscovery()) break;
                this.m_lldpTopologyUpdater.forceRun();
                break;
            }
            case ISIS: {
                if (!this.m_linkdConfig.useIsisDiscovery()) break;
                this.m_isisTopologyUpdater.forceRun();
                break;
            }
            case OSPFAREA: {
                if (!this.m_linkdConfig.useOspfDiscovery()) break;
                this.m_ospfAreaTopologyUpdater.forceRun();
                break;
            }
            case OSPF: {
                if (!this.m_linkdConfig.useOspfDiscovery()) break;
                this.m_ospfTopologyUpdater.forceRun();
                break;
            }
            case BRIDGE: {
                if (!this.m_linkdConfig.useBridgeDiscovery()) break;
                this.m_bridgeTopologyUpdater.forceRun();
                break;
            }
            case NODES: {
                this.m_nodesTopologyUpdater.forceRun();
                break;
            }
            case USERDEFINED: {
                this.m_userDefinedLinkTopologyUpdater.forceRun();
                break;
            }
            case NETWORKROUTER: {
                this.m_networkRouterTopologyUpdater.forceRun();
                break;
            }
        }
    }

    public void runTopologyUpdater(ProtocolSupported proto) {
        switch (proto) {
            case CDP: {
                if (!this.m_linkdConfig.useCdpDiscovery()) break;
                this.m_cdpTopologyUpdater.runSchedulable();
                break;
            }
            case LLDP: {
                if (!this.m_linkdConfig.useLldpDiscovery()) break;
                this.m_lldpTopologyUpdater.runSchedulable();
                break;
            }
            case ISIS: {
                if (!this.m_linkdConfig.useIsisDiscovery()) break;
                this.m_isisTopologyUpdater.runSchedulable();
                break;
            }
            case OSPF: {
                if (!this.m_linkdConfig.useOspfDiscovery()) break;
                this.m_ospfTopologyUpdater.runSchedulable();
                break;
            }
            case OSPFAREA: {
                if (!this.m_linkdConfig.useOspfDiscovery()) break;
                this.m_ospfAreaTopologyUpdater.runSchedulable();
                break;
            }
            case BRIDGE: {
                if (!this.m_linkdConfig.useBridgeDiscovery()) break;
                this.m_bridgeTopologyUpdater.runSchedulable();
                break;
            }
            case NODES: {
                this.m_nodesTopologyUpdater.runSchedulable();
                break;
            }
            case USERDEFINED: {
                this.m_userDefinedLinkTopologyUpdater.runSchedulable();
                break;
            }
            case NETWORKROUTER: {
                this.m_networkRouterTopologyUpdater.runSchedulable();
                break;
            }
        }
    }

    public void addNode() {
        this.m_queryMgr.updatesAvailable();
    }

    void deleteNode(int nodeid) {
        LOG.info("deleteNode: deleting LinkableNode for node {}", (Object)nodeid);
        this.m_bridgeTopologyService.delete(nodeid);
        this.m_cdpTopologyService.delete(nodeid);
        this.m_isisTopologyService.delete(nodeid);
        this.m_lldpTopologyService.delete(nodeid);
        this.m_ospfTopologyService.delete(nodeid);
        this.m_ipNetToMediaTopologyService.delete(nodeid);
        this.m_queryMgr.updatesAvailable();
    }

    void suspendNodeCollection(int nodeid) {
        LOG.info("suspendNodeCollection: suspend collection LinkableNode for node {}", (Object)nodeid);
        this.m_groups.forEach(g -> g.suspend(Integer.valueOf(nodeid)));
    }

    void wakeUpNodeCollection(int nodeid) {
        LOG.info("wakeUpNodeCollection: wakeUp collection LinkableNode for node {}", (Object)nodeid);
        this.m_groups.forEach(g -> g.wakeUp(Integer.valueOf(nodeid)));
    }

    public NodeTopologyService getQueryManager() {
        return this.m_queryMgr;
    }

    public void setQueryManager(NodeTopologyService queryMgr) {
        this.m_queryMgr = queryMgr;
    }

    public LegacyScheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(LegacyScheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public EnhancedLinkdConfig getLinkdConfig() {
        return this.m_linkdConfig;
    }

    public void setLinkdConfig(EnhancedLinkdConfig config) {
        this.m_linkdConfig = config;
    }

    public String getSource() {
        return LOG_PREFIX;
    }

    public BridgeTopologyService getBridgeTopologyService() {
        return this.m_bridgeTopologyService;
    }

    public void setBridgeTopologyService(BridgeTopologyService bridgeTopologyService) {
        this.m_bridgeTopologyService = bridgeTopologyService;
    }

    public CdpTopologyService getCdpTopologyService() {
        return this.m_cdpTopologyService;
    }

    public void setCdpTopologyService(CdpTopologyService cdpTopologyService) {
        this.m_cdpTopologyService = cdpTopologyService;
    }

    public IsisTopologyService getIsisTopologyService() {
        return this.m_isisTopologyService;
    }

    public void setIsisTopologyService(IsisTopologyService isisTopologyService) {
        this.m_isisTopologyService = isisTopologyService;
    }

    public LldpTopologyService getLldpTopologyService() {
        return this.m_lldpTopologyService;
    }

    public void setLldpTopologyService(LldpTopologyService lldpTopologyService) {
        this.m_lldpTopologyService = lldpTopologyService;
    }

    public OspfTopologyService getOspfTopologyService() {
        return this.m_ospfTopologyService;
    }

    public void setOspfTopologyService(OspfTopologyService ospfTopologyService) {
        this.m_ospfTopologyService = ospfTopologyService;
    }

    public IpNetToMediaTopologyService getIpNetToMediaTopologyService() {
        return this.m_ipNetToMediaTopologyService;
    }

    public void setIpNetToMediaTopologyService(IpNetToMediaTopologyService ipNetToMediaTopologyService) {
        this.m_ipNetToMediaTopologyService = ipNetToMediaTopologyService;
    }

    public NodesOnmsTopologyUpdater getNodesTopologyUpdater() {
        return this.m_nodesTopologyUpdater;
    }

    public NetworkRouterTopologyUpdater getNetworkRouterTopologyUpdater() {
        return this.m_networkRouterTopologyUpdater;
    }

    public CdpOnmsTopologyUpdater getCdpTopologyUpdater() {
        return this.m_cdpTopologyUpdater;
    }

    public LldpOnmsTopologyUpdater getLldpTopologyUpdater() {
        return this.m_lldpTopologyUpdater;
    }

    public IsisOnmsTopologyUpdater getIsisTopologyUpdater() {
        return this.m_isisTopologyUpdater;
    }

    public BridgeOnmsTopologyUpdater getBridgeTopologyUpdater() {
        return this.m_bridgeTopologyUpdater;
    }

    public OspfOnmsTopologyUpdater getOspfTopologyUpdater() {
        return this.m_ospfTopologyUpdater;
    }

    public OspfAreaOnmsTopologyUpdater getOspfAreaTopologyUpdater() {
        return this.m_ospfAreaTopologyUpdater;
    }

    public void reload() {
        LOG.info("reload: reload enlinkd daemon service");
        this.m_groups.forEach(Schedulable::unschedule);
        this.m_groups.clear();
        if (this.m_ospfTopologyUpdater.isRegistered()) {
            this.m_ospfTopologyUpdater.unschedule();
            this.m_ospfTopologyUpdater.unregister();
            this.m_ospfTopologyUpdater = OspfOnmsTopologyUpdater.clone(this.m_ospfTopologyUpdater);
        }
        if (this.m_ospfAreaTopologyUpdater.isRegistered()) {
            this.m_ospfAreaTopologyUpdater.unschedule();
            this.m_ospfAreaTopologyUpdater.unregister();
            this.m_ospfAreaTopologyUpdater = OspfAreaOnmsTopologyUpdater.clone(this.m_ospfAreaTopologyUpdater);
        }
        if (this.m_lldpTopologyUpdater.isRegistered()) {
            this.m_lldpTopologyUpdater.unschedule();
            this.m_lldpTopologyUpdater.unregister();
            this.m_lldpTopologyUpdater = LldpOnmsTopologyUpdater.clone(this.m_lldpTopologyUpdater);
        }
        if (this.m_isisTopologyUpdater.isRegistered()) {
            this.m_isisTopologyUpdater.unschedule();
            this.m_isisTopologyUpdater.unregister();
            this.m_isisTopologyUpdater = IsisOnmsTopologyUpdater.clone(this.m_isisTopologyUpdater);
        }
        if (this.m_cdpTopologyUpdater.isRegistered()) {
            this.m_cdpTopologyUpdater.unschedule();
            this.m_cdpTopologyUpdater.unregister();
            this.m_cdpTopologyUpdater = CdpOnmsTopologyUpdater.clone(this.m_cdpTopologyUpdater);
        }
        if (this.m_bridgeTopologyUpdater.isRegistered()) {
            this.m_bridgeTopologyUpdater.unschedule();
            this.m_bridgeTopologyUpdater.unregister();
            this.m_bridgeTopologyUpdater = BridgeOnmsTopologyUpdater.clone(this.m_bridgeTopologyUpdater);
            this.m_discoveryBridgeDomains.unschedule();
            this.m_discoveryBridgeDomains = DiscoveryBridgeDomains.clone(this.m_discoveryBridgeDomains);
        }
        this.schedule(false);
    }

    public boolean reloadConfig() {
        LOG.info("reloadConfig: reload enlinkd configuration file and daemon service");
        try {
            this.m_linkdConfig.reload();
        }
        catch (IOException e) {
            LOG.error("reloadConfig: cannot reload config: {}", (Object)e.getMessage());
            return false;
        }
        this.reload();
        return true;
    }

    public void reloadTopology() {
        LOG.info("reloadTopology: reload enlinkd topology updaters");
        LOG.debug("reloadTopology: Loading Bridge Topology.....");
        this.m_bridgeTopologyService.load();
        LOG.debug("reloadTopology: Bridge Topology Loaded");
        for (ProtocolSupported protocol : ProtocolSupported.values()) {
            this.forceTopologyUpdaterRun(protocol);
            this.runTopologyUpdater(protocol);
        }
    }
}

