/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.dao.hibernate.HibernateUtils;
import org.opennms.netmgt.model.HeatMapElement;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.alarm.AlarmSummary;
import org.opennms.netmgt.model.alarm.SituationSummary;
import org.springframework.orm.hibernate3.HibernateCallback;

public class AlarmDaoHibernate
extends AbstractDaoHibernate<OnmsAlarm, Integer>
implements AlarmDao {
    public AlarmDaoHibernate() {
        super(OnmsAlarm.class);
    }

    public OnmsAlarm findByReductionKey(String reductionKey) {
        String hql = "from OnmsAlarm as alarms where alarms.reductionKey = ?";
        return (OnmsAlarm)super.findUnique(hql, reductionKey);
    }

    public List<AlarmSummary> getNodeAlarmSummariesIncludeAcknowledgedOnes(List<Integer> nodeIds) {
        if (nodeIds.isEmpty()) {
            return Collections.emptyList();
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT DISTINCT new org.opennms.netmgt.model.alarm.AlarmSummary( node.id, node.label, min(alarm.lastEventTime), max(alarm.severity), (count(*) - count(alarm.alarmAckTime)) ) ");
        sql.append("FROM OnmsAlarm AS alarm ");
        sql.append("LEFT JOIN alarm.node AS node ");
        sql.append("WHERE node.id IS NOT NULL AND alarm.severity != " + OnmsSeverity.CLEARED.getId());
        if (nodeIds.size() == 1) {
            sql.append("AND node.id = " + nodeIds.get(0) + " ");
        } else {
            sql.append("AND node.id in (");
            for (int i = 0; i < nodeIds.size(); ++i) {
                sql.append(nodeIds.get(i));
                if (i >= nodeIds.size() - 1) continue;
                sql.append(",");
            }
            sql.append(") ");
        }
        sql.append("GROUP BY node.id, node.label ");
        return this.findObjects(AlarmSummary.class, sql.toString(), new Object[0]);
    }

    public List<AlarmSummary> getNodeAlarmSummaries() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT DISTINCT new org.opennms.netmgt.model.alarm.AlarmSummary(node.id, node.label, min(alarm.lastEventTime), max(alarm.severity), count(*)) ");
        sql.append("FROM OnmsAlarm AS alarm ");
        sql.append("LEFT JOIN alarm.node AS node ");
        sql.append("WHERE node.id IS NOT NULL AND alarm.severity > 3 AND alarm.alarmAckTime IS NULL ");
        sql.append("GROUP BY node.id, node.label ");
        sql.append("ORDER BY min(alarm.lastEventTime) DESC, node.label ASC");
        return this.findObjects(AlarmSummary.class, sql.toString(), new Object[0]);
    }

    public List<SituationSummary> getSituationSummaries() {
        return (List)this.getHibernateTemplate().execute(session -> session.createSQLQuery("SELECT   a1.alarmid,   a1.severity,   string_agg(DISTINCT n2.location, ', '),  COUNT(DISTINCT n2.nodeid) AS nodeCount,   COUNT(DISTINCT s1.related_alarm_id) AS alarmCount,   MIN(a2.lastEventTime) FROM   alarms a1 JOIN alarm_situations s1 ON a1.alarmid=s1.situation_id   LEFT JOIN alarms a2 ON s1.related_alarm_id = a2.alarmid   LEFT JOIN node n2 ON a2.nodeid = n2.nodeid WHERE   a1.alarmAckTime IS NULL AND a1.severity>3 GROUP BY   a1.alarmid ORDER BY   a1.severity DESC,   COUNT(DISTINCT s1.related_alarm_id) DESC").setResultTransformer(new ResultTransformer(){

            public Object transformTuple(Object[] tuple, String[] aliases) {
                return new SituationSummary((Integer)tuple[0], OnmsSeverity.get((int)((Integer)tuple[1])), (String)tuple[2], Long.valueOf(((BigInteger)tuple[3]).longValue()), Long.valueOf(((BigInteger)tuple[4]).longValue()), (Date)tuple[5]);
            }

            public List transformList(List collection) {
                return collection;
            }
        }).list());
    }

    public List<HeatMapElement> getHeatMapItemsForEntity(final String entityNameColumn, final String entityIdColumn, boolean processAcknowledgedAlarms, final String restrictionColumn, String restrictionValue, final String ... groupByColumns) {
        Object grouping = "";
        if (groupByColumns != null && groupByColumns.length > 0) {
            for (String groupByColumn : groupByColumns) {
                if (!"".equals(grouping)) {
                    grouping = (String)grouping + ", ";
                }
                grouping = (String)grouping + groupByColumn;
            }
        } else {
            grouping = entityNameColumn + ", " + entityIdColumn;
        }
        Object groupByClause = grouping;
        final String maximumSeverityQuery = processAcknowledgedAlarms ? "max(distinct greatest(alarms.severity,3)) as maxSeverity " : "max(distinct case when alarms.alarmacktime is not null then 3 else greatest(alarms.severity,3) end) as maxSeverity ";
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<HeatMapElement>>((String)groupByClause, restrictionValue){
            final /* synthetic */ String val$groupByClause;
            final /* synthetic */ String val$restrictionValue;
            {
                this.val$groupByClause = string5;
                this.val$restrictionValue = string6;
            }

            public List<HeatMapElement> doInHibernate(Session session) throws HibernateException, SQLException {
                ArrayList<String> columns = new ArrayList<String>(Arrays.asList(groupByColumns));
                if (entityIdColumn != null) {
                    columns.add(entityIdColumn);
                }
                columns.add(entityNameColumn);
                if (restrictionColumn != null) {
                    columns.add(restrictionColumn);
                }
                HibernateUtils.validateHibernateColumnNames(session.getSessionFactory(), Lists.newArrayList((Object[])new Class[]{OnmsServiceType.class, OnmsIpInterface.class, OnmsCategory.class, OnmsMonitoredService.class, OnmsAlarm.class, OnmsNode.class}), true, columns.toArray(new String[0]));
                String queryStr = "select coalesce(" + entityNameColumn + ",'Uncategorized'), " + (entityIdColumn != null ? entityIdColumn : "0") + ", count(distinct case when ifservices.status <> 'D' then ifservices.id else null end) as servicesTotal, count(distinct node.nodeid) as nodeTotalCount, " + maximumSeverityQuery + "from node left join category_node using (nodeid) left join categories using (categoryid) left outer join ipinterface using (nodeid) left outer join ifservices on (ifservices.ipinterfaceid = ipinterface.id) left outer join service on (ifservices.serviceid = service.serviceid) left outer join alarms on (alarms.nodeid = node.nodeid and alarms.alarmtype in (1,3)) where nodeType <> 'D' " + (String)(restrictionColumn != null ? "and coalesce(" + restrictionColumn + ",'Uncategorized')=:restrictionValue " : "") + "group by " + this.val$groupByClause + " having count(distinct case when ifservices.status <> 'D' then ifservices.id else null end) > 0";
                SQLQuery query = session.createSQLQuery(queryStr);
                if (restrictionColumn != null) {
                    query.setParameter("restrictionValue", (Object)this.val$restrictionValue, (Type)StringType.INSTANCE);
                }
                query.setResultTransformer(new ResultTransformer(){
                    private static final long serialVersionUID = 5152094813503430377L;

                    public Object transformTuple(Object[] tuple, String[] aliases) {
                        return new HeatMapElement((String)tuple[0], (Number)tuple[1], (Number)tuple[2], (Number)tuple[3], (Number)tuple[4]);
                    }

                    public List transformList(List collection) {
                        return collection;
                    }
                });
                return query.list();
            }
        });
    }

    public long getNumSituations() {
        return ((BigInteger)this.getHibernateTemplate().execute(s -> (BigInteger)s.createSQLQuery("SELECT COUNT( DISTINCT situation_id ) FROM alarm_situations").uniqueResult())).longValue();
    }

    public List<OnmsAlarm> getAlarmsForEventParameters(final Map<String, String> eventParameters) {
        final StringBuffer hqlStringBuffer = new StringBuffer("From OnmsAlarm a where ");
        for (int i = 0; i < eventParameters.size(); ++i) {
            if (i > 0) {
                hqlStringBuffer.append(" and ");
            }
            hqlStringBuffer.append("exists (select p.event from OnmsEventParameter p where a.lastEvent=p.event and p.name = :name" + i + " and p.value like :value" + i + ")");
        }
        return this.getHibernateTemplate().executeFind((HibernateCallback)new HibernateCallback<List<OnmsEvent>>(){

            public List<OnmsEvent> doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hqlStringBuffer.toString());
                int i = 0;
                for (Map.Entry entry : eventParameters.entrySet()) {
                    q = q.setParameter("name" + i, entry.getKey()).setParameter("value" + i, entry.getValue());
                    ++i;
                }
                return q.list();
            }
        });
    }
}

