/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.util;

import java.net.InetAddress;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;

public class ReductionKeyHelper {
    public static final String DEFAULT_DISTRIBUTED_POLLER_NAME = "";

    public static Set<String> getReductionKeys(OnmsApplication application) {
        Objects.requireNonNull(application);
        HashSet<String> reductionKeys = new HashSet<String>();
        for (OnmsMonitoredService monitoredService : application.getMonitoredServices()) {
            reductionKeys.addAll(ReductionKeyHelper.getReductionKeys(monitoredService));
        }
        return reductionKeys;
    }

    public static Set<String> getReductionKeys(OnmsMonitoredService monitoredService) {
        Objects.requireNonNull(monitoredService);
        HashSet<String> reductionKeys = new HashSet<String>();
        reductionKeys.add(ReductionKeyHelper.getNodeLostServiceReductionKey(monitoredService));
        reductionKeys.add(ReductionKeyHelper.getNodeDownReductionKey(monitoredService));
        reductionKeys.add(ReductionKeyHelper.getInterfaceDownReductionKey(monitoredService));
        return reductionKeys;
    }

    public static String getNodeDownReductionKey(OnmsMonitoredService monitoredService) {
        return String.format("%s:%s:%d", "uei.opennms.org/nodes/nodeDown", DEFAULT_DISTRIBUTED_POLLER_NAME, monitoredService.getNodeId());
    }

    public static String getNodeLostServiceReductionKey(OnmsMonitoredService monitoredService) {
        return String.format("%s:%s:%d:%s:%s", "uei.opennms.org/nodes/nodeLostService", DEFAULT_DISTRIBUTED_POLLER_NAME, monitoredService.getNodeId(), InetAddressUtils.toIpAddrString((InetAddress)monitoredService.getIpAddress()), monitoredService.getServiceName());
    }

    public static Set<String> getNodeLostServiceFromPerspectiveReductionKeys(OnmsMonitoredService monitoredService) {
        Objects.requireNonNull(monitoredService);
        return monitoredService.getApplications().stream().flatMap(a -> a.getPerspectiveLocations().stream()).map(OnmsMonitoringLocation::getLocationName).distinct().map(locationName -> String.format("%s:%s:%d:%s:%s", "uei.opennms.org/perspective/nodes/nodeLostService", locationName, monitoredService.getNodeId(), InetAddressUtils.toIpAddrString((InetAddress)monitoredService.getIpAddress()), monitoredService.getServiceName())).collect(Collectors.toSet());
    }

    public static String getInterfaceDownReductionKey(OnmsMonitoredService monitoredService) {
        return String.format("%s:%s:%s:%s", "uei.opennms.org/nodes/interfaceDown", DEFAULT_DISTRIBUTED_POLLER_NAME, monitoredService.getNodeId(), InetAddressUtils.toIpAddrString((InetAddress)monitoredService.getIpAddress()));
    }
}

