/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.twin.grpc.publisher;

import com.google.common.base.Strings;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.BindableService;
import io.grpc.stub.StreamObserver;
import io.opentracing.Scope;
import io.opentracing.Tracer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.opennms.core.grpc.common.GrpcIpcServer;
import org.opennms.core.ipc.twin.common.AbstractTwinPublisher;
import org.opennms.core.ipc.twin.common.LocalTwinSubscriber;
import org.opennms.core.ipc.twin.common.TwinRequest;
import org.opennms.core.ipc.twin.common.TwinUpdate;
import org.opennms.core.ipc.twin.grpc.common.MinionHeader;
import org.opennms.core.ipc.twin.grpc.common.OpenNMSTwinIpcGrpc;
import org.opennms.core.ipc.twin.model.TwinRequestProto;
import org.opennms.core.ipc.twin.model.TwinResponseProto;
import org.opennms.core.logging.Logging;
import org.opennms.core.tracing.util.TracingInfoCarrier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcTwinPublisher
extends AbstractTwinPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcTwinPublisher.class);
    private final GrpcIpcServer grpcIpcServer;
    private Multimap<String, StreamObserver<TwinResponseProto>> sinkStreamsByLocation = LinkedListMultimap.create();
    private Map<String, StreamObserver<TwinResponseProto>> sinkStreamsBySystemId = new HashMap<String, StreamObserver<TwinResponseProto>>();
    private final ThreadFactory twinRpcThreadFactory = new ThreadFactoryBuilder().setNameFormat("twin-rpc-handler-%d").build();
    private final ExecutorService twinRpcExecutor = Executors.newCachedThreadPool(this.twinRpcThreadFactory);

    public GrpcTwinPublisher(LocalTwinSubscriber twinSubscriber, GrpcIpcServer grpcIpcServer) {
        super(twinSubscriber);
        this.grpcIpcServer = grpcIpcServer;
    }

    protected void handleSinkUpdate(TwinUpdate sinkUpdate) {
        this.sendTwinResponseForSink(this.mapTwinResponse(sinkUpdate));
    }

    private synchronized boolean sendTwinResponseForSink(TwinResponseProto twinResponseProto) {
        if (this.sinkStreamsByLocation.isEmpty()) {
            return false;
        }
        try {
            if (Strings.isNullOrEmpty((String)twinResponseProto.getLocation())) {
                LOG.debug("Sending sink update for key {} at all locations", (Object)twinResponseProto.getConsumerKey());
                this.sinkStreamsByLocation.values().forEach(stream -> stream.onNext((Object)twinResponseProto));
            } else {
                String location = twinResponseProto.getLocation();
                this.sinkStreamsByLocation.get((Object)location).forEach(stream -> {
                    stream.onNext((Object)twinResponseProto);
                    LOG.debug("Sending sink update for key {} at location {}", (Object)twinResponseProto.getConsumerKey(), (Object)twinResponseProto.getLocation());
                });
            }
        }
        catch (Exception e) {
            LOG.error("Error while sending Twin response for Sink stream", (Throwable)e);
        }
        return true;
    }

    public void start() throws IOException {
        try (Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"ipc");){
            this.grpcIpcServer.startServer((BindableService)new StreamHandler());
            LOG.info("Added Twin Service to OpenNMS IPC Grpc Server");
        }
    }

    public void close() throws IOException {
        try (Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"ipc");){
            this.grpcIpcServer.stopServer();
            this.twinRpcExecutor.shutdown();
            LOG.info("Stopped Twin GRPC Server");
        }
    }

    private class StreamHandler
    extends OpenNMSTwinIpcGrpc.OpenNMSTwinIpcImplBase {
        private StreamHandler() {
        }

        public StreamObserver<TwinRequestProto> rpcStreaming(StreamObserver<TwinResponseProto> responseObserver) {
            final StreamObserver<TwinResponseProto> rpcStream = responseObserver;
            return new StreamObserver<TwinRequestProto>(){

                public void onNext(TwinRequestProto twinRequestProto) {
                    CompletableFuture.runAsync(() -> {
                        try {
                            TwinRequest twinRequest = GrpcTwinPublisher.this.mapTwinRequestProto(twinRequestProto.toByteArray());
                            String tracingOperationKey = AbstractTwinPublisher.generateTracingOperationKey((String)twinRequest.getLocation(), (String)twinRequest.getKey());
                            Tracer.SpanBuilder spanBuilder = TracingInfoCarrier.buildSpanFromTracingMetadata((Tracer)GrpcTwinPublisher.this.getTracer(), (String)tracingOperationKey, (Map)twinRequest.getTracingInfo(), (String)"follows_from");
                            try (Scope scope = spanBuilder.startActive(true);){
                                TwinUpdate twinUpdate = GrpcTwinPublisher.this.getTwin(twinRequest);
                                GrpcTwinPublisher.this.addTracingInfo(scope.span(), twinUpdate);
                                TwinResponseProto twinResponseProto = GrpcTwinPublisher.this.mapTwinResponse(twinUpdate);
                                LOG.debug("Sent Twin response for key {} at location {}", (Object)twinRequest.getKey(), (Object)twinRequest.getLocation());
                                StreamHandler.this.sendTwinResponse(twinResponseProto, (StreamObserver<TwinResponseProto>)rpcStream);
                            }
                        }
                        catch (Exception e) {
                            LOG.error("Exception while processing request", (Throwable)e);
                        }
                    }, GrpcTwinPublisher.this.twinRpcExecutor);
                }

                public void onError(Throwable throwable) {
                    LOG.error("Error in Rpc stream handler", throwable);
                }

                public void onCompleted() {
                    LOG.info("Closed Rpc Stream handler");
                }
            };
        }

        private synchronized void sendTwinResponse(TwinResponseProto twinResponseProto, StreamObserver<TwinResponseProto> rpcStream) {
            if (rpcStream != null) {
                rpcStream.onNext((Object)twinResponseProto);
            }
        }

        private synchronized void handleSinkStreamUpdate(MinionHeader request, StreamObserver<TwinResponseProto> responseObserver) {
            if (GrpcTwinPublisher.this.sinkStreamsBySystemId.containsKey(request.getSystemId())) {
                StreamObserver<TwinResponseProto> sinkStream = GrpcTwinPublisher.this.sinkStreamsBySystemId.remove(request.getSystemId());
                GrpcTwinPublisher.this.sinkStreamsByLocation.remove((Object)request.getLocation(), sinkStream);
            }
            GrpcTwinPublisher.this.sinkStreamsByLocation.put((Object)request.getLocation(), responseObserver);
            GrpcTwinPublisher.this.sinkStreamsBySystemId.put(request.getSystemId(), responseObserver);
            GrpcTwinPublisher.this.forEachSession((sessionKey, twinTracker) -> {
                if (sessionKey.location == null || sessionKey.location.equals(request.getLocation())) {
                    TwinUpdate twinUpdate = new TwinUpdate(sessionKey.key, sessionKey.location, twinTracker.getObj());
                    twinUpdate.setSessionId(twinTracker.getSessionId());
                    twinUpdate.setVersion(twinTracker.getVersion());
                    twinUpdate.setPatch(false);
                    TwinResponseProto twinResponseProto = GrpcTwinPublisher.this.mapTwinResponse(twinUpdate);
                    responseObserver.onNext((Object)twinResponseProto);
                }
            });
        }

        public void sinkStreaming(MinionHeader request, StreamObserver<TwinResponseProto> responseObserver) {
            this.handleSinkStreamUpdate(request, responseObserver);
        }
    }
}

