/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import org.opennms.netmgt.enlinkd.model.IsIsLink;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisISAdjTableTracker
extends TableTracker {
    private static final Logger LOG = LoggerFactory.getLogger(IsisISAdjTableTracker.class);
    public static final SnmpObjId ISIS_IS_ADJ_STATE_OID = SnmpObjId.get((String)".1.3.6.1.2.1.138.1.6.1.1.2");
    public static final SnmpObjId ISIS_IS_ADJ_NBR_SNPAADDR_OID = SnmpObjId.get((String)".1.3.6.1.2.1.138.1.6.1.1.4");
    public static final SnmpObjId ISIS_IS_ADJ_NBR_SYSTYPE_OID = SnmpObjId.get((String)".1.3.6.1.2.1.138.1.6.1.1.5");
    public static final SnmpObjId ISIS_IS_ADJ_NBR_SYSID_OID = SnmpObjId.get((String)".1.3.6.1.2.1.138.1.6.1.1.6");
    public static final SnmpObjId ISIS_IS_ADJ_NBR_EXTENDED_CIRCID_OID = SnmpObjId.get((String)".1.3.6.1.2.1.138.1.6.1.1.7");
    public static final String ISIS_IS_ADJ_STATE = "isisISAdjState";
    public static final String ISIS_IS_ADJ_NBR_SNPAADDR = "isisISAdjNeighSNPAAddress";
    public static final String ISIS_IS_ADJ_NBR_SYSTYPE = "isisISAdjNeighSysType";
    public static final String ISIS_IS_ADJ_NBR_SYSID = "isisISAdjNeighSysID";
    public static final String ISIS_IS_ADJ_NBR_EXTENDED_CIRCID = "isisISAdjNbrExtendedCircID";
    public static final SnmpObjId[] isisIsAdjtable_elemList = new SnmpObjId[]{ISIS_IS_ADJ_STATE_OID, ISIS_IS_ADJ_NBR_SNPAADDR_OID, ISIS_IS_ADJ_NBR_SYSTYPE_OID, ISIS_IS_ADJ_NBR_SYSID_OID, ISIS_IS_ADJ_NBR_EXTENDED_CIRCID_OID};

    public IsisISAdjTableTracker() {
        super(isisIsAdjtable_elemList);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new IsIsAdjRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processIsisAdjRow((IsIsAdjRow)row);
    }

    public void processIsisAdjRow(IsIsAdjRow row) {
        System.out.printf("\t\t%s (%s)= %s (%s)\n", ISIS_IS_ADJ_STATE_OID + "." + row.getInstance().toString(), ISIS_IS_ADJ_STATE, row.getIsisISAdjStatus(), IsIsLink.IsisISAdjState.getTypeString((Integer)row.getIsisISAdjStatus()));
        System.out.printf("\t\t%s (%s)= %s \n", ISIS_IS_ADJ_NBR_SNPAADDR_OID + "." + row.getInstance().toString(), ISIS_IS_ADJ_NBR_SNPAADDR, row.getIsisISAdjNeighSnpaAddress());
        System.out.printf("\t\t%s (%s)= %s (%s)\n", ISIS_IS_ADJ_NBR_SYSTYPE_OID + "." + row.getInstance().toString(), ISIS_IS_ADJ_NBR_SYSTYPE, row.getIsisISAdjNeighSysType(), IsIsLink.IsisISAdjNeighSysType.getTypeString((Integer)row.getIsisISAdjNeighSysType()));
        System.out.printf("\t\t%s (%s)= %s \n", ISIS_IS_ADJ_NBR_SYSID_OID + "." + row.getInstance().toString(), ISIS_IS_ADJ_NBR_SYSID, row.getIsisISAdjNeighSysID());
        System.out.printf("\t\t%s (%s)= %s \n", ISIS_IS_ADJ_NBR_EXTENDED_CIRCID_OID + "." + row.getInstance().toString(), ISIS_IS_ADJ_NBR_EXTENDED_CIRCID, row.getIsisISAdjNbrExtendedCircID());
    }

    public static class IsIsAdjRow
    extends SnmpRowResult {
        public IsIsAdjRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
            LOG.debug("column count = {}, instance = {}", (Object)columnCount, (Object)instance);
        }

        public Integer getIsisCircIndex() {
            return this.getInstance().getSubIdAt(0);
        }

        public Integer getIsisISAdjIndex() {
            return this.getInstance().getLastSubId();
        }

        public Integer getIsisISAdjStatus() {
            return this.getValue(ISIS_IS_ADJ_STATE_OID).toInt();
        }

        public String getIsisISAdjNeighSnpaAddress() {
            return this.getValue(ISIS_IS_ADJ_NBR_SNPAADDR_OID).toHexString();
        }

        public Integer getIsisISAdjNeighSysType() {
            return this.getValue(ISIS_IS_ADJ_NBR_SYSTYPE_OID).toInt();
        }

        public String getIsisISAdjNeighSysID() {
            return this.getValue(ISIS_IS_ADJ_NBR_SYSID_OID).toHexString();
        }

        public Integer getIsisISAdjNbrExtendedCircID() {
            return this.getValue(ISIS_IS_ADJ_NBR_EXTENDED_CIRCID_OID).toInt();
        }

        public IsIsLink getIsisLink() {
            LOG.debug("getIsisLink: row count: {}", (Object)this.getColumnCount());
            IsIsLink link = new IsIsLink();
            link.setIsisCircIndex(this.getIsisCircIndex());
            link.setIsisISAdjIndex(this.getIsisISAdjIndex());
            link.setIsisISAdjState(IsIsLink.IsisISAdjState.get((Integer)this.getIsisISAdjStatus()));
            link.setIsisISAdjNeighSNPAAddress(this.getIsisISAdjNeighSnpaAddress());
            link.setIsisISAdjNeighSysType(IsIsLink.IsisISAdjNeighSysType.get((Integer)this.getIsisISAdjNeighSysType()));
            link.setIsisISAdjNeighSysID(this.getIsisISAdjNeighSysID());
            link.setIsisISAdjNbrExtendedCircID(this.getIsisISAdjNbrExtendedCircID());
            LOG.debug("getIsisLink: Circ Index: {}, Adj Index: {}, Adj State: {}, Adj Neigh SNPA Address: {},\n Adj Neigh Sys Type: {}, Adj Neigh Sys ID: {}, Adj Nbr Extended Circ ID: {}", new Object[]{link.getIsisCircIndex(), link.getIsisISAdjIndex(), IsIsLink.IsisISAdjState.getTypeString((Integer)this.getIsisISAdjStatus()), link.getIsisISAdjNeighSNPAAddress(), IsIsLink.IsisISAdjNeighSysType.getTypeString((Integer)this.getIsisISAdjNeighSysType()), link.getIsisISAdjNeighSysID(), link.getIsisISAdjNbrExtendedCircID()});
            return link;
        }
    }
}

