/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.geocoder.service;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.osgi.service.cm.Configuration;

public class ConfigurationWrapper {
    private final Configuration configuration;

    public ConfigurationWrapper(Configuration configuration) {
        this.configuration = configuration;
    }

    public void update(Map<String, Object> newProperties) throws IOException {
        Hashtable<String, Object> currentProperties;
        Dictionary dictionary = currentProperties = this.configuration.getProperties() == null ? new Hashtable() : this.configuration.getProperties();
        if (!Objects.equals(currentProperties, newProperties)) {
            ConfigurationWrapper.applyProperties(currentProperties, newProperties);
            ConfigurationWrapper.saveToDisk(this.configuration.getPid(), currentProperties);
            this.configuration.update(currentProperties);
        }
    }

    public void delete() throws IOException {
        String configPid = this.configuration.getPid();
        this.configuration.delete();
        Path configFile = ConfigurationWrapper.getConfigFile(configPid);
        Files.deleteIfExists(configFile);
    }

    private static Path getConfigFile(String configPID) {
        Path configFile = Paths.get(System.getProperty("karaf.etc"), configPID + ".cfg");
        return configFile;
    }

    private static void saveToDisk(String configPID, Dictionary<String, Object> currentProperties) throws IOException {
        if (currentProperties.get("felix.fileinstall.filename") == null) {
            Path configFile = ConfigurationWrapper.getConfigFile(configPID);
            Properties persistentProperties = new Properties();
            Enumeration<String> keyEnumerator = currentProperties.keys();
            while (keyEnumerator.hasMoreElements()) {
                String key;
                Object value = currentProperties.get(key = keyEnumerator.nextElement());
                persistentProperties.put(key, value == null ? value : value.toString());
            }
            persistentProperties.store(new FileOutputStream(configFile.toFile()), null);
        }
    }

    private static void applyProperties(Dictionary<String, Object> currentProperties, Map<String, Object> newProperties) {
        newProperties.entrySet().forEach(e -> {
            if (e.getValue() == null) {
                currentProperties.remove(e.getKey());
            } else {
                currentProperties.put((String)e.getKey(), e.getValue().toString());
            }
        });
    }
}

