/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import org.opennms.core.mate.api.EntityScopeProvider;
import org.opennms.core.mate.api.Interpolator;
import org.opennms.core.mate.api.Scope;
import org.opennms.netmgt.provision.service.Provisioner;
import org.opennms.netmgt.provision.service.operations.ProvisionMonitor;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.util.Assert;

public class ImportJob
implements Job {
    private Provisioner provisioner;
    protected static final String URL = "url";
    protected static final String RESCAN_EXISTING = "rescanExisting";
    protected static final String MONITOR = "monitor";
    private ProvisionMonitor provisionMonitor;
    private EntityScopeProvider entityScopeProvider;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            String url = Interpolator.interpolate((String)context.getJobDetail().getJobDataMap().getString((String)URL), (Scope)this.entityScopeProvider.getScopeForScv()).output;
            Assert.notNull((Object)url);
            Assert.notNull((Object)this.provisionMonitor);
            String rescanExisting = context.getJobDetail().getJobDataMap().getString(RESCAN_EXISTING);
            this.getProvisioner().doImport(url, rescanExisting == null ? Boolean.TRUE.toString() : rescanExisting, this.provisionMonitor);
        }
        catch (Exception t) {
            throw new JobExecutionException((Throwable)t);
        }
    }

    public void setProvisioner(Provisioner provisioner) {
        this.provisioner = provisioner;
    }

    Provisioner getProvisioner() {
        return this.provisioner;
    }

    public void setMonitor(ProvisionMonitor provisionMonitor) {
        this.provisionMonitor = provisionMonitor;
    }

    public EntityScopeProvider getEntityScopeProvider() {
        return this.entityScopeProvider;
    }

    public void setEntityScopeProvider(EntityScopeProvider entityScopeProvider) {
        this.entityScopeProvider = entityScopeProvider;
    }
}

